/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DeferrableChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.OrderedChangeObject;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionChangeRecord
extends DeferrableChangeRecord
implements org.eclipse.persistence.sessions.changesets.CollectionChangeRecord {
    protected Map<ObjectChangeSet, ObjectChangeSet> addObjectList;
    protected transient List<ObjectChangeSet> orderedAddObjects;
    protected Map<ObjectChangeSet, Integer> orderedAddObjectIndices;
    protected List<OrderedChangeObject> orderedChangeObjectList;
    protected Map<Integer, ObjectChangeSet> orderedRemoveObjects;
    protected transient List<Integer> orderedRemoveObjectIndices;
    protected transient List<ObjectChangeSet> addOverFlow;
    protected Map<ObjectChangeSet, ObjectChangeSet> removeObjectList;
    protected boolean orderHasBeenRepaired;

    public CollectionChangeRecord() {
    }

    public CollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    public void addAdditionChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        Iterator enumtr = objectChanges.values().iterator();
        while (enumtr.hasNext()) {
            Object object = cp.unwrapElement(enumtr.next());
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            if (change.hasKeys()) {
                this.getAddObjectList().put(change, change);
                continue;
            }
            if (this.getRemoveObjectList().containsKey(change)) {
                this.getRemoveObjectList().remove(change);
                continue;
            }
            this.getAddObjectList().put(change, change);
        }
    }

    public void addOrderedAdditionChange(List<Object> orderedObjectsToAdd, Map<Object, Integer> objectChangesIndices, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        for (Object object : orderedObjectsToAdd) {
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedAddObjects().add(change);
            this.getOrderedAddObjectIndices().put(change, objectChangesIndices.get(object));
        }
    }

    public void addOrderedRemoveChange(List<Integer> indicesToRemove, Map objectChanges, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        this.orderedRemoveObjectIndices = indicesToRemove;
        for (Integer index : indicesToRemove) {
            Object object = objectChanges.get(index);
            ObjectChangeSet change = session.getDescriptor(object.getClass()).getObjectBuilder().createObjectChangeSet(object, changeSet, session);
            this.getOrderedRemoveObjects().put(index, change);
        }
    }

    public void addRemoveChange(Map objectChanges, ContainerPolicy cp, UnitOfWorkChangeSet changeSet, AbstractSession session) {
        if (objectChanges.isEmpty()) {
            return;
        }
        ClassDescriptor descriptor = this.mapping.getReferenceDescriptor();
        boolean hasChildren = descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren();
        Iterator enumtr = cp.getChangeValuesFrom(objectChanges);
        while (enumtr.hasNext()) {
            ObjectChangeSet change;
            Object object = cp.unwrapElement(enumtr.next());
            if (hasChildren) {
                descriptor = this.getReferenceDescriptor(object, session);
            }
            if ((change = descriptor.getObjectBuilder().createObjectChangeSet(object, changeSet, session)).hasKeys()) {
                this.getRemoveObjectList().put(change, change);
                continue;
            }
            if (this.getAddObjectList().containsKey(change)) {
                this.getAddObjectList().remove(change);
                continue;
            }
            this.getRemoveObjectList().put(change, change);
        }
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getAddObjectList() {
        if (this.addObjectList == null) {
            this.addObjectList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(10);
        }
        return this.addObjectList;
    }

    public List<ObjectChangeSet> getAddOverFlow() {
        if (this.addOverFlow == null) {
            this.addOverFlow = new ArrayList<ObjectChangeSet>();
        }
        return this.addOverFlow;
    }

    ClassDescriptor getReferenceDescriptor(Object object, AbstractSession session) {
        return session.getClassDescriptor(object);
    }

    @Override
    public Map<ObjectChangeSet, ObjectChangeSet> getRemoveObjectList() {
        if (this.removeObjectList == null) {
            this.removeObjectList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>();
        }
        return this.removeObjectList;
    }

    @Override
    public boolean hasChanges() {
        return this.addObjectList != null && !this.addObjectList.isEmpty() || this.removeObjectList != null && !this.removeObjectList.isEmpty() || this.orderedAddObjects != null && !this.orderedAddObjects.isEmpty() || this.orderedRemoveObjects != null && !this.orderedRemoveObjects.isEmpty() || this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty() || this.getOwner().isNew();
    }

    @Override
    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        if (((DeferrableChangeRecord)mergeFromRecord).isDeferred()) {
            if (this.hasChanges()) {
                ((DeferrableChangeRecord)mergeFromRecord).getMapping().calculateDeferredChanges(mergeFromRecord, mergeToChangeSet.getSession());
            } else {
                if (!this.isDeferred) {
                    this.originalCollection = ((DeferrableChangeRecord)mergeFromRecord).originalCollection;
                }
                this.isDeferred = true;
                this.latestCollection = ((DeferrableChangeRecord)mergeFromRecord).latestCollection;
                return;
            }
        }
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getAddObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getRemoveObjectList().containsKey(localChangeSet)) {
                this.getRemoveObjectList().remove(localChangeSet);
                continue;
            }
            this.getAddObjectList().put(localChangeSet, localChangeSet);
        }
        for (ObjectChangeSet mergingObject : ((CollectionChangeRecord)mergeFromRecord).getRemoveObjectList().keySet()) {
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            if (this.getAddObjectList().containsKey(localChangeSet)) {
                this.getAddObjectList().remove(localChangeSet);
                continue;
            }
            this.getRemoveObjectList().put(localChangeSet, localChangeSet);
        }
        for (OrderedChangeObject changeObject : ((CollectionChangeRecord)mergeFromRecord).getOrderedChangeObjectList()) {
            ObjectChangeSet mergingObject = changeObject.getChangeSet();
            ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(mergingObject, mergeFromChangeSet);
            OrderedChangeObject orderedChangeObject = new OrderedChangeObject(changeObject.getChangeType(), changeObject.getIndex(), localChangeSet);
            this.getOrderedChangeObjectList().add(orderedChangeObject);
        }
    }

    public void setAddObjectList(Map<ObjectChangeSet, ObjectChangeSet> objectChangesList) {
        this.addObjectList = objectChangesList;
    }

    public void setRemoveObjectList(Map<ObjectChangeSet, ObjectChangeSet> objectChangesList) {
        this.removeObjectList = objectChangesList;
    }

    @Override
    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> addList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getAddObjectList().size() + 1);
        IdentityHashMap<ObjectChangeSet, ObjectChangeSet> removeList = new IdentityHashMap<ObjectChangeSet, ObjectChangeSet>(this.getRemoveObjectList().size() + 1);
        if (this.getOrderedAddObjects().size() > 0 || this.getOrderedRemoveObjectIndices().size() > 0) {
            ArrayList<ObjectChangeSet> orderedAddList = new ArrayList<ObjectChangeSet>(this.getOrderedAddObjects().size());
            IdentityHashMap<ObjectChangeSet, Integer> orderedAddListIndices = new IdentityHashMap<ObjectChangeSet, Integer>(this.getOrderedAddObjectIndices().size());
            for (int i = 0; i < this.getOrderedAddObjects().size(); ++i) {
                ObjectChangeSet changeSet = this.getOrderedAddObjects().get(i);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedAddList.add(localChangeSet);
                orderedAddListIndices.put(localChangeSet, this.getOrderedAddObjectIndices().get(changeSet));
                if (!this.getAddObjectList().containsKey(changeSet)) continue;
                addList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedAddObjects(orderedAddList);
            this.setOrderedAddObjectIndices(orderedAddListIndices);
            HashMap<Integer, ObjectChangeSet> orderedRemoveList = new HashMap<Integer, ObjectChangeSet>(this.getOrderedRemoveObjects().size());
            for (Integer index : this.getOrderedRemoveObjects().keySet()) {
                ObjectChangeSet changeSet = this.getOrderedRemoveObjects().get(index);
                ObjectChangeSet localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changeSet, mergeFromChangeSet);
                orderedRemoveList.put(index, localChangeSet);
                if (!this.getRemoveObjectList().containsKey(changeSet)) continue;
                removeList.put(localChangeSet, localChangeSet);
            }
            this.setOrderedRemoveObjects(orderedRemoveList);
        } else {
            ObjectChangeSet localChangeSet;
            Iterator<ObjectChangeSet> changes = this.getAddObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changes.next(), mergeFromChangeSet);
                addList.put(localChangeSet, localChangeSet);
            }
            changes = this.getRemoveObjectList().values().iterator();
            while (changes.hasNext()) {
                localChangeSet = mergeToChangeSet.findOrIntegrateObjectChangeSet(changes.next(), mergeFromChangeSet);
                removeList.put(localChangeSet, localChangeSet);
            }
        }
        this.setAddObjectList(addList);
        this.setRemoveObjectList(removeList);
    }

    public List<ObjectChangeSet> getOrderedAddObjects() {
        if (this.orderedAddObjects == null) {
            this.orderedAddObjects = new ArrayList<ObjectChangeSet>();
        }
        return this.orderedAddObjects;
    }

    public Integer getOrderedAddObjectIndex(ObjectChangeSet changes) {
        return this.getOrderedAddObjectIndices().get(changes);
    }

    public Map<ObjectChangeSet, Integer> getOrderedAddObjectIndices() {
        if (this.orderedAddObjectIndices == null) {
            this.orderedAddObjectIndices = new IdentityHashMap<ObjectChangeSet, Integer>();
        }
        return this.orderedAddObjectIndices;
    }

    public List<OrderedChangeObject> getOrderedChangeObjectList() {
        if (this.orderedChangeObjectList == null) {
            this.orderedChangeObjectList = new ArrayList<OrderedChangeObject>();
        }
        return this.orderedChangeObjectList;
    }

    public List<Integer> getOrderedRemoveObjectIndices() {
        if (this.orderedRemoveObjectIndices == null) {
            this.orderedRemoveObjectIndices = new ArrayList<Integer>();
        }
        return this.orderedRemoveObjectIndices;
    }

    public Object getOrderedRemoveObject(Integer index) {
        return this.getOrderedRemoveObjects().get(index);
    }

    public Map<Integer, ObjectChangeSet> getOrderedRemoveObjects() {
        if (this.orderedRemoveObjects == null) {
            this.orderedRemoveObjects = new HashMap<Integer, ObjectChangeSet>();
        }
        return this.orderedRemoveObjects;
    }

    public void setOrderedAddObjectIndices(Map<ObjectChangeSet, Integer> orderedAddObjectIndices) {
        this.orderedAddObjectIndices = orderedAddObjectIndices;
    }

    public void setOrderedAddObjects(List<ObjectChangeSet> orderedAddObjects) {
        this.orderedAddObjects = orderedAddObjects;
    }

    public void setOrderedChangeObjectList(List<OrderedChangeObject> orderedChangeObjectList) {
        this.orderedChangeObjectList = orderedChangeObjectList;
    }

    public void setOrderedRemoveObjects(Map<Integer, ObjectChangeSet> orderedRemoveObjects) {
        this.orderedRemoveObjects = orderedRemoveObjects;
    }

    public List<Integer> getCurrentIndexesOfOriginalObjects(List newList) {
        int i;
        int newSize = newList.size();
        ArrayList<Integer> currentIndexes = new ArrayList<Integer>(newSize);
        for (i = 0; i < newSize; ++i) {
            currentIndexes.add(i);
        }
        if (this.orderedChangeObjectList != null) {
            for (i = this.orderedChangeObjectList.size() - 1; i >= 0; --i) {
                OrderedChangeObject orderedChange = this.orderedChangeObjectList.get(i);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == CollectionChangeEvent.ADD) {
                    if (index == null) {
                        currentIndexes.remove(currentIndexes.size() - 1);
                        continue;
                    }
                    currentIndexes.remove(index);
                    continue;
                }
                if (changeType != CollectionChangeEvent.REMOVE) continue;
                if (index == null) {
                    throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                }
                currentIndexes.add(index, newList.indexOf(obj));
            }
        }
        return currentIndexes;
    }

    @Override
    public void internalRecreateOriginalCollection(Object currentCollection, AbstractSession session) {
        block8: {
            block7: {
                ContainerPolicy cp = this.mapping.getContainerPolicy();
                if (this.orderedChangeObjectList != null && !this.orderedChangeObjectList.isEmpty()) break block7;
                if (this.removeObjectList != null) {
                    for (ObjectChangeSet changeSet : this.removeObjectList.keySet()) {
                        cp.addInto(changeSet.getUnitOfWorkClone(), currentCollection, session);
                    }
                }
                if (this.addObjectList == null) break block8;
                for (ObjectChangeSet changeSet : this.addObjectList.keySet()) {
                    cp.removeFrom(changeSet.getUnitOfWorkClone(), currentCollection, session);
                }
                break block8;
            }
            List originalList = (List)currentCollection;
            for (int i = this.orderedChangeObjectList.size() - 1; i >= 0; --i) {
                OrderedChangeObject orderedChange = this.orderedChangeObjectList.get(i);
                Object obj = orderedChange.getAddedOrRemovedObject();
                Integer index = orderedChange.getIndex();
                int changeType = orderedChange.getChangeType();
                if (changeType == CollectionChangeEvent.ADD) {
                    if (index == null) {
                        originalList.remove(originalList.size() - 1);
                        continue;
                    }
                    originalList.remove(index);
                    continue;
                }
                if (changeType != CollectionChangeEvent.REMOVE) continue;
                if (index == null) {
                    throw ValidationException.collectionRemoveEventWithNoIndex(this.getMapping());
                }
                originalList.add(index, obj);
            }
        }
    }

    public void setOrderHasBeenRepaired(boolean hasBeenRepaired) {
        this.orderHasBeenRepaired = hasBeenRepaired;
    }

    public boolean orderHasBeenRepaired() {
        return this.orderHasBeenRepaired;
    }

    @Override
    public void clearChanges() {
        if (this.orderedChangeObjectList != null) {
            this.orderedChangeObjectList.clear();
        }
        if (this.removeObjectList != null) {
            this.removeObjectList.clear();
        }
        if (this.addObjectList != null) {
            this.addObjectList.clear();
        }
    }
}

