/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.script.lexer;

import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.cnd.api.script.BatTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;

class BatLexer
implements Lexer<BatTokenId> {
    private static Set<String> keywords = new HashSet<String>();
    private static Set<String> commands = new HashSet<String>();
    private LexerRestartInfo<BatTokenId> info;

    BatLexer(LexerRestartInfo<BatTokenId> info) {
        this.info = info;
    }

    public Token<BatTokenId> nextToken() {
        LexerInput input = this.info.input();
        int i = input.read();
        switch (i) {
            case -1: {
                return null;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 96: 
            case 123: 
            case 124: 
            case 125: {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.OPERATOR);
            }
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                while ((i = input.read()) == 32 || i == 10 || i == 13 || i == 9) {
                }
                if (i != -1) {
                    input.backup(1);
                }
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.WHITESPACE);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                while ((i = input.read()) >= 48 && i <= 57) {
                }
                if (i == 46) {
                    while ((i = input.read()) >= 48 && i <= 57) {
                    }
                }
                input.backup(1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.NUMBER);
            }
            case 34: {
                do {
                    if ((i = input.read()) == 94) {
                        i = input.read();
                        i = input.read();
                    }
                    if (i != 34) continue;
                    i = input.read();
                    if (i == 34) {
                        i = input.read();
                        continue;
                    }
                    input.backup(1);
                    break;
                } while (i != 34 && i != 10 && i != 13 && i != -1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.STRING);
            }
            case 39: {
                do {
                    if ((i = input.read()) != 92) continue;
                    i = input.read();
                    i = input.read();
                } while (i != 39 && i != 10 && i != 13 && i != -1);
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.STRING);
            }
        }
        if (i >= 97 && i <= 122 || i >= 65 && i <= 90) {
            while ((i = input.read()) >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 95 || i == 45 || i == 126) {
            }
            input.backup(1);
            String id = ((Object)input.readText()).toString();
            String lcid = id.toLowerCase();
            if (keywords.contains(lcid)) {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.KEYWORD);
            }
            if (commands.contains(lcid)) {
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.COMMAND);
            }
            if ("rem".equals(lcid)) {
                while ((i = input.read()) != 10 && i != 13 && i != -1) {
                }
                return this.info.tokenFactory().createToken((TokenId)BatTokenId.COMMENT);
            }
            return this.info.tokenFactory().createToken((TokenId)BatTokenId.IDENTIFIER);
        }
        return this.info.tokenFactory().createToken((TokenId)BatTokenId.ERROR);
    }

    public Object state() {
        return null;
    }

    public void release() {
    }

    static {
        keywords.add("aux");
        keywords.add("call");
        keywords.add("choice");
        keywords.add("defined");
        keywords.add("do");
        keywords.add("else");
        keywords.add("errorlevel");
        keywords.add("exist");
        keywords.add("endlocal");
        keywords.add("for");
        keywords.add("goto");
        keywords.add("if");
        keywords.add("in");
        keywords.add("not");
        keywords.add("nul");
        keywords.add("set");
        keywords.add("setlocal");
        keywords.add("shift");
        keywords.add("prn");
        commands.add("assign");
        commands.add("attrib");
        commands.add("cd");
        commands.add("chdir");
        commands.add("chkdsk");
        commands.add("cls");
        commands.add("comp");
        commands.add("copy");
        commands.add("date");
        commands.add("defrag");
        commands.add("del");
        commands.add("deltree");
        commands.add("dir");
        commands.add("echo");
        commands.add("echo.");
        commands.add("erase");
        commands.add("exit");
        commands.add("fc");
        commands.add("fdisk");
        commands.add("find");
        commands.add("format");
        commands.add("help");
        commands.add("label");
        commands.add("md");
        commands.add("mem");
        commands.add("memmaker");
        commands.add("mkdir");
        commands.add("more");
        commands.add("move");
        commands.add("path");
        commands.add("pause");
        commands.add("ren");
        commands.add("rename");
        commands.add("rd");
        commands.add("rmdir");
        commands.add("sort");
        commands.add("time");
        commands.add("tree");
        commands.add("type");
        commands.add("undelete");
        commands.add("ver");
        commands.add("xcopy");
    }
}

