/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.ListBuffer;
import java.util.HashMap;
import java.util.Map;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private JCDiagnostic.DiagnosticPosition currentPos;
    private Map<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>> loggersQueue = new HashMap<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>>();
    public static final DeferredLintHandler immediateHandler = new DeferredLintHandler(){

        public void report(LintLogger logger) {
            logger.report();
        }

        public DeferredLintHandler setPos(JCDiagnostic.DiagnosticPosition currentPos) {
            ((DeferredLintHandler)this).currentPos = currentPos;
            return this;
        }
    };

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler instance = context.get(deferredLintHandlerKey);
        if (instance == null) {
            instance = new DeferredLintHandler(context);
        }
        return instance;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
    }

    private DeferredLintHandler() {
    }

    public void report(LintLogger logger) {
        ListBuffer<LintLogger> loggers = this.loggersQueue.get(this.currentPos);
        Assert.checkNonNull(loggers);
        loggers.append(logger);
    }

    public void flush(JCDiagnostic.DiagnosticPosition pos) {
        ListBuffer<LintLogger> loggers = this.loggersQueue.get(pos);
        if (loggers != null) {
            for (LintLogger lintLogger : loggers) {
                lintLogger.report();
            }
            this.loggersQueue.remove(pos);
        }
    }

    public JCDiagnostic.DiagnosticPosition getPos() {
        return this.currentPos;
    }

    public DeferredLintHandler setPos(JCDiagnostic.DiagnosticPosition currentPos) {
        this.currentPos = currentPos;
        if (!this.loggersQueue.containsKey(currentPos)) {
            this.loggersQueue.put(currentPos, ListBuffer.lb());
        }
        return this;
    }

    public static interface LintLogger {
        public void report();
    }
}

