/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.refactoring;

import java.awt.Image;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.util.ImageUtilities;

class ArtifactTreeElement
implements TreeElement {
    private static final Logger LOG = Logger.getLogger(ArtifactTreeElement.class.getName());
    private final NBVersionInfo art;

    ArtifactTreeElement(NBVersionInfo art) {
        this.art = art;
    }

    public TreeElement getParent(boolean isLogical) {
        if (!this.art.getVersion().isEmpty()) {
            return TreeElementFactory.getTreeElement((Object)new NBVersionInfo(this.art.getRepoId(), this.art.getGroupId(), this.art.getArtifactId(), "", null, null, null, null, null));
        }
        if (!this.art.getArtifactId().isEmpty()) {
            return TreeElementFactory.getTreeElement((Object)new NBVersionInfo(this.art.getRepoId(), this.art.getGroupId(), "", "", null, null, null, null, null));
        }
        RepositoryInfo repo = RepositoryPreferences.getInstance().getRepositoryInfoById(this.art.getRepoId());
        return repo != null ? TreeElementFactory.getTreeElement((Object)repo) : null;
    }

    public Icon getIcon() {
        if (!this.art.getVersion().isEmpty()) {
            try {
                Project p = FileOwnerQuery.getOwner((URI)RepositoryUtil.downloadArtifact((NBVersionInfo)this.art).toURI());
                if (p != null) {
                    return ProjectUtils.getInformation((Project)p).getIcon();
                }
            }
            catch (Exception x) {
                LOG.log(Level.FINE, null, "could not check project icon for " + this.art);
            }
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/repository/DependencyJar.gif", (boolean)true);
        }
        if (!this.art.getArtifactId().isEmpty()) {
            return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/repository/ArtifactBadge.png", (boolean)true);
        }
        return ImageUtilities.image2Icon((Image)NodeUtils.getTreeFolderIcon((boolean)false));
    }

    public String getText(boolean isLogical) {
        if (!this.art.getVersion().isEmpty()) {
            return this.art.getVersion();
        }
        if (!this.art.getArtifactId().isEmpty()) {
            return this.art.getArtifactId();
        }
        return this.art.getGroupId();
    }

    public Object getUserObject() {
        return this.art;
    }
}

