/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.classdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.javon.JavonProfileProvider;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class ClassDataRegistry {
    public static final String DEFAULT_PROFILE = "default";
    public static final String ALL_JAVA_PROFILE = "alljava";
    private List<ClasspathInfo> classpaths;
    private Set<ClassData> typeMap = null;
    private Map<String, ClassData> baseClasses = null;
    private Map<ClassData, Integer> idMapping = new HashMap<ClassData, Integer>();
    private JavonProfileProvider profileProvider;
    private static final Comparator<ClassData> inheritanceComparator = new Comparator<ClassData>(){

        @Override
        public int compare(ClassData c1, ClassData c2) {
            if (c1.isArray() || c2.isArray()) {
                return 0;
            }
            if (c1.isPrimitive() || c2.isPrimitive()) {
                return 0;
            }
            if (c1.getParent().getFullyQualifiedName().equals(c2.getFullyQualifiedName())) {
                return 1;
            }
            if (c2.getParent().getFullyQualifiedName().equals(c1.getFullyQualifiedName())) {
                return -1;
            }
            return 0;
        }
    };

    public static JavonSerializer findSupportingSerializer(TypeMirror type, JavonProfileProvider provider, Traversable traversable, Map<String, ClassData> typeCache) {
        for (JavonSerializer serializer : provider.getSerializers()) {
            if (!serializer.isTypeSupported(traversable, type, typeCache)) continue;
            return serializer;
        }
        return null;
    }

    public static ClassDataRegistry getRegistry(String profileName, List<ClasspathInfo> classpaths) {
        return new ClassDataRegistry(profileName, classpaths);
    }

    private ClassDataRegistry(String profileName, List<ClasspathInfo> classpaths) {
        this.classpaths = classpaths;
        Lookup.Result providersResult = Lookup.getDefault().lookup(new Lookup.Template(JavonProfileProvider.class));
        ArrayList providers = new ArrayList(providersResult.allInstances());
        for (JavonProfileProvider provider : providers) {
            if (!profileName.equals(provider.getName())) continue;
            this.profileProvider = provider;
            break;
        }
        if (this.profileProvider == null) {
            return;
        }
    }

    public ClassData getClassData(String fqn) {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        return this.baseClasses.get(fqn);
    }

    public Map<String, ClassData> getBaseClasses() {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        return Collections.unmodifiableMap(this.baseClasses);
    }

    public Set<String> getBasePackages() {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        HashSet<String> result = new HashSet<String>();
        for (ClassData clsData : this.baseClasses.values()) {
            String fqn = clsData.getFullyQualifiedName();
            int index = fqn.lastIndexOf(46);
            result.add(index > 0 ? fqn.substring(0, index) : "");
        }
        return Collections.unmodifiableSet(result);
    }

    public boolean isRegisteredType(ClassData clsData) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return this.typeMap.contains(clsData);
    }

    public Set<ClassData> getClassesForPackage(String packageName) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> result = new HashSet<ClassData>();
        for (ClassData cd : this.typeMap) {
            if (!cd.getPackage().equals(packageName)) continue;
            result.add(cd);
        }
        return result;
    }

    public Set<ClassData> getBaseClassesForPackage(String packageName) {
        if (this.baseClasses == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> result = new HashSet<ClassData>();
        int pLength = packageName.length() + 1;
        Set<String> fqClassNames = this.baseClasses.keySet();
        for (String fqClassName : fqClassNames) {
            if (!fqClassName.startsWith(packageName) || fqClassName.indexOf(46, pLength) >= 0) continue;
            result.add(this.baseClasses.get(fqClassName));
        }
        return result;
    }

    public JavonSerializer getTypeSerializer(ClassData type) {
        return type.getSerializer();
    }

    public void updateClassDataTree() {
        if (this.typeMap == null) {
            this.typeMap = new HashSet<ClassData>();
        }
        if (this.baseClasses == null) {
            this.baseClasses = new HashMap<String, ClassData>();
        }
        int id = 1;
        for (ClasspathInfo cpi : this.classpaths) {
            try {
                TraversingTask tt = new TraversingTask(this.profileProvider, cpi);
                JavaSource.create((ClasspathInfo)cpi, (FileObject[])new FileObject[0]).runWhenScanFinished((Task)tt, false).get();
                this.idMapping = new HashMap<ClassData, Integer>();
                for (ClassData cd : this.typeMap) {
                    this.idMapping.put(cd, id);
                    ++id;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Set<ClassData> getRegisteredTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return Collections.unmodifiableSet(this.typeMap);
    }

    public Set<ClassData> getReturnTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> result = new HashSet<ClassData>();
        for (ClassData clsData : this.typeMap) {
            for (MethodData mthData : clsData.getMethods()) {
                result.add(mthData.getReturnType());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<ClassData> getParameterTypes() {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        HashSet<ClassData> result = new HashSet<ClassData>();
        for (ClassData clsData : this.typeMap) {
            for (MethodData mthData : clsData.getMethods()) {
                result.addAll(mthData.getReturnType().getParameterTypes());
            }
        }
        return Collections.unmodifiableSet(result);
    }

    public int getRegisteredTypeId(ClassData type) {
        if (this.typeMap == null) {
            this.updateClassDataTree();
        }
        return this.idMapping.get(type);
    }

    private final class TraversingTask
    implements CancellableTask<CompilationController>,
    Traversable {
        private ClasspathInfo cpi;
        private JavonProfileProvider profileProvider;
        private static final int RETURN_TYPES = 1;
        private static final int PARAMETERS_TYPES = 2;
        private int status;

        public TraversingTask(JavonProfileProvider profileProvider, ClasspathInfo cpi) {
            this.profileProvider = profileProvider;
            this.cpi = cpi;
            if (ClassDataRegistry.this.typeMap == null) {
                ClassDataRegistry.this.typeMap = new HashSet();
            }
        }

        public void cancel() {
        }

        public void run(CompilationController parameter) throws Exception {
            Set elements = this.cpi.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle eh : elements) {
                TypeElement te = (TypeElement)eh.resolve((CompilationInfo)parameter);
                ClassData clsData = null;
                if (te != null) {
                    clsData = this.getServiceType(te.asType());
                }
                if (clsData == null) continue;
                ClassDataRegistry.this.baseClasses.put(clsData.getFullyQualifiedName(), clsData);
            }
        }

        private ClassData getServiceType(TypeMirror type) {
            if (TypeKind.DECLARED == type.getKind()) {
                TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
                String packageName = clazz.getQualifiedName().toString();
                packageName = packageName.length() == clazz.getSimpleName().toString().length() ? "" : packageName.substring(0, packageName.lastIndexOf(46));
                JavonSerializer serializer = ClassDataRegistry.findSupportingSerializer(type, this.profileProvider, this, new HashMap<String, ClassData>());
                ArrayList<MethodData> methods = new ArrayList<MethodData>(0);
                ArrayList<MethodData> invalidMethods = new ArrayList<MethodData>(0);
                for (ExecutableElement e : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                    boolean validReturnType;
                    if (!e.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                    boolean validParameters = true;
                    HashMap<String, ClassData> typeCache = new HashMap<String, ClassData>();
                    ClassData returnClass = this.traverseType(e.getReturnType(), typeCache);
                    if (returnClass != null) {
                        ClassDataRegistry.this.typeMap.add(returnClass);
                        validReturnType = true;
                    } else {
                        validReturnType = false;
                    }
                    ArrayList<MethodParameter> parameters = new ArrayList<MethodParameter>();
                    ArrayList<MethodParameter> invalidParameters = new ArrayList<MethodParameter>();
                    for (VariableElement variableElement : e.getParameters()) {
                        typeCache = new HashMap();
                        ClassData paramClass = this.traverseType(variableElement.asType(), typeCache);
                        if (paramClass != null) {
                            ClassDataRegistry.this.typeMap.add(paramClass);
                            parameters.add(new MethodParameter(variableElement.getSimpleName().toString(), paramClass));
                            validParameters = true;
                            continue;
                        }
                        validParameters = false;
                        invalidParameters.add(new MethodParameter(variableElement.getSimpleName().toString(), ((Object)variableElement.asType()).toString()));
                    }
                    if (validReturnType && validParameters) {
                        methods.add(new MethodData(clazz.getQualifiedName().toString(), e.getSimpleName().toString(), returnClass, parameters));
                        continue;
                    }
                    invalidMethods.add(new MethodData(clazz.getQualifiedName().toString(), e.getSimpleName().toString(), ((Object)e.getReturnType()).toString(), parameters, validReturnType, invalidParameters));
                }
                if (methods.size() == 0) {
                    return null;
                }
                ArrayList<FieldData> fields = new ArrayList<FieldData>(0);
                for (VariableElement ve : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
                    HashMap<String, ClassData> typeCache = new HashMap<String, ClassData>();
                    ClassData fieldType = this.traverseType(ve.asType(), typeCache);
                    if (fieldType == null) continue;
                    FieldData fieldData = new FieldData(fieldType.getName(), fieldType);
                    if (ve.getModifiers().contains((Object)Modifier.PUBLIC)) {
                        fieldData.setModifier(ClassData.Modifier.PUBLIC);
                    }
                    if (ve.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        fieldData.setModifier(ClassData.Modifier.PRIVATE);
                    }
                    fields.add(fieldData);
                }
                ClassData result = new ClassData(packageName, clazz.getSimpleName().toString(), false, fields, methods, serializer, invalidMethods);
                return result;
            }
            return null;
        }

        @Override
        public ClassData traverseType(TypeMirror type, Map<String, ClassData> typeCache) {
            for (JavonSerializer serializer : this.profileProvider.getSerializers()) {
                if (!serializer.isTypeSupported(this, type, typeCache)) continue;
                ClassData cd = serializer.getType(this, type, typeCache);
                return cd;
            }
            return null;
        }

        @Override
        public boolean isTypeSupported(TypeMirror type, Map<String, ClassData> typeCache) {
            return ClassDataRegistry.findSupportingSerializer(type, this.profileProvider, this, typeCache) != null;
        }

        @Override
        public JavonSerializer registerType(ClassData type) {
            if (type.getSerializer() == null) {
                return null;
            }
            ClassDataRegistry.this.typeMap.add(type);
            return type.getSerializer();
        }

        private String displayClassData(ClassData clsData) {
            StringBuffer result = new StringBuffer(clsData.getFullyQualifiedName() + "\n\n");
            for (FieldData fe : clsData.getFields()) {
                result.append((Object)((Object)fe.getModifier()) + " " + fe.getType() + " " + fe.getName() + "\n");
            }
            result.append("\n");
            for (MethodData me : clsData.getMethods()) {
                result.append(me.getReturnType() + " " + me.getName() + "(");
                int i = 0;
                for (MethodParameter mp : me.getParameters()) {
                    result.append(mp.getType().getFullyQualifiedName() + " " + mp.getName());
                    if (i < me.getParameters().size() - 1) {
                        result.append(",");
                    } else {
                        result.append(")\n");
                    }
                    ++i;
                }
            }
            return result.toString();
        }
    }
}

