/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.masterdetail;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.Record;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordList;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListEvent;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordListListener;

public abstract class AbstractRecordList<R extends Record>
implements RecordList<R> {
    private int maxSize = 10;
    private int currentRecordIndex;
    private ArrayList<R> list = new ArrayList();
    private static boolean dirty = false;
    protected EventListenerList listenerList = null;

    public AbstractRecordList() {
        this.initialize(0);
    }

    public AbstractRecordList(int max) {
        this.initialize(max);
    }

    protected AbstractRecordList(int max, RecordList<R> that) {
        this.initialize(max);
        for (Record r : that) {
            Record clone = r.cloneRecord();
            this.appendRecord(clone);
        }
    }

    private EventListenerList getListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    private void initialize(int max) {
        this.maxSize = max <= 0 ? 0 : max;
    }

    @Override
    public void appendRecord(R record) {
        this.list.add(record);
        dirty = true;
    }

    @Override
    public void addRecord(R record) {
        this.addRecord(record, true);
    }

    @Override
    public synchronized void addRecord(R record, boolean reuse) {
        int existing = this.indexOf(record);
        if (reuse && existing > 0) {
            this.list.remove(existing);
        }
        this.list.add(0, record);
        if (this.maxSize > 0 && this.list.size() > this.maxSize) {
            this.list.remove(this.list.size() - 1);
        }
        this.fireContentsChanged(this, null);
    }

    public void moveToFront(int rx) {
        Record record = (Record)this.list.remove(rx);
        this.list.add(0, record);
        this.fireContentsChanged(this, null);
    }

    @Override
    public void addRecordAfter(R record, int after) {
        if (after < 0) {
            after = 0;
        }
        if (after >= this.list.size()) {
            after = this.list.size() - 1;
        }
        int existing = this.indexOf(record);
        assert (existing < 0) : "AbstractRecordList.addRecordAfter() record already in list";
        if (this.list.size() == 0) {
            this.list.add(0, record);
        } else {
            this.list.add(after + 1, record);
        }
        this.fireContentsChanged(this, null);
    }

    @Override
    public boolean contains(R record) {
        return this.list.contains(record);
    }

    @Override
    public int indexOf(R record) {
        return this.list.indexOf(record);
    }

    @Override
    public int recordByKey(String key) {
        int i = 0;
        for (Record r : this) {
            if (r.matches(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int getCurrentRecordIndex() {
        return this.currentRecordIndex;
    }

    @Override
    public R getRecordAt(int index) {
        try {
            this.currentRecordIndex = index;
            return (R)((Record)this.list.get(index));
        }
        catch (IndexOutOfBoundsException x) {
            return null;
        }
    }

    @Override
    public Iterator<R> iterator() {
        return this.list.iterator();
    }

    @Override
    public String[] getRecordsName() {
        String[] recordsName = new String[this.getSize()];
        int i = 0;
        for (Record r : this) {
            recordsName[i++] = r.getHostName();
        }
        return recordsName;
    }

    @Override
    public String[] getRecordsDisplayName() {
        String[] recordsDisplayName = new String[this.getSize()];
        int i = 0;
        for (Record r : this) {
            recordsDisplayName[i++] = r.displayName();
        }
        return recordsDisplayName;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public R getMostRecentUsedRecord() {
        if (this.getSize() > 0) {
            return (R)((Record)this.list.get(0));
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public void removeAllRecords() {
        this.list.clear();
        this.fireContentsChanged(this, null);
    }

    private R findArchetype() {
        for (Record r : this) {
            if (!r.isArchetype()) continue;
            return (R)r;
        }
        return null;
    }

    @Override
    public void removeAllButArchetype() {
        R archetype = this.findArchetype();
        this.list.clear();
        if (archetype != null) {
            this.list.add(archetype);
        }
        this.fireContentsChanged(this, null);
    }

    @Override
    public R removeRecord(R record) {
        return this.removeRecordAt(this.indexOf(record));
    }

    @Override
    public R removeRecordAt(int index) {
        Record toBeRemoved = null;
        if (index < 0 || index >= this.getSize()) {
            return (R)toBeRemoved;
        }
        toBeRemoved = (Record)this.list.remove(index);
        this.fireContentsChanged(this, null);
        return (R)toBeRemoved;
    }

    @Override
    public R replaceRecordAt(R record, int index) {
        if (index < 0 || index >= this.getSize()) {
            return null;
        }
        Record toBeReplaced = (Record)this.list.set(index, record);
        this.fireContentsChanged(this, null);
        return (R)toBeReplaced;
    }

    @Override
    public void addRecordListListener(RecordListListener l) {
        this.getListenerList().add(RecordListListener.class, l);
    }

    @Override
    public void removeRecordListListener(RecordListListener l) {
        this.getListenerList().remove(RecordListListener.class, l);
    }

    @Override
    public void fireRecordChanged(int i) {
        this.fireContentsChanged(this, null);
    }

    @Override
    public abstract RecordList<R> cloneList();

    @Override
    public void copyList(RecordList<R> that, Object obj) {
        this.list.clear();
        for (Record r : that) {
            this.list.add(r);
        }
        this.fireContentsChanged(this, obj);
    }

    @Override
    public void dumpRecords() {
        for (int i = 0; i < this.getSize(); ++i) {
            System.out.println("[" + i + "] " + ((Record)this.list.get(i)).displayName());
        }
        System.out.println();
    }

    @Override
    public String newKey() {
        return null;
    }

    protected void fireContentsChanged(Object source, Object obj) {
        Object[] listeners = this.getListenerList().getListenerList();
        RecordListEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RecordListListener.class) continue;
            if (e == null) {
                e = new RecordListEvent(source, RecordListEvent.CONTENTS_CHANGED, (String)obj);
            }
            ((RecordListListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    protected static boolean isDirty() {
        return dirty;
    }

    protected static void clearDirty() {
        dirty = false;
    }
}

