/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.common2.debugger.io.TermComponent;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Host;
import org.netbeans.modules.cnd.debugger.common2.utils.Executor;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.common2.utils.Log;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.PathUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Signal;
import org.openide.ErrorManager;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

class ExecutorCND
extends Executor {
    private NativeProcess engineProc;
    private int pid = -1;
    private final ExecutionEnvironment exEnv;
    private String startError = null;

    public ExecutorCND(String name, Host host) {
        super(name, host);
        this.exEnv = host.executionEnvironment();
    }

    @Override
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.exEnv;
    }

    @Override
    public boolean isAlive() {
        try {
            this.engineProc.exitValue();
        }
        catch (IllegalThreadStateException x) {
            return true;
        }
        return false;
    }

    @Override
    public void terminate() throws IOException {
        this.engineProc.destroy();
    }

    @Override
    public void interrupt(int pid) throws IOException {
        if (this.exEnv.isLocal() && Utilities.isWindows()) {
            File f = InstalledFileLocator.getDefault().locate("bin/GdbKillProc.exe", "org.netbeans.modules.cnd.debugger.common2", false);
            if (f.exists()) {
                ProcessUtils.execute((ExecutionEnvironment)this.exEnv, (String)f.getAbsolutePath(), (String[])new String[]{"-s", "INT", Long.toString(pid)});
            }
        } else {
            try {
                CommonTasksSupport.sendSignal((ExecutionEnvironment)this.exEnv, (int)pid, (Signal)Signal.SIGINT, null).get();
            }
            catch (InterruptedException ex) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    @Override
    public void interruptGroup() throws IOException {
        try {
            CommonTasksSupport.sendSignalGrp((ExecutionEnvironment)this.exEnv, (int)this.pid, (Signal)Signal.SIGINT, null).get();
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    public void sigqueue(int sig, int data) throws IOException {
        try {
            CommonTasksSupport.sigqueue((ExecutionEnvironment)this.exEnv, (int)this.pid, (int)sig, (int)data, null).get();
        }
        catch (InterruptedException ex) {
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int startShellCmd(String[] cmd_argv) {
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.exEnv);
        String[] argv = new String[cmd_argv.length - 1];
        for (int cx = 1; cx < cmd_argv.length; ++cx) {
            argv[cx - 1] = cmd_argv[cx];
        }
        npb.setExecutable(cmd_argv[0]);
        npb.setArguments(argv);
        npb.setUsePty(true);
        try {
            this.engineProc = npb.call();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        try {
            this.pid = this.engineProc.getPID();
            return this.pid;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 1;
        }
    }

    @Override
    public synchronized int startEngine(String enginePath, String[] engine_argv, Map<String, String> additionalEnv, String workDir, TermComponent console, boolean usePty, boolean disableEcho) {
        this.startError = null;
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.exEnv);
        String[] argv = new String[engine_argv.length - 1];
        for (int cx = 1; cx < engine_argv.length; ++cx) {
            argv[cx - 1] = engine_argv[cx];
        }
        npb.setExecutable(enginePath);
        npb.setArguments(argv);
        npb.setWorkingDirectory(workDir);
        npb.getEnvironment().putAll(additionalEnv);
        if (usePty) {
            npb.setUsePty(true);
            npb.getEnvironment().put("TERM", console.getTerm().getEmulation());
        }
        try {
            this.engineProc = npb.call();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return 0;
        }
        if (this.engineProc.getState() == NativeProcess.State.ERROR) {
            try {
                this.startError = ProcessUtils.readProcessErrorLine((Process)this.engineProc);
            }
            catch (IOException ex) {
                // empty catch block
            }
            return 0;
        }
        PtySupport.connect((InputOutput)console.getIO(), (NativeProcess)this.engineProc);
        if (disableEcho) {
            PtySupport.disableEcho((ExecutionEnvironment)this.exEnv, (String)PtySupport.getTTY((NativeProcess)this.engineProc));
        }
        try {
            this.pid = this.engineProc.getPID();
            return this.pid;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return 0;
        }
    }

    @Override
    public String getStartError() {
        return this.startError;
    }

    @Override
    protected int waitForEngine() throws InterruptedException {
        if (this.engineProc == null) {
            return -1;
        }
        return this.engineProc.waitFor();
    }

    @Override
    protected void destroyEngine() {
        if (this.engineProc == null) {
            return;
        }
        super.destroyEngine();
        this.engineProc.destroy();
    }

    @Override
    public void reap() {
        Thread reaper = new Thread(){

            @Override
            public void run() {
                this.setName("ExecutorCND Reaper");
                try {
                    ExecutorCND.this.engineProc.waitFor();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                int exitValue = ExecutorCND.this.engineProc.exitValue();
                if (Log.Executor.debug && exitValue != 0) {
                    List processError = null;
                    List processOutput = null;
                    try {
                        processError = ProcessUtils.readProcessError((Process)ExecutorCND.this.engineProc);
                        processOutput = ProcessUtils.readProcessOutput((Process)ExecutorCND.this.engineProc);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    String output = "";
                    output = output + String.format("Process exited with %d.\n", exitValue);
                    output = output + String.format("Output:\n", new Object[0]);
                    if (processOutput == null) {
                        output = output + "\t<empty>\n";
                    } else {
                        for (String l : processOutput) {
                            output = output + l + "\n";
                        }
                    }
                    output = output + String.format("Error:\n", new Object[0]);
                    if (processError == null) {
                        output = output + "\t<empty>\n";
                    } else {
                        for (String l : processError) {
                            output = output + l + "\n";
                        }
                    }
                    final String foutput = output;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IpeUtils.postError(foutput);
                        }
                    });
                }
            }
        };
        reaper.start();
    }

    @Override
    public String readlink(long pid) {
        return PathUtils.getExePath((long)pid, (ExecutionEnvironment)this.exEnv);
    }

    @Override
    public boolean is_64(String filep) {
        ProcessUtils.ExitStatus status = ProcessUtils.execute((ExecutionEnvironment)this.exEnv, (String)"/usr/bin/file", (String[])new String[]{filep});
        return status.output.contains(" 64");
    }

    @Override
    public InputStream getInputStream() {
        return this.engineProc.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.engineProc.getOutputStream();
    }
}

