/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileCategory;

public final class Signals
extends ProfileCategory {
    private InitialSignalInfo[] signals = new InitialSignalInfo[0];
    private InitialSignalInfo[] xml_signals;
    private boolean clone = false;

    public Signals(DbgProfile owner) {
        super(owner, "signals");
    }

    boolean isClone() {
        return this.clone;
    }

    void setClone() {
        this.clone = true;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Signals)) {
            return false;
        }
        Signals that = (Signals)thatObject;
        if (this.count() != that.count()) {
            return false;
        }
        for (int sx = 0; sx < this.count(); ++sx) {
            if (this.signals[sx].caught == that.signals[sx].caught) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        Signals clone = new Signals(null);
        clone.setClone();
        clone.signals = new InitialSignalInfo[this.signals.length];
        for (int sx = 0; sx < this.signals.length; ++sx) {
            InitialSignalInfo ni;
            InitialSignalInfo oi = this.signals[sx];
            if (oi == null) {
                return null;
            }
            clone.signals[sx] = ni = new InitialSignalInfo(oi.signo(), oi.name() != null ? oi.name() : " ", oi.description() != null ? oi.description() : " ", oi.isCaughtByDefault(), oi.isCaught());
        }
        return clone;
    }

    @Override
    public void assign(Object thatObject) {
        if (this == thatObject) {
            return;
        }
        if (!(thatObject instanceof Signals)) {
            return;
        }
        Signals that = (Signals)thatObject;
        Signals old = (Signals)this.clone();
        this.signals = new InitialSignalInfo[that.signals.length];
        for (int sx = 0; sx < that.signals.length; ++sx) {
            InitialSignalInfo ni;
            InitialSignalInfo oi = that.signals[sx];
            if (oi == null) {
                return;
            }
            this.signals[sx] = ni = new InitialSignalInfo(oi.signo(), oi.name() != null ? oi.name() : " ", oi.description() != null ? oi.description() : " ", oi.isCaughtByDefault(), oi.isCaught());
        }
        this.checkSignal();
        this.delta(old, this);
    }

    public void restoreDefaultValue() {
        Signals old = (Signals)this.clone();
        for (InitialSignalInfo signal : this.signals) {
            signal.resetCaught();
        }
        this.delta(old, this);
    }

    public void checkSignal() {
    }

    public void setXMLSignal(InitialSignalInfo[] s) {
        this.xml_signals = s;
    }

    public void setDefaultSignals(InitialSignalInfo[] s) {
        if (this.count() == 0) {
            this.signals = s;
            if (this.xml_signals != null) {
                for (int i = 0; i < this.xml_signals.length; ++i) {
                    int signo = this.xml_signals[i].signo;
                    this.signals[signo - 1].setCaught(this.xml_signals[i].isCaught());
                }
            }
            this.checkSignal();
        }
    }

    public void setSignalState(SignalInfo s) {
        this.signals[s.signo - 1].setCaught(s.caught());
        this.checkSignal();
    }

    public InitialSignalInfo getSignal(int sx) {
        if (this.count() > 0) {
            return this.signals[sx];
        }
        return null;
    }

    public int count() {
        if (this.signals == null) {
            return 0;
        }
        return this.signals.length;
    }

    public boolean isDefaultValue(int sx) {
        InitialSignalInfo s = this.signals[sx];
        if (s == null) {
            return true;
        }
        if (s.caught) {
            return s.caughtByDefault;
        }
        return !s.caughtByDefault;
    }

    public boolean isDefaultValue() {
        for (int i = 0; i < this.signals.length; ++i) {
            if (this.isDefaultValue(i)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.count() == 0) {
            return Catalog.get("NoSigsUntilDebug");
        }
        boolean addSep = false;
        String ret = " ";
        if (this.signals != null) {
            for (int i = 0; i < this.signals.length; ++i) {
                if (this.signals[i] == null) continue;
                if (addSep) {
                    ret = ret + ",";
                }
                ret = ret + this.signals[i].name;
                addSep = true;
            }
        }
        return ret;
    }

    public static final class SignalInfo {
        private final int signo;
        private final boolean caught;

        public SignalInfo(int signo, boolean caught) {
            this.signo = signo;
            this.caught = caught;
        }

        public int signo() {
            return this.signo;
        }

        public boolean caught() {
            return this.caught;
        }
    }

    public static final class InitialSignalInfo {
        private final int signo;
        private final String name;
        private final String description;
        private final boolean caughtByDefault;
        private boolean caught;

        public InitialSignalInfo(int signo, String name, String description, boolean caughtByDefault, boolean caught) {
            this.signo = signo;
            this.name = name;
            this.description = description;
            this.caughtByDefault = caughtByDefault;
            this.caught = caught;
        }

        public int signo() {
            return this.signo;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public boolean isCaughtByDefault() {
            return this.caughtByDefault;
        }

        public boolean isCaught() {
            return this.caught;
        }

        public void setCaught(boolean caught) {
            this.caught = caught;
        }

        public void resetCaught() {
            this.caught = this.caughtByDefault;
        }
    }
}

