/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.ProfileCategory;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public final class Pathmap
extends ProfileCategory {
    private List<Item> pathmap = new ArrayList<Item>();

    public Pathmap(DbgProfile owner) {
        super(owner, "pathmap");
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.pathmap != null ? ((Object)this.pathmap).hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object thatObject) {
        if (this == thatObject) {
            return true;
        }
        if (!(thatObject instanceof Pathmap)) {
            return false;
        }
        Pathmap that = (Pathmap)thatObject;
        if (this.pathmap == that.pathmap) {
            return true;
        }
        if (this.pathmap == null || that.pathmap == null) {
            return false;
        }
        if (this.pathmap.size() != that.pathmap.size()) {
            return false;
        }
        for (int px = 0; px < this.pathmap.size(); ++px) {
            Item a = this.pathmap.get(px);
            Item b = that.pathmap.get(px);
            if (IpeUtils.sameString(a.from, b.from) && IpeUtils.sameString(a.to, b.to) && a.appliesToCwd == b.appliesToCwd) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object clone() {
        Pathmap clone = new Pathmap(this.owner);
        if (this.pathmap != null) {
            clone.pathmap = new ArrayList<Item>();
            for (Item map : this.pathmap) {
                clone.pathmap.add(map);
            }
        }
        return clone;
    }

    @Override
    public void assign(Object thatObject) {
        if (this.equals(thatObject)) {
            return;
        }
        if (!(thatObject instanceof Pathmap)) {
            return;
        }
        Pathmap that = (Pathmap)thatObject;
        Pathmap old = (Pathmap)this.clone();
        if (that.pathmap != null) {
            this.pathmap = new ArrayList<Item>();
            for (Item map : that.pathmap) {
                this.pathmap.add(map);
            }
        } else {
            this.pathmap = null;
        }
        this.delta(old, this);
    }

    public Item[] getPathmap() {
        if (this.pathmap == null) {
            return null;
        }
        return this.pathmap.toArray(new Item[this.pathmap.size()]);
    }

    public boolean isDefaultValue() {
        return this.count() == 0;
    }

    public void restoreDefaultValue() {
        Pathmap old = (Pathmap)this.clone();
        this.pathmap = new ArrayList<Item>();
        this.delta(old, this);
    }

    public int count() {
        if (this.pathmap == null) {
            return 0;
        }
        return this.pathmap.size();
    }

    public void setPathmap(Item[] newmap) {
        this.db_print("Before setPathmap");
        this.pathmap = new ArrayList<Item>();
        if (newmap != null) {
            for (Item map : newmap) {
                this.pathmap.add(map);
            }
        }
        this.db_print("After setPathmap");
    }

    private int find(Item map) {
        for (int x = 0; x < this.pathmap.size(); ++x) {
            Item candidate = this.pathmap.get(x);
            if (!IpeUtils.sameString(candidate.from, map.from)) continue;
            return x;
        }
        return -1;
    }

    public void extendPathmap(Item[] newmap) {
        this.db_print("Before extendPathmap");
        for (Item nm : newmap) {
            int match = this.find(nm);
            if (match != -1) {
                this.pathmap.set(match, nm);
                continue;
            }
            this.pathmap.add(nm);
        }
        this.db_print("After extendPathmap");
    }

    private void db_print(String msg) {
    }

    public String toString() {
        boolean addSep = false;
        String ret = "";
        if (this.pathmap != null && this.pathmap.size() > 0) {
            for (Item map : this.pathmap) {
                if (addSep) {
                    ret = ret + ",";
                }
                ret = ret + map.from + "->" + map.to;
                addSep = true;
            }
        }
        return ret;
    }

    public static final class Item {
        private final String from;
        private final String to;
        private final boolean appliesToCwd;

        public Item(String from, String to, boolean appliesToCwd) {
            this.from = from;
            this.to = to;
            this.appliesToCwd = appliesToCwd;
        }

        public String from() {
            return this.from;
        }

        public String to() {
            return this.to;
        }

        public boolean appliesToCwd() {
            return this.appliesToCwd;
        }
    }
}

