/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.options;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.GlobalOptionsSubPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionCustomizerNode;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionCustomizerPanel;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSet;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.NbCollections;

public class GlobalOptionsPanel
extends JPanel {
    private OptionSet options;
    private JPanel customizerPanel;
    private JPanel categoryPanel;
    private CategoryView categoryView;
    private Component currentCustomizer;
    private GridBagConstraints fillConstraints;
    private static String ICON = "org/netbeans/modules/cnd/debugger/common2/resources/general";

    public GlobalOptionsPanel() {
        this.initComponents();
        this.setName("TAB_DebuggerOptionsPanelTitle");
    }

    public void setOptions(OptionSet options) {
        this.options = options;
        String preselectedNodeName = "SessionStartup";
        this.categoryView.selectNode(preselectedNodeName);
        this.initValues();
    }

    public OptionSet getOptions() {
        return this.options;
    }

    protected void initComponents() {
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(750, 450));
        Catalog.setAccessibleName(this, "ACSN_OptionCustomizer");
        Catalog.setAccessibleDescription(this, "ACSD_OptionCustomizer");
        JTextArea header = new JTextArea(){

            @Override
            public boolean isFocusable() {
                return false;
            }
        };
        header.setRequestFocusEnabled(false);
        header.setWrapStyleWord(true);
        header.setLineWrap(true);
        header.setEditable(false);
        header.setBorder(new EmptyBorder(new Insets(12, 12, 12, 12)));
        header.setText(Catalog.get("DialogDescription"));
        header.setBackground((Color)UIManager.getDefaults().get("Label.background"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 0);
        this.add((Component)header, gridBagConstraints);
        this.categoryPanel = new JPanel();
        this.categoryPanel.setLayout(new GridBagLayout());
        this.categoryPanel.setBorder(new EtchedBorder());
        this.categoryPanel.setPreferredSize(new Dimension(200, 4));
        this.categoryPanel.setMinimumSize(new Dimension(200, 4));
        Catalog.setAccessibleName(this.categoryPanel, "ACSN_OptionCustomizer_categoryPanel");
        Catalog.setAccessibleDescription(this.categoryPanel, "ACSD_OptionCustomizer_categoryPanel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        this.add((Component)this.categoryPanel, gridBagConstraints);
        this.customizerPanel = new JPanel();
        this.customizerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 8, 8);
        this.add((Component)this.customizerPanel, gridBagConstraints);
        this.categoryView = new CategoryView(GlobalOptionsPanel.createRootNode());
        this.fillConstraints = new GridBagConstraints();
        this.fillConstraints.gridwidth = 0;
        this.fillConstraints.gridheight = 0;
        this.fillConstraints.fill = 1;
        this.fillConstraints.weightx = 1.0;
        this.fillConstraints.weighty = 1.0;
        this.categoryPanel.add((Component)this.categoryView, this.fillConstraints);
    }

    private static Node createRootNode() {
        OptionCustomizerNode[] children = new OptionCustomizerNode[]{new OptionCustomizerNode("SessionStartup", Catalog.get("SessionStartup"), ICON, new GlobalOptionsSubPanel.SessionStartup(), null), new OptionCustomizerNode("WindowProperties", Catalog.get("WindowProperties"), ICON, new GlobalOptionsSubPanel.WindowProperties(), null)};
        OptionCustomizerNode root = new OptionCustomizerNode("root PCN", "root PCN", null, null, children);
        return new ConfigurationNode(root);
    }

    private static JLabel createEmptyLabel(String text) {
        JLabel label;
        if (text == null) {
            label = new JLabel();
        } else {
            label = new JLabel(text);
            label.setHorizontalAlignment(0);
        }
        return label;
    }

    private void storeValues() {
        if (this.currentCustomizer == null) {
            return;
        }
        if (this.currentCustomizer instanceof OptionCustomizerPanel) {
            ((OptionCustomizerPanel)((Object)this.currentCustomizer)).storeValues();
        }
    }

    private void initValues() {
        if (this.currentCustomizer == null) {
            return;
        }
        if (this.currentCustomizer instanceof OptionCustomizerPanel) {
            ((OptionCustomizerPanel)((Object)this.currentCustomizer)).initValues(this.options);
        }
    }

    protected void cancelChanges() {
    }

    public void applyChanges() {
        this.storeValues();
    }

    private class CategoryView
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private BeanTreeView btv;

        CategoryView(Node rootNode) {
            this.setLayout(new BorderLayout());
            Dimension size = new Dimension(220, 4);
            this.btv = new BeanTreeView();
            Catalog.setAccessibleName((Component)this.btv, "ACSN_BeanTreeView");
            Catalog.setAccessibleDescription((Component)this.btv, "ACSD_BeanTreeView");
            this.btv.setSelectionMode(1);
            this.btv.setPopupAllowed(false);
            this.btv.setRootVisible(false);
            this.btv.setDefaultActionAllowed(false);
            this.btv.setMinimumSize(size);
            this.btv.setPreferredSize(size);
            this.btv.setMaximumSize(size);
            this.btv.setDragSource(false);
            this.add((Component)this.btv, "Center");
            this.manager.setRootContext(rootNode);
            ManagerChangeListener managerChangeListener = new ManagerChangeListener();
            this.manager.addPropertyChangeListener((PropertyChangeListener)managerChangeListener);
            this.expandCollapseTree(rootNode, this.btv);
        }

        private void expandCollapseTree(Node rootNode, BeanTreeView btv) {
            Children children = rootNode.getChildren();
            Node[] nodes1 = children.getNodes();
            for (int i = 0; i < nodes1.length; ++i) {
                btv.expandNode(nodes1[i]);
                Node[] nodes2 = nodes1[i].getChildren().getNodes();
                for (int j = 0; j < nodes2.length; ++j) {
                    btv.collapseNode(nodes2[j]);
                }
            }
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        @Override
        public void addNotify() {
            super.addNotify();
        }

        public void selectNode(String name) {
            Node[] nodes;
            Children ch = this.manager.getRootContext().getChildren();
            if (ch != null && (nodes = ch.getNodes(true)) != null && nodes.length > 0) {
                try {
                    Node node = nodes[0];
                    if (name != null) {
                        try {
                            StringTokenizer st = new StringTokenizer(name, "/");
                            node = NodeOp.findPath((Node)this.manager.getRootContext(), (Enumeration)NbCollections.checkedEnumerationByFilter((Enumeration)st, String.class, (boolean)true));
                        }
                        catch (NodeNotFoundException e) {
                            // empty catch block
                        }
                    }
                    this.manager.setSelectedNodes(new Node[]{node});
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }

        private class ManagerChangeListener
        implements PropertyChangeListener {
            private ManagerChangeListener() {
            }

            private void nodeSelected() {
                Node[] nodes = CategoryView.this.manager.getSelectedNodes();
                if (nodes == null || nodes.length <= 0) {
                    return;
                }
                Node node = nodes[0];
                if (GlobalOptionsPanel.this.currentCustomizer != null) {
                    GlobalOptionsPanel.this.customizerPanel.remove(GlobalOptionsPanel.this.currentCustomizer);
                }
                if (node.hasCustomizer()) {
                    GlobalOptionsPanel.this.storeValues();
                    GlobalOptionsPanel.this.currentCustomizer = node.getCustomizer();
                    if (GlobalOptionsPanel.this.currentCustomizer == null) {
                        GlobalOptionsPanel.this.currentCustomizer = GlobalOptionsPanel.createEmptyLabel(null);
                    }
                    GlobalOptionsPanel.this.initValues();
                    GlobalOptionsPanel.this.customizerPanel.add(GlobalOptionsPanel.this.currentCustomizer, GlobalOptionsPanel.this.fillConstraints);
                    GlobalOptionsPanel.this.currentCustomizer.validate();
                    GlobalOptionsPanel.this.currentCustomizer.repaint();
                    GlobalOptionsPanel.this.customizerPanel.validate();
                    GlobalOptionsPanel.this.customizerPanel.repaint();
                } else {
                    GlobalOptionsPanel.this.currentCustomizer = null;
                }
                CategoryView.this.btv.requestFocus();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getSource() != CategoryView.this.manager) {
                    return;
                }
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    this.nodeSelected();
                }
            }
        }
    }

    private static class ConfigurationChildren
    extends Children.Keys<OptionCustomizerNode> {
        private Collection<OptionCustomizerNode> descriptions;

        public ConfigurationChildren(OptionCustomizerNode[] descriptions) {
            this.descriptions = Arrays.asList(descriptions);
        }

        public void addNotify() {
            this.setKeys(this.descriptions);
        }

        public void removeNotify() {
            this.setKeys(Collections.emptyList());
        }

        protected Node[] createNodes(OptionCustomizerNode key) {
            return new Node[]{new ConfigurationNode(key)};
        }
    }

    private static class ConfigurationNode
    extends AbstractNode {
        private OptionCustomizerPanel customizer;

        public ConfigurationNode(OptionCustomizerNode description) {
            super((Children)(description.children == null ? Children.LEAF : new ConfigurationChildren(description.children)));
            this.setName(description.name);
            this.setDisplayName(description.displayName);
            this.customizer = description.customizer;
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            return (Component)((Object)this.customizer);
        }
    }
}

