/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget;

import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTargetsXMLReader;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTargetsXMLWriter;
import org.netbeans.modules.cnd.debugger.common2.utils.UserdirFile;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.AbstractRecordList;
import org.openide.ErrorManager;

public class DebugTargetList
extends AbstractRecordList<DebugTarget> {
    private static DebugTargetList instance = null;
    static int debuglistMaxSize = 100;
    static final String moduleFolderName = "DbxGui";
    static final String folderName = "DebugTargets";
    static final String filename = "debugtargets";
    private static final UserdirFile userdirFile = new UserdirFile("DbxGui", "DebugTargets", "debugtargets");

    public DebugTargetList(int max) {
        super(max);
    }

    protected DebugTargetList(DebugTargetList that) {
        super(debuglistMaxSize, that);
    }

    public static DebugTargetList getInstance() {
        if (instance == null) {
            try {
                instance = new DebugTargetList(debuglistMaxSize);
                instance.restore(userdirFile);
            }
            catch (Exception e) {
                System.out.println("DebugTargetList - getInstance - e " + e);
                System.out.println("Cannot restore debuglist ...");
            }
        }
        return instance;
    }

    public static void saveList() {
        if (instance == null) {
            return;
        }
        instance.save(userdirFile);
    }

    public void save(UserdirFile userdirFile) {
        DebugTargetsXMLWriter xw = new DebugTargetsXMLWriter(userdirFile, this);
        try {
            xw.write();
            DebugTargetList.clearDirty();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
        }
    }

    public void restore(UserdirFile userdirFile) {
        DebugTargetsXMLReader xr = new DebugTargetsXMLReader(userdirFile, this);
        try {
            xr.read();
        }
        catch (Exception x) {
            ErrorManager.getDefault().notify(4096, (Throwable)x);
        }
    }

    @Override
    public DebugTargetList cloneList() {
        return new DebugTargetList(this);
    }
}

