/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.actions;

import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.State;
import org.netbeans.modules.cnd.debugger.common2.debugger.StateListener;
import org.netbeans.modules.cnd.debugger.common2.debugger.actions.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.Disassembly;
import org.netbeans.modules.cnd.debugger.common2.debugger.assembly.DisassemblyUtils;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public class ContinueAtAction
extends CallableSystemAction
implements StateListener {
    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        int lineNo = EditorContextBridge.getCurrentLineNumber();
        if (lineNo < 0) {
            return;
        }
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger == null) {
            return;
        }
        if (Disassembly.isInDisasm()) {
            String address = DisassemblyUtils.getLineAddress(lineNo);
            if (address == null || address.isEmpty()) {
                return;
            }
            debugger.contAtInst(address);
        } else {
            String fileName = EditorContextBridge.getCurrentFilePath();
            if (fileName.trim().equals("")) {
                return;
            }
            debugger.contAt(fileName, lineNo);
        }
    }

    public String getName() {
        return Catalog.get("LBL_ContinueAtAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("Welcome_fdide_home");
    }

    protected String iconResource() {
        return "org/netbeans/modules/cnd/debugger/common2/icons/continue-at-line.png";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("ShortDescription", Catalog.get("TIP_ContinueAtAction"));
        this.setEnabled(false);
    }

    @Override
    public void update(State state) {
        boolean enable = false;
        NativeDebugger debugger = DebuggerManager.get().currentDebugger();
        if (debugger == null) {
            this.setEnabled(false);
            return;
        }
        enable = state.isListening() && !state.isCore && state.isLoaded && state.isProcess;
        this.setEnabled(enable);
    }
}

