/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DictionaryImpl
implements Dictionary {
    private List<String> dictionary = null;
    private StringBuffer dictionaryText = null;
    private final File source;
    private final Project p;
    private final AuxiliaryConfiguration ac;
    private final Locale locale;
    private final Comparator<String> dictionaryComparator;
    private static final String WORDLIST = "spellchecker-wordlist";
    private static final String NAMESPACE = "http://www.netbeans.org/ns/spellchecker-wordlist/1";
    private static int MINIMAL_SIMILAR_COUNT = 3;

    public DictionaryImpl(File source, Locale locale) {
        this.source = source;
        this.p = null;
        this.ac = null;
        this.locale = locale;
        this.dictionaryComparator = this.prepareDictionaryComparator(locale);
        this.loadDictionary(source);
    }

    public DictionaryImpl(Project p, AuxiliaryConfiguration ac, Locale locale) {
        this.source = null;
        this.p = p;
        this.ac = ac;
        this.locale = locale;
        this.dictionaryComparator = this.prepareDictionaryComparator(locale);
        this.loadDictionary(ac);
    }

    private Comparator<String> prepareDictionaryComparator(final Locale locale) {
        return new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.toLowerCase(locale).compareTo(s2.toLowerCase(locale));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDictionary(File source) {
        if (!source.canRead()) {
            return;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                this.addEntryImpl(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
        Collections.sort(this.getDictionary(), this.dictionaryComparator);
    }

    private void loadDictionary(final AuxiliaryConfiguration ac) {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element conf = ac.getConfigurationFragment(DictionaryImpl.WORDLIST, DictionaryImpl.NAMESPACE, true);
                if (conf == null) {
                    return null;
                }
                NodeList childNodes = conf.getChildNodes();
                for (int cntr = 0; cntr < childNodes.getLength(); ++cntr) {
                    Node n = childNodes.item(cntr);
                    if (!"word".equals(n.getLocalName())) continue;
                    DictionaryImpl.this.addEntryImpl(n.getTextContent());
                }
                return null;
            }
        });
        Collections.sort(this.getDictionary(), this.dictionaryComparator);
    }

    public int findLesser(String word) {
        word = word.toLowerCase(this.locale);
        List<String> dict = this.getDictionary();
        int lower = 0;
        int upper = dict.size() - 1;
        boolean last = false;
        while (lower != upper && !last) {
            int current;
            String currentObj;
            int result;
            if (upper - lower == 1) {
                last = true;
            }
            if ((result = (currentObj = dict.get(current = (lower + upper) / 2)).toLowerCase(this.locale).compareTo(word)) == 0) {
                return current;
            }
            if (result < 0) {
                lower = current + 1;
            }
            if (result <= 0) continue;
            upper = current - 1;
        }
        if (dict.get(lower).toLowerCase(this.locale).compareTo(word) == 0) {
            return lower;
        }
        return lower + 1 < dict.size() ? lower + 1 : lower;
    }

    public ValidityType findWord(String word) {
        if (this.getDictionary().isEmpty()) {
            return ValidityType.INVALID;
        }
        String str = this.getDictionary().get(this.findLesser(word));
        String lWord = word.toLowerCase(this.locale);
        if (str.startsWith(word) || str.startsWith(lWord)) {
            if (str.equals(word) || str.equals(lWord)) {
                return ValidityType.VALID;
            }
            return ValidityType.PREFIX_OF_VALID;
        }
        return ValidityType.INVALID;
    }

    protected synchronized List<String> getDictionary() {
        if (this.dictionary == null) {
            this.dictionary = new ArrayList<String>();
        }
        return this.dictionary;
    }

    protected synchronized StringBuffer getDictionaryText() {
        if (this.dictionaryText == null) {
            this.dictionaryText = new StringBuffer();
            this.dictionaryText.append('\n');
            for (String e : this.getDictionary()) {
                this.dictionaryText.append(e);
                this.dictionaryText.append('\n');
            }
        }
        return this.dictionaryText;
    }

    private void addEntryImpl(String entry) {
        this.getDictionary().add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpToFile(List<String> dictionary) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.source), "UTF-8"));
            for (String s : dictionary) {
                writer.append(s);
                writer.append('\n');
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
    }

    private void dumpToProject(final List<String> dictionary) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Element conf = null;
                Document doc = DictionaryImpl.this.createXmlDocument();
                if (doc != null) {
                    conf = doc.createElementNS(DictionaryImpl.NAMESPACE, DictionaryImpl.WORDLIST);
                }
                if (conf == null) {
                    return null;
                }
                for (String s : dictionary) {
                    Element e = conf.getOwnerDocument().createElementNS(DictionaryImpl.NAMESPACE, "word");
                    e.appendChild(conf.getOwnerDocument().createTextNode(s));
                    conf.appendChild(e);
                }
                DictionaryImpl.this.ac.putConfigurationFragment(conf, true);
                return null;
            }
        });
        try {
            ProjectManager.getDefault().saveProject(this.p);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Document createXmlDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException ex) {
            return null;
        }
    }

    public synchronized void addEntry(String entry) {
        List<String> dictionary = this.getDictionary();
        int index = Collections.binarySearch(dictionary, entry, this.dictionaryComparator);
        if (index >= 0) {
            return;
        }
        index = -index - 1;
        dictionary.add(index, entry);
        this.dictionaryText = null;
        if (this.source != null) {
            this.dumpToFile(dictionary);
        } else {
            this.dumpToProject(dictionary);
        }
    }

    public List<String> completions(String word) {
        if ("".equals(word)) {
            return Collections.emptyList();
        }
        int start = this.findLesser(word);
        int end = this.findLesser(word.substring(0, word.length() - 1) + (char)(word.charAt(word.length() - 1) + '\u0001'));
        return this.getDictionary().subList(start, end);
    }

    public List<String> getSimilarWords(String word) {
        if (this.getDictionary().isEmpty()) {
            return Collections.emptyList();
        }
        List<Pair> proposal = DictionaryImpl.dynamicProgramming(word, this.getDictionaryText(), 5);
        ArrayList<String> result = new ArrayList<String>();
        Collections.sort(proposal, new SimilarComparator());
        Iterator<Pair> words = proposal.iterator();
        int proposedCount = 0;
        int lastDistance = 0;
        while (words.hasNext()) {
            Pair pair = words.next();
            if (proposedCount >= MINIMAL_SIMILAR_COUNT && lastDistance != pair.distance) continue;
            result.add(pair.proposedWord);
            ++proposedCount;
            lastDistance = pair.distance;
        }
        return result;
    }

    private static List<Pair> dynamicProgramming(String pattern, CharSequence text, int distance) {
        ArrayList<Pair> result = new ArrayList<Pair>();
        pattern = pattern.toLowerCase();
        int[] old = new int[pattern.length() + 1];
        int[] current = new int[pattern.length() + 1];
        int[] oldLength = new int[pattern.length() + 1];
        int[] length = new int[pattern.length() + 1];
        for (int cntr = 0; cntr < old.length; ++cntr) {
            old[cntr] = distance + 1;
            oldLength[cntr] = -1;
        }
        length[0] = 0;
        oldLength[0] = 0;
        old[0] = 0;
        current[0] = 0;
        for (int currentIndex = 0; currentIndex < text.length(); ++currentIndex) {
            for (int cntr = 0; cntr < pattern.length(); ++cntr) {
                int insert = old[cntr + 1] + 1;
                int delete = current[cntr] + 1;
                int replace = old[cntr] + (pattern.charAt(cntr) == text.charAt(currentIndex) ? 0 : 1);
                if (insert < delete) {
                    if (insert < replace) {
                        current[cntr + 1] = insert;
                        length[cntr + 1] = oldLength[cntr + 1] + 1;
                        continue;
                    }
                    current[cntr + 1] = replace;
                    length[cntr + 1] = oldLength[cntr] + 1;
                    continue;
                }
                if (delete < replace) {
                    current[cntr + 1] = delete;
                    length[cntr + 1] = length[cntr];
                    continue;
                }
                current[cntr + 1] = replace;
                length[cntr + 1] = oldLength[cntr] + 1;
            }
            if (current[pattern.length()] <= distance) {
                String occurence;
                int start = currentIndex - length[pattern.length()] + 1;
                int end = currentIndex + 1;
                int n = end = end >= text.length() ? text.length() - 1 : end;
                if (!(start != 0 && text.charAt(start - 1) != '\n' || text.charAt(end) != '\n' || (occurence = ((Object)text.subSequence(start, end)).toString()).indexOf(10) != -1 || pattern.equals(occurence))) {
                    result.add(new Pair(occurence, current[pattern.length()]));
                }
            }
            int[] temp = old;
            old = current;
            current = temp;
            temp = oldLength;
            oldLength = length;
            length = temp;
        }
        return result;
    }

    public ValidityType validateWord(CharSequence word) {
        return this.findWord(((Object)word).toString());
    }

    public List<String> findValidWordsForPrefix(CharSequence word) {
        return Collections.emptyList();
    }

    public List<String> findProposals(CharSequence word) {
        return this.getSimilarWords(((Object)word).toString());
    }

    private static class SimilarComparator
    implements Comparator<Pair> {
        private SimilarComparator() {
        }

        @Override
        public int compare(Pair p1, Pair p2) {
            if (p1.distance < p2.distance) {
                return -1;
            }
            if (p1.distance > p2.distance) {
                return 1;
            }
            return 0;
        }
    }

    private static class Pair {
        private int distance;
        private String proposedWord;

        public Pair(String proposedWord, int distance) {
            this.distance = distance;
            this.proposedWord = proposedWord;
        }
    }
}

