/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.netbeans.core.windows.view.ui.Tabbed;
import org.netbeans.core.windows.view.ui.slides.SlideController;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabbedContainer;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class TabbedAdapter
extends TabbedContainer
implements Tabbed,
Tabbed.Accessor,
SlideController {
    public static final int DOCUMENT = 1;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final boolean DEBUG = Debug.isLoggable(TabbedAdapter.class);
    private PropertyChangeListener tooltipListener;
    private PropertyChangeListener weakTooltipListener;

    public TabbedAdapter(int type) {
        super(null, type, (WinsysInfoForTabbedContainer)new WinsysInfo(type));
        this.getSelectionModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                int idx = TabbedAdapter.this.getSelectionModel().getSelectedIndex();
                if (idx != -1) {
                    TabbedAdapter.this.fireStateChanged();
                }
            }
        });
    }

    @Override
    public void addTopComponent(String name, Icon icon, TopComponent tc, String toolTip) {
        this.insertComponent(name, icon, (Component)tc, toolTip, this.getTabCount());
    }

    @Override
    public TopComponent getTopComponentAt(int index) {
        if (index == -1 || index >= this.getModel().size()) {
            return null;
        }
        return (TopComponent)this.getModel().getTab(index).getComponent();
    }

    @Override
    public TopComponent getSelectedTopComponent() {
        int i = this.getSelectionModel().getSelectedIndex();
        return i == -1 ? null : this.getTopComponentAt(i);
    }

    @Override
    public void requestAttention(TopComponent tc) {
        int idx = this.indexOf((Component)tc);
        if (idx >= 0) {
            this.requestAttention(idx);
        } else {
            Logger.getAnonymousLogger().fine("RequestAttention on component unknown to container: " + tc);
        }
    }

    @Override
    public void cancelRequestAttention(TopComponent tc) {
        int idx = this.indexOf((Component)tc);
        if (idx < 0) {
            throw new IllegalArgumentException("TopComponent " + tc + " is not a child of this container");
        }
        this.cancelRequestAttention(idx);
    }

    @Override
    public void insertComponent(String name, Icon icon, Component comp, String toolTip, int position) {
        TabData td = new TabData((Object)comp, icon, name, toolTip);
        if (DEBUG) {
            TabbedAdapter.debugLog("InsertTab: " + name + " hash:" + System.identityHashCode(comp));
        }
        this.getModel().addTab(position, td);
        comp.addPropertyChangeListener("ToolTipText", this.getTooltipListener(comp));
    }

    @Override
    public void setSelectedComponent(Component comp) {
        int i = this.indexOf(comp);
        if (i == -1 && null != comp) {
            throw new IllegalArgumentException("Component not a child of this control: " + comp);
        }
        this.getSelectionModel().setSelectedIndex(i);
    }

    @Override
    public TopComponent[] getTopComponents() {
        ComponentConverter cc = this.getComponentConverter();
        TabData[] td = this.getModel().getTabs().toArray(new TabData[0]);
        TopComponent[] result = new TopComponent[this.getModel().size()];
        for (int i = 0; i < td.length; ++i) {
            result[i] = (TopComponent)cc.getComponent(td[i]);
        }
        return result;
    }

    @Override
    public void removeComponent(Component comp) {
        int i = this.indexOf(comp);
        this.getModel().removeTab(i);
        comp.removePropertyChangeListener("ToolTipText", this.getTooltipListener(comp));
        if (this.getModel().size() == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    public void addComponents(Component[] comps, String[] names, Icon[] icons, String[] tips) {
        ArrayList al = new ArrayList(comps.length);
        TabData[] data = new TabData[comps.length];
        for (int i = 0; i < comps.length; ++i) {
            TabData td;
            data[i] = td = new TabData((Object)comps[i], icons[i], names[i], tips[i]);
            comps[i].addPropertyChangeListener("ToolTipText", this.getTooltipListener(comps[i]));
        }
        this.getModel().addTabs(0, data);
    }

    @Override
    public void setTopComponents(TopComponent[] tcs, TopComponent selected) {
        if (selected == null && tcs.length > 0) {
            selected = tcs[0];
            Logger.getLogger(TabbedAdapter.class.getName()).warning("Selected component is null although open components are " + Arrays.asList(tcs));
        }
        int sizeBefore = this.getModel().size();
        this.detachTooltipListeners(this.getModel().getTabs());
        TabData[] data = new TabData[tcs.length];
        int toSelect = -1;
        for (int i = 0; i < tcs.length; ++i) {
            TopComponent tc = tcs[i];
            Image icon = tc.getIcon();
            String displayName = WindowManagerImpl.getInstance().getTopComponentDisplayName(tc);
            data[i] = new TabData((Object)tc, (Icon)(icon == null ? null : new ImageIcon(icon)), displayName == null ? "" : displayName, tc.getToolTipText());
            if (selected == tcs[i]) {
                toSelect = i;
            }
            tc.addPropertyChangeListener("ToolTipText", this.getTooltipListener((Component)tc));
        }
        assert (selected != null && toSelect != -1) : "Tried to set a selected component that was  not in the array of open components. ToSelect: " + selected + " ToSelectName=" + selected.getDisplayName() + " ToSelectClass=" + selected.getClass() + " open components: " + Arrays.asList(tcs);
        this.getModel().setTabs(data);
        if (toSelect != -1) {
            this.getSelectionModel().setSelectedIndex(toSelect);
        } else if (selected != null) {
            Logger.getAnonymousLogger().warning("Tried toset a selected component that was not in the array of open components.  ToSelect: " + selected + " components: " + Arrays.asList(tcs));
        }
        int sizeNow = this.getModel().size();
        if (sizeBefore != 0 && sizeNow == 0) {
            this.revalidate();
            this.repaint();
        }
    }

    private void detachTooltipListeners(List tabs) {
        Iterator iter = tabs.iterator();
        while (iter.hasNext()) {
            JComponent curComp = (JComponent)((TabData)iter.next()).getComponent();
            curComp.removePropertyChangeListener("ToolTipText", this.getTooltipListener(curComp));
        }
    }

    @Override
    public Object getConstraintForLocation(Point location, boolean attachingPossible) {
        String s;
        int tab = this.tabForCoordinate(location);
        if (tab != -1) {
            int index = this.dropIndexOfPoint(location);
            return index < 0 ? null : Integer.valueOf(index);
        }
        if (attachingPossible && (s = this.getSideForLocation(location)) != null) {
            return s;
        }
        int index = this.dropIndexOfPoint(location);
        return index < 0 ? null : Integer.valueOf(index);
    }

    @Override
    public Shape getIndicationForLocation(Point location, TopComponentDraggable startingTransfer, Point startingPoint, boolean attachingPossible) {
        Shape s;
        Rectangle rect = this.getBounds();
        rect.setLocation(0, 0);
        TopComponent draggedTC = startingTransfer.getTopComponent();
        int tab = this.tabForCoordinate(location);
        if (tab != -1 && (s = this.getDropIndication(draggedTC, location)) != null) {
            return s;
        }
        String side = attachingPossible ? this.getSideForLocation(location) : null;
        double ratio = 0.5;
        if (side == "top") {
            return new Rectangle(0, 0, rect.width, (int)((double)rect.height * ratio));
        }
        if (side == "left") {
            return new Rectangle(0, 0, (int)((double)rect.width * ratio), rect.height);
        }
        if (side == "right") {
            return new Rectangle(rect.width - (int)((double)rect.width * ratio), 0, (int)((double)rect.width * ratio), rect.height);
        }
        if (side == "bottom") {
            return new Rectangle(0, rect.height - (int)((double)rect.height * ratio), rect.width, (int)((double)rect.height * ratio));
        }
        Shape s2 = this.getDropIndication(draggedTC, location);
        if (s2 != null) {
            return s2;
        }
        if (startingTransfer.isTopComponentTransfer() && startingPoint != null && this.indexOf((Component)startingTransfer.getTopComponent()) != -1) {
            return this.getStartingIndication(startingPoint, location);
        }
        return rect;
    }

    private String getSideForLocation(Point location) {
        Rectangle top;
        int LEFT_WIDTH;
        Rectangle bounds = this.getBounds();
        bounds.setLocation(0, 0);
        int TOP_HEIGHT = 10;
        int BOTTOM_HEIGHT = (int)(0.25 * (double)bounds.height);
        int RIGHT_WIDTH = LEFT_WIDTH = Math.max(this.getWidth() / 8, 40);
        if (DEBUG) {
            TabbedAdapter.debugLog("");
            TabbedAdapter.debugLog("TOP_HEIGHT    =10");
            TabbedAdapter.debugLog("BOTTOM_HEIGHT =" + BOTTOM_HEIGHT);
            TabbedAdapter.debugLog("LEFT_WIDTH    =" + LEFT_WIDTH);
            TabbedAdapter.debugLog("RIGHT_WIDTH   =" + RIGHT_WIDTH);
        }
        if ((top = new Rectangle(0, 0, bounds.width, BOTTOM_HEIGHT)).contains(location)) {
            return "top";
        }
        EqualPolygon left = new EqualPolygon(new int[]{0, LEFT_WIDTH, LEFT_WIDTH, 0}, new int[]{10, 10, bounds.height - BOTTOM_HEIGHT, bounds.height}, 4);
        if (left.contains(location)) {
            return "left";
        }
        EqualPolygon right = new EqualPolygon(new int[]{bounds.width - RIGHT_WIDTH, bounds.width, bounds.width, bounds.width - RIGHT_WIDTH}, new int[]{10, 10, bounds.height, bounds.height - BOTTOM_HEIGHT}, 4);
        if (right.contains(location)) {
            return "right";
        }
        EqualPolygon bottom = new EqualPolygon(new int[]{LEFT_WIDTH, bounds.width - RIGHT_WIDTH, bounds.width, 0}, new int[]{bounds.height - BOTTOM_HEIGHT, bounds.height - BOTTOM_HEIGHT, bounds.height, bounds.height}, 4);
        if (bottom.contains(location)) {
            return "bottom";
        }
        return null;
    }

    private Shape getStartingIndication(Point startingPoint, Point location) {
        Rectangle rect = this.getBounds();
        rect.setLocation(location.x - startingPoint.x, location.y - startingPoint.y);
        return rect;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.cs.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.cs.removeChangeListener(listener);
    }

    private void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().warning("All state changes to the tab component must happen on the event thread!");
            Exception e = new Exception();
            e.fillInStackTrace();
            Logger.getAnonymousLogger().warning(e.getStackTrace()[1].toString());
        }
        this.cs.fireChange();
    }

    private static void debugLog(String message) {
        Debug.log(TabbedAdapter.class, message);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public Action[] getPopupActions(Action[] defaultActions, int tabIndex) {
        if (tabIndex < 0) {
            ModeImpl mode = this.getModeImpl();
            if (null != mode) {
                return ActionUtils.createDefaultPopupActions(mode);
            }
            return null;
        }
        return defaultActions;
    }

    private ModeImpl getModeImpl() {
        TopComponent[] topComponents = this.getTopComponents();
        if (topComponents.length < 1) {
            return null;
        }
        return (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponents[0]);
    }

    public static boolean isInMaximizedMode(Component comp) {
        ModeImpl maxMode = WindowManagerImpl.getInstance().getCurrentMaximizedMode();
        if (maxMode == null) {
            return false;
        }
        return maxMode.containsTopComponent((TopComponent)comp);
    }

    @Override
    public void userToggledAutoHide(int tabIndex, boolean enabled) {
        this.postActionEvent(new TabActionEvent((Object)this, "enableAutoHide", tabIndex));
    }

    @Override
    public void userToggledTransparency(int tabIndex) {
        this.postActionEvent(new TabActionEvent((Object)this, "toggleTransparency", tabIndex));
    }

    @Override
    public Tabbed getTabbed() {
        return this;
    }

    @Override
    public Rectangle getTabBounds(int tabIndex) {
        return this.getTabRect(tabIndex, new Rectangle());
    }

    @Override
    public Rectangle getTabsArea() {
        return this.getUI().getTabsArea();
    }

    private PropertyChangeListener getTooltipListener(Component comp) {
        if (this.tooltipListener == null) {
            this.tooltipListener = new ToolTipListener();
            this.weakTooltipListener = WeakListeners.propertyChange((PropertyChangeListener)this.tooltipListener, (Object)comp);
        }
        return this.weakTooltipListener;
    }

    private class ToolTipListener
    implements PropertyChangeListener {
        private ToolTipListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("ToolTipText".equals(evt.getPropertyName())) {
                List tabs = TabbedAdapter.this.getModel().getTabs();
                int index = 0;
                Iterator iter = tabs.iterator();
                while (iter.hasNext()) {
                    JComponent curComp = (JComponent)((TabData)iter.next()).getComponent();
                    if (curComp == evt.getSource()) {
                        TabbedAdapter.this.setToolTipTextAt(index, (String)evt.getNewValue());
                        break;
                    }
                    ++index;
                }
            }
        }
    }

    static class WinsysInfo
    extends WinsysInfoForTabbedContainer {
        private int containerType;

        public WinsysInfo(int containerType) {
            this.containerType = containerType;
        }

        public Object getOrientation(Component comp) {
            WindowManagerImpl wmi = WindowManagerImpl.getInstance();
            if (!wmi.isDocked((TopComponent)comp)) {
                return TabDisplayer.ORIENTATION_INVISIBLE;
            }
            String side = wmi.guessSlideSide((TopComponent)comp);
            Object result = null;
            result = side.equals("left") ? TabDisplayer.ORIENTATION_WEST : (side.equals("right") ? TabDisplayer.ORIENTATION_EAST : (side.equals("bottom") ? TabDisplayer.ORIENTATION_SOUTH : (side.equals("top") ? TabDisplayer.ORIENTATION_NORTH : TabDisplayer.ORIENTATION_CENTER)));
            return result;
        }

        public boolean inMaximizedMode(Component comp) {
            return TabbedAdapter.isInMaximizedMode(comp);
        }

        public boolean isTopComponentSlidingEnabled() {
            return Switches.isTopComponentSlidingEnabled();
        }

        public boolean isTopComponentClosingEnabled() {
            if (this.containerType == 1) {
                return Switches.isEditorTopComponentClosingEnabled();
            }
            return Switches.isViewTopComponentClosingEnabled();
        }

        public boolean isTopComponentMaximizationEnabled() {
            return Switches.isTopComponentMaximizationEnabled();
        }

        public boolean isTopComponentClosingEnabled(TopComponent tc) {
            return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.closing_disabled")) && this.isTopComponentClosingEnabled();
        }

        public boolean isTopComponentMaximizationEnabled(TopComponent tc) {
            return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.maximization_disabled")) && this.isTopComponentMaximizationEnabled();
        }

        public boolean isTopComponentSlidingEnabled(TopComponent tc) {
            return !Boolean.TRUE.equals(tc.getClientProperty((Object)"netbeans.winsys.tc.sliding_disabled")) && this.isTopComponentSlidingEnabled();
        }

        public boolean isModeSlidingEnabled() {
            return Switches.isModeSlidingEnabled();
        }
    }
}

