/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.Switches;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class CloseAllButThisAction
extends AbstractAction
implements PropertyChangeListener,
Runnable {
    private TopComponent tc;
    private boolean isContext;

    public CloseAllButThisAction() {
        this.isContext = false;
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction_MainMenu"));
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
        this.updateEnabled();
    }

    public CloseAllButThisAction(TopComponent topComp, boolean isContext) {
        this.tc = topComp;
        this.isContext = isContext;
        this.putValue("Name", NbBundle.getMessage(CloseAllButThisAction.class, (String)"CTL_CloseAllButThisAction"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        TopComponent topC = this.obtainTC();
        if (topC != null) {
            ActionUtils.closeAllExcept(topC, this.isContext);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("activated".equals(propName) || "opened".equals(propName)) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        Mutex.EVENT.readAccess((Runnable)this);
    }

    @Override
    public void run() {
        TopComponent tc = this.obtainTC();
        WindowManagerImpl wmi = WindowManagerImpl.getInstance();
        ModeImpl mode = (ModeImpl)wmi.findMode(tc);
        boolean areOtherDocs = this.isContext ? mode.getOpenedTopComponents().size() > 1 : wmi.getEditorTopComponents().length > 1;
        this.setEnabled(mode != null && mode.getKind() == 1 && areOtherDocs && Switches.isEditorTopComponentClosingEnabled());
    }

    private TopComponent obtainTC() {
        return this.tc == null ? TopComponent.getRegistry().getActivated() : this.tc;
    }

    @Override
    public void putValue(String key, Object newValue) {
        if ("AcceleratorKey".equals(key)) {
            ActionUtils.putSharedAccelerator("CloseAllButThis", newValue);
        } else {
            super.putValue(key, newValue);
        }
    }

    @Override
    public Object getValue(String key) {
        if ("AcceleratorKey".equals(key)) {
            return ActionUtils.getSharedAccelerator("CloseAllButThis");
        }
        return super.getValue(key);
    }
}

