/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.util.NbBundle;

public final class TomcatFactory
implements DeploymentFactory {
    public static final String SERVER_ID_50 = "Tomcat";
    public static final String SERVER_ID_55 = "Tomcat55";
    public static final String SERVER_ID_60 = "Tomcat60";
    public static final String SERVER_ID_70 = "Tomcat70";
    public static final String TOMCAT_URI_PREFIX_50 = "tomcat:";
    public static final String TOMCAT_URI_PREFIX_55 = "tomcat55:";
    public static final String TOMCAT_URI_PREFIX_60 = "tomcat60:";
    public static final String TOMCAT_URI_PREFIX_70 = "tomcat70:";
    public static final String TOMCAT_URI_HOME_PREFIX = "home=";
    public static final String TOMCAT_URI_BASE_PREFIX = ":base=";
    private static final String GENERIC_DISCONNECTED_URI_PREFIX = "tomcat-any:";
    private static final String GENERIC_DISCONNECTED_URI = "tomcat-any:jakarta-tomcat-generic";
    private static final String DISCONNECTED_URI_50 = "tomcat:jakarta-tomcat-5.0.x";
    private static final String DISCONNECTED_URI_55 = "tomcat55:jakarta-tomcat-5.5.x";
    private static final String DISCONNECTED_URI_60 = "tomcat60:apache-tomcat-6.0.x";
    private static final String DISCONNECTED_URI_70 = "tomcat70:apache-tomcat-7.0.x";
    private static final Set<String> DISCONNECTED_URIS = new HashSet<String>();
    private static TomcatFactory instance;
    private static final WeakHashMap managerCache;
    private static final Logger LOGGER;

    private TomcatFactory() {
    }

    public static TomcatFactory create50() {
        return TomcatFactory.getInstance();
    }

    public static synchronized TomcatFactory getInstance() {
        if (instance == null) {
            instance = new TomcatFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + uri);
        }
        InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
        if (ip == null && !DISCONNECTED_URIS.contains(uri)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + uri + " is not registered in the IDE.");
        }
        TomcatFactory tomcatFactory = this;
        synchronized (tomcatFactory) {
            TomcatManager tm = (TomcatManager)managerCache.get(ip);
            if (tm == null) {
                try {
                    TomcatManager.TomcatVersion version = TomcatFactory.getTomcatVersion(uri);
                    tm = new TomcatManager(true, TomcatFactory.stripUriPrefix(uri, version), version);
                    managerCache.put(ip, tm);
                }
                catch (IllegalArgumentException iae) {
                    DeploymentManagerCreationException t = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + uri + ".");
                    throw (DeploymentManagerCreationException)t.initCause(iae);
                }
            }
            return tm;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(uri, null, null);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String str) {
        return str != null && (str.startsWith(TOMCAT_URI_PREFIX_50) || str.startsWith(TOMCAT_URI_PREFIX_55) || str.startsWith(TOMCAT_URI_PREFIX_60) || str.startsWith(TOMCAT_URI_PREFIX_70));
    }

    public static String getTomcatVersionString(File catalinaHome) throws IllegalStateException {
        File catalinaJar = new File(catalinaHome, "lib/catalina.jar");
        if (!catalinaJar.exists()) {
            catalinaJar = new File(catalinaHome, "server/lib/catalina.jar");
        }
        File coyoteJar = new File(catalinaHome, "lib/tomcat-coyote.jar");
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{catalinaJar.toURI().toURL(), coyoteJar.toURI().toURL()});
            Class<?> serverInfo = loader.loadClass("org.apache.catalina.util.ServerInfo");
            try {
                Method method = serverInfo.getMethod("getServerNumber", new Class[0]);
                String version = (String)method.invoke(serverInfo, new Object[0]);
                return version;
            }
            catch (NoSuchMethodException ex) {
                Method method = serverInfo.getMethod("getServerInfo", new Class[0]);
                String version = (String)method.invoke(serverInfo, new Object[0]);
                int idx = version.indexOf(47);
                if (idx > 0) {
                    return version.substring(idx + 1);
                }
                throw new IllegalStateException("Cannot identify the version of the server.");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static TomcatManager.TomcatVersion getTomcatVersion(File catalinaHome) throws IllegalStateException {
        String version = null;
        try {
            version = TomcatFactory.getTomcatVersionString(catalinaHome);
        }
        catch (IllegalStateException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return TomcatManager.TomcatVersion.TOMCAT_50;
        }
        if (version.startsWith("5.5.")) {
            return TomcatManager.TomcatVersion.TOMCAT_55;
        }
        if (version.startsWith("6.")) {
            return TomcatManager.TomcatVersion.TOMCAT_60;
        }
        if (version.startsWith("7.")) {
            return TomcatManager.TomcatVersion.TOMCAT_70;
        }
        return TomcatManager.TomcatVersion.TOMCAT_50;
    }

    private static TomcatManager.TomcatVersion getTomcatVersion(String uri) throws IllegalStateException {
        if (uri.startsWith(TOMCAT_URI_PREFIX_70)) {
            return TomcatManager.TomcatVersion.TOMCAT_70;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_60)) {
            return TomcatManager.TomcatVersion.TOMCAT_60;
        }
        if (uri.startsWith(TOMCAT_URI_PREFIX_55)) {
            return TomcatManager.TomcatVersion.TOMCAT_55;
        }
        return TomcatManager.TomcatVersion.TOMCAT_50;
    }

    private static String stripUriPrefix(String uri, TomcatManager.TomcatVersion tomcatVersion) {
        if (uri.startsWith(GENERIC_DISCONNECTED_URI_PREFIX)) {
            return uri.substring(GENERIC_DISCONNECTED_URI_PREFIX.length());
        }
        switch (tomcatVersion) {
            case TOMCAT_70: {
                return uri.substring(TOMCAT_URI_PREFIX_70.length());
            }
            case TOMCAT_60: {
                return uri.substring(TOMCAT_URI_PREFIX_60.length());
            }
            case TOMCAT_55: {
                return uri.substring(TOMCAT_URI_PREFIX_55.length());
            }
        }
        return uri.substring(TOMCAT_URI_PREFIX_50.length());
    }

    static {
        Collections.addAll(DISCONNECTED_URIS, DISCONNECTED_URI_50, DISCONNECTED_URI_55, DISCONNECTED_URI_60, DISCONNECTED_URI_70, GENERIC_DISCONNECTED_URI);
        managerCache = new WeakHashMap();
        LOGGER = Logger.getLogger("org.netbeans.modules.tomcat5");
    }
}

