/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.EditProvider;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.border.Border;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GraphLayoutFactory;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphPreferences;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphPanel;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.GoToReferenceAction;
import org.netbeans.modules.cnd.callgraph.impl.HorizontalHierarchicalLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;

public class CallGraphScene
extends GraphScene<Function, Call> {
    private static final Border BORDER_4 = BorderFactory.createLineBorder((int)4);
    private static final RequestProcessor RP = new RequestProcessor(CallGraphScene.class.getName(), 1);
    private LayerWidget mainLayer;
    private LayerWidget connectionLayer;
    private Router router;
    private SceneLayout sceneLayout;
    private WidgetAction moveAction = ActionFactory.createMoveAction();
    private WidgetAction hoverAction = this.createWidgetHoverAction();
    private WidgetAction popupAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new MyPopupMenuProvider());
    private Font defaultItalicFont;
    private Action exportAction;
    private CallGraphState callModel;
    private LayoutKind layoutKind = LayoutKind.grid;

    public CallGraphScene() {
        this.mainLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.mainLayer);
        this.connectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.connectionLayer);
        this.router = RouterFactory.createOrthogonalSearchRouter((LayerWidget[])new LayerWidget[]{this.mainLayer, this.connectionLayer});
        this.defaultItalicFont = new Font(this.getDefaultFont().getName(), 2, this.getDefaultFont().getSize());
        this.getActions().addAction(this.popupAction);
        this.getActions().addAction(ActionFactory.createZoomAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        this.getActions().addAction(ActionFactory.createWheelPanAction());
    }

    public void setLayout(LayoutKind layoutKind) {
        this.layoutKind = layoutKind;
        Object layout = null;
        switch (layoutKind) {
            case grid: {
                layout = new GridGraphLayout();
                NbPreferences.forModule(CallGraphPanel.class).putInt("CallGraphLayout", 0);
                break;
            }
            case hierarchical: {
                layout = GraphLayoutFactory.createHierarchicalGraphLayout((GraphScene)this, (boolean)true, (boolean)false);
                NbPreferences.forModule(CallGraphPanel.class).putInt("CallGraphLayout", 1);
                break;
            }
            case hierarchical_inverted: {
                layout = GraphLayoutFactory.createHierarchicalGraphLayout((GraphScene)this, (boolean)true, (boolean)true);
                NbPreferences.forModule(CallGraphPanel.class).putInt("CallGraphLayout", 2);
                break;
            }
            case horizontal: {
                layout = new HorizontalHierarchicalLayout<Function, Call>(this, true, false);
                NbPreferences.forModule(CallGraphPanel.class).putInt("CallGraphLayout", 3);
            }
        }
        this.sceneLayout = LayoutFactory.createSceneGraphLayout((GraphScene)this, (GraphLayout)layout);
        this.doLayout();
    }

    public void setModel(CallGraphState model) {
        this.callModel = model;
    }

    public void doLayout() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                CallGraphScene.this.sceneLayout.invokeLayout();
                CallGraphScene.this.validate();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void hideNode(final Function element) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                CallGraphScene.this.removeNodeWithEdges(element);
                CallGraphScene.this.doLayout();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void clean() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ArrayList list = new ArrayList(CallGraphScene.this.getNodes());
                for (Function f : list) {
                    CallGraphScene.this.removeNodeWithEdges(f);
                }
                CallGraphScene.this.doLayout();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void addCallToScene(final Call element) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                boolean isDoLayout = false;
                Function toFunction = element.getCallee();
                Widget to = CallGraphScene.this.findWidget(toFunction);
                if (to == null) {
                    to = CallGraphScene.this.addNode(toFunction);
                    to.setPreferredLocation(new Point(100, 100));
                    isDoLayout = true;
                }
                if (element.getCaller() != null) {
                    Function fromFunction = element.getCaller();
                    Widget from = CallGraphScene.this.findWidget(fromFunction);
                    if (from == null) {
                        from = CallGraphScene.this.addNode(fromFunction);
                        from.setPreferredLocation(new Point(10, 10));
                        isDoLayout = true;
                    }
                    if (CallGraphScene.this.findEdgesBetween(fromFunction, toFunction).isEmpty()) {
                        if (toFunction.equals(fromFunction)) {
                            CallGraphScene.this.addLoopEdge(element, toFunction);
                        } else {
                            CallGraphScene.this.addEdge(element);
                            CallGraphScene.this.setEdgeSource(element, fromFunction);
                            CallGraphScene.this.setEdgeTarget(element, toFunction);
                        }
                        isDoLayout = true;
                    }
                }
                if (isDoLayout) {
                    CallGraphScene.this.doLayout();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void addFunctionToScene(final Function element) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Widget to = CallGraphScene.this.findWidget(element);
                if (to == null) {
                    to = CallGraphScene.this.addNode(element);
                    to.setPreferredLocation(new Point(100, 100));
                    CallGraphScene.this.doLayout();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    private void addLoopEdge(Call edge, Function targetNode) {
        ConnectionWidget connection = (ConnectionWidget)this.addEdge(edge);
        Widget w = this.findWidget(targetNode);
        connection.setRouter(this.router);
        MyVMDNodeAnchor anchor = new MyVMDNodeAnchor(w);
        this.setEdgeSource(edge, targetNode);
        connection.setSourceAnchor((Anchor)anchor);
        this.setEdgeTarget(edge, targetNode);
        connection.setTargetAnchor((Anchor)anchor);
    }

    protected Widget attachNodeWidget(Function node) {
        Object label;
        String name = CallGraphPreferences.isShowParameters() ? node.getDescription() : node.getName();
        String scope = node.getScopeName();
        if (scope != null && scope.length() > 0) {
            if (name.startsWith(scope)) {
                name = name.substring(scope.length());
            }
            label = new MyMemberLabelWidget((Scene)this, scope, name);
        } else {
            label = new MyLabelWidget((Scene)this, name);
        }
        if (node.isVurtual()) {
            label.setFont(this.defaultItalicFont);
        }
        label.setToolTipText(node.getDescription());
        label.setBorder(BORDER_4);
        label.getActions().addAction(this.moveAction);
        label.getActions().addAction(this.hoverAction);
        label.getActions().addAction(ActionFactory.createEditAction((EditProvider)new NodeEditProvider(node)));
        label.getActions().addAction(this.popupAction);
        this.mainLayer.addChild((Widget)label);
        return label;
    }

    protected Widget attachEdgeWidget(Call edge) {
        ConnectionWidget connection = new ConnectionWidget((Scene)this);
        connection.setToolTipText(edge.getDescription());
        connection.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
        connection.getActions().addAction(this.hoverAction);
        connection.getActions().addAction(ActionFactory.createEditAction((EditProvider)new EdgeEditProvider(edge)));
        this.connectionLayer.addChild((Widget)connection);
        return connection;
    }

    protected void attachEdgeSourceAnchor(Call edge, Function oldSourceNode, Function sourceNode) {
        Widget w = sourceNode != null ? this.findWidget(sourceNode) : null;
        ((ConnectionWidget)this.findWidget(edge)).setSourceAnchor(AnchorFactory.createRectangularAnchor((Widget)w));
    }

    protected void attachEdgeTargetAnchor(Call edge, Function oldTargetNode, Function targetNode) {
        Widget w = targetNode != null ? this.findWidget(targetNode) : null;
        ((ConnectionWidget)this.findWidget(edge)).setTargetAnchor(AnchorFactory.createRectangularAnchor((Widget)w));
    }

    public void setExportAction(Action exportAction) {
        this.exportAction = exportAction;
    }

    private class HorizontalAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public HorizontalAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"HorizontalLayout"));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphScene.this.setLayout(LayoutKind.horizontal);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphScene.this.layoutKind == LayoutKind.horizontal);
            return this.menuItem;
        }
    }

    private class HierarchicalInvertedAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public HierarchicalInvertedAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"HierarchicalInvertedLayout"));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphScene.this.setLayout(LayoutKind.hierarchical_inverted);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphScene.this.layoutKind == LayoutKind.hierarchical_inverted);
            return this.menuItem;
        }
    }

    private class HierarchicalAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public HierarchicalAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"HierarchicalLayout"));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphScene.this.setLayout(LayoutKind.hierarchical);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphScene.this.layoutKind == LayoutKind.hierarchical);
            return this.menuItem;
        }
    }

    private class GridAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public GridAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"GridLayout"));
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CallGraphScene.this.setLayout(LayoutKind.grid);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphScene.this.layoutKind == LayoutKind.grid);
            return this.menuItem;
        }
    }

    private class RemoveNode
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public RemoveNode(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"RemoveNode"));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CallGraphScene.this.hideNode(RemoveNode.this.function);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class CollapseCallers
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public CollapseCallers(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"CollapseCallers"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallers(CollapseCallers.this.function)) {
                        Function node = call.getCaller();
                        if (!CallGraphScene.this.isNode(node)) continue;
                        CallGraphScene.this.hideNode(node);
                    }
                    CallGraphScene.this.callModel.setCallersExpanded(CollapseCallers.this.function, false);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class ExpandCallers
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public ExpandCallers(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"ExpandCallers"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallers(ExpandCallers.this.function)) {
                        CallGraphScene.this.addCallToScene(call);
                    }
                    CallGraphScene.this.callModel.setCallersExpanded(ExpandCallers.this.function, true);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class CollapseCallees
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public CollapseCallees(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"CollapseCallees"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallees(CollapseCallees.this.function)) {
                        Function node = call.getCallee();
                        if (!CallGraphScene.this.isNode(node)) continue;
                        CallGraphScene.this.hideNode(node);
                    }
                    CallGraphScene.this.callModel.setCalleesExpanded(CollapseCallees.this.function, false);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class ExpandCallees
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;
        private Function function;

        public ExpandCallees(Function function) {
            this.function = function;
            this.putValue("Name", NbBundle.getMessage(CallGraphScene.class, (String)"ExpandCallees"));
            this.putValue("SmallIcon", new ImageIcon(CallGraphScene.class.getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    for (Call call : CallGraphScene.this.callModel.getCallees(ExpandCallees.this.function)) {
                        CallGraphScene.this.addCallToScene(call);
                    }
                    CallGraphScene.this.callModel.setCalleesExpanded(ExpandCallees.this.function, true);
                }
            });
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private class MyPopupMenuProvider
    implements PopupMenuProvider {
        private MyPopupMenuProvider() {
        }

        public JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
            JPopupMenu menu = null;
            Object node = CallGraphScene.this.findObject(widget);
            if (node instanceof Function) {
                Function f = (Function)node;
                menu = new JPopupMenu();
                menu.add(new GoToReferenceAction(f, 0).getPopupPresenter());
                if (!CallGraphScene.this.callModel.isCalleesExpanded(f)) {
                    menu.add(new ExpandCallees(f).getPopupPresenter());
                } else {
                    menu.add(new CollapseCallees(f).getPopupPresenter());
                }
                if (!CallGraphScene.this.callModel.isCallersExpanded(f)) {
                    menu.add(new ExpandCallers(f).getPopupPresenter());
                } else {
                    menu.add(new CollapseCallers(f).getPopupPresenter());
                }
                menu.add(new JSeparator());
                menu.add(new RemoveNode(f).getPopupPresenter());
            } else if (widget instanceof CallGraphScene) {
                menu = new JPopupMenu();
                menu.add(new GridAction().getPopupPresenter());
                menu.add(new HierarchicalAction().getPopupPresenter());
                menu.add(new HierarchicalInvertedAction().getPopupPresenter());
                menu.add(new HorizontalAction().getPopupPresenter());
                menu.add(new JSeparator());
                menu.add(((Presenter.Popup)CallGraphScene.this.exportAction).getPopupPresenter());
            }
            return menu;
        }
    }

    private static class MyVMDNodeAnchor
    extends Anchor {
        private boolean requiresRecalculation = true;
        private HashMap<Anchor.Entry, Anchor.Result> results = new HashMap();
        private final boolean vertical;

        public MyVMDNodeAnchor(Widget widget) {
            super(widget);
            this.vertical = true;
        }

        protected void notifyEntryAdded(Anchor.Entry entry) {
            this.requiresRecalculation = true;
        }

        protected void notifyEntryRemoved(Anchor.Entry entry) {
            this.results.remove(entry);
            this.requiresRecalculation = true;
        }

        protected void notifyRevalidate() {
            this.requiresRecalculation = true;
        }

        private void recalculate() {
            Anchor.Entry entry;
            int a;
            if (!this.requiresRecalculation) {
                return;
            }
            Widget widget = this.getRelatedWidget();
            Point relatedLocation = this.getRelatedSceneLocation();
            Rectangle bounds = widget.convertLocalToScene(widget.getBounds());
            HashMap<Anchor.Entry, Float> topmap = new HashMap<Anchor.Entry, Float>();
            HashMap<Anchor.Entry, Float> bottommap = new HashMap<Anchor.Entry, Float>();
            for (Anchor.Entry entry2 : this.getEntries()) {
                Point oppositeLocation = this.getOppositeSceneLocation(entry2);
                if (oppositeLocation == null || relatedLocation == null) {
                    this.results.put(entry2, new Anchor.Result((Anchor)this, new Point(bounds.x, bounds.y), DIRECTION_ANY));
                    continue;
                }
                int dy = oppositeLocation.y - relatedLocation.y;
                int dx = oppositeLocation.x - relatedLocation.x;
                if (this.vertical) {
                    if (dy > 0) {
                        bottommap.put(entry2, Float.valueOf((float)dx / (float)dy));
                        continue;
                    }
                    if (dy < 0) {
                        topmap.put(entry2, Float.valueOf((float)(-dx) / (float)dy));
                        continue;
                    }
                    topmap.put(entry2, Float.valueOf(dx < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
                    continue;
                }
                if (dx > 0) {
                    bottommap.put(entry2, Float.valueOf((float)dy / (float)dx));
                    continue;
                }
                if (dy < 0) {
                    topmap.put(entry2, Float.valueOf((float)(-dy) / (float)dx));
                    continue;
                }
                topmap.put(entry2, Float.valueOf(dy < 0 ? Float.MAX_VALUE : Float.MIN_VALUE));
            }
            Anchor.Entry[] topList = this.toArray(topmap);
            Anchor.Entry[] bottomList = this.toArray(bottommap);
            int pinGap = 0;
            int y = bounds.y - pinGap;
            int x = bounds.x - pinGap;
            int len = topList.length;
            for (a = 0; a < len; ++a) {
                entry = topList[a];
                if (this.vertical) {
                    x = bounds.x + (a + 1) * bounds.width / (len + 1);
                } else {
                    y = bounds.y + (a + 1) * bounds.height / (len + 1);
                }
                this.results.put(entry, new Anchor.Result((Anchor)this, new Point(x, y), this.vertical ? Anchor.Direction.TOP : Anchor.Direction.LEFT));
            }
            y = bounds.y + bounds.height + pinGap;
            x = bounds.x + bounds.width + pinGap;
            len = bottomList.length;
            for (a = 0; a < len; ++a) {
                entry = bottomList[a];
                if (this.vertical) {
                    x = bounds.x + (a + 1) * bounds.width / (len + 1);
                } else {
                    y = bounds.y + (a + 1) * bounds.height / (len + 1);
                }
                this.results.put(entry, new Anchor.Result((Anchor)this, new Point(x, y), this.vertical ? Anchor.Direction.BOTTOM : Anchor.Direction.RIGHT));
            }
            this.requiresRecalculation = false;
        }

        private Anchor.Entry[] toArray(final HashMap<Anchor.Entry, Float> map) {
            Set<Anchor.Entry> keys = map.keySet();
            Anchor.Entry[] entries = keys.toArray(new Anchor.Entry[keys.size()]);
            Arrays.sort(entries, new Comparator<Anchor.Entry>(){

                @Override
                public int compare(Anchor.Entry o1, Anchor.Entry o2) {
                    float f = ((Float)map.get(o1)).floatValue() - ((Float)map.get(o2)).floatValue();
                    if (f > 0.0f) {
                        return 1;
                    }
                    if (f < 0.0f) {
                        return -1;
                    }
                    return 0;
                }
            });
            return entries;
        }

        public Anchor.Result compute(Anchor.Entry entry) {
            this.recalculate();
            return this.results.get(entry);
        }
    }

    private static final class MyMemberLabelWidget
    extends Widget {
        private String scope;
        private String label;

        public MyMemberLabelWidget(Scene scene, String scope, String label) {
            super(scene);
            this.scope = scope;
            this.label = label;
            this.setOpaque(false);
            this.revalidate();
            this.setCheckClipping(true);
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            if (previousState.isHovered() == state.isHovered()) {
                return;
            }
            this.setForeground(this.getScene().getLookFeel().getLineColor(state));
            this.repaint();
        }

        protected Rectangle calculateClientArea() {
            Graphics2D gr = this.getGraphics();
            Rectangle2D stringBounds1 = gr.getFontMetrics(this.getFont()).getStringBounds(this.scope, gr);
            Rectangle2D stringBounds2 = gr.getFontMetrics(this.getFont().deriveFont(1)).getStringBounds(this.label, gr);
            Rectangle2D.Double stringBounds = new Rectangle2D.Double(stringBounds1.getX(), stringBounds1.getY(), Math.max(stringBounds1.getWidth(), stringBounds2.getWidth()), stringBounds1.getHeight() + stringBounds2.getHeight());
            return MyMemberLabelWidget.roundRectangle(stringBounds);
        }

        private static Rectangle roundRectangle(Rectangle2D rectangle) {
            int x1 = (int)Math.floor(rectangle.getX());
            int y1 = (int)Math.floor(rectangle.getY());
            int x2 = (int)Math.ceil(rectangle.getMaxX());
            int y2 = (int)Math.ceil(rectangle.getMaxY());
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }

        protected void paintWidget() {
            if (this.label == null) {
                return;
            }
            Graphics2D gr = this.getGraphics();
            gr.setFont(this.getFont());
            FontMetrics fontMetrics = gr.getFontMetrics();
            Rectangle clientArea = this.getClientArea();
            int x = clientArea.x;
            int y = 0;
            AffineTransform previousTransform = gr.getTransform();
            gr.translate(x, y);
            gr.setColor(this.getForeground());
            gr.drawString(this.scope, 0, 0);
            gr.setFont(this.getFont().deriveFont(1));
            gr.drawString(this.label, 0, fontMetrics.getHeight());
            gr.setTransform(previousTransform);
        }
    }

    private static final class MyLabelWidget
    extends LabelWidget {
        public MyLabelWidget(Scene scene, String label) {
            super(scene);
            this.setFont(scene.getFont().deriveFont(1));
            this.setLabel(label);
        }

        protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
            if (previousState.isHovered() == state.isHovered()) {
                return;
            }
            this.setForeground(this.getScene().getLookFeel().getLineColor(state));
            this.repaint();
        }
    }

    private static class EdgeEditProvider
    implements EditProvider {
        private Call call;

        private EdgeEditProvider(Call call) {
            this.call = call;
        }

        public void edit(Widget widget) {
            this.call.open();
        }
    }

    private static class NodeEditProvider
    implements EditProvider {
        private Function node;

        private NodeEditProvider(Function node) {
            this.node = node;
        }

        public void edit(Widget widget) {
            this.node.open();
        }
    }

    public static enum LayoutKind {
        grid,
        hierarchical,
        hierarchical_inverted,
        horizontal;

    }
}

