/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jgit.ignore.IgnoreNode;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.jgit.IgnoreRule;
import org.netbeans.libs.git.jgit.commands.IgnoreUnignoreCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class UnignoreCommand
extends IgnoreUnignoreCommand {
    public UnignoreCommand(Repository repository, File[] files, ProgressMonitor monitor, FileListener listener) {
        super(repository, files, monitor, listener);
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("unignoring ");
        for (File file : this.files) {
            sb.append(file).append(' ');
        }
        return sb.toString();
    }

    @Override
    protected IgnoreNode.MatchResult addStatement(List<IgnoreRule> ignoreRules, File gitIgnore, String path, boolean isDirectory, boolean forceWrite, boolean writableIgnoreFile) throws IOException {
        IgnoreNode.MatchResult result = IgnoreNode.MatchResult.CHECK_PARENT;
        boolean changed = false;
        String escapedPath = UnignoreCommand.escapeChars(path);
        ListIterator<IgnoreRule> it = ignoreRules.listIterator(ignoreRules.size());
        while (it.hasPrevious()) {
            IgnoreRule rule = it.previous();
            if (!rule.isMatch(path, isDirectory)) continue;
            if (rule.getResult()) {
                if (escapedPath.equals(rule.getPattern(true))) {
                    if (!writableIgnoreFile) continue;
                    it.remove();
                    changed = true;
                    continue;
                }
                if (result == IgnoreNode.MatchResult.NOT_IGNORED) continue;
                result = IgnoreNode.MatchResult.IGNORED;
                continue;
            }
            if (result == IgnoreNode.MatchResult.IGNORED && escapedPath.equals(rule.getPattern(true))) {
                if (!writableIgnoreFile) continue;
                it.remove();
                changed = true;
                continue;
            }
            if (result == IgnoreNode.MatchResult.IGNORED) continue;
            result = IgnoreNode.MatchResult.NOT_IGNORED;
        }
        if (writableIgnoreFile && result.equals((Object)IgnoreNode.MatchResult.IGNORED) || result == IgnoreNode.MatchResult.CHECK_PARENT && forceWrite) {
            escapedPath = "!" + escapedPath;
            ignoreRules.add(new IgnoreRule(escapedPath));
            changed = true;
            result = IgnoreNode.MatchResult.NOT_IGNORED;
        }
        if (changed) {
            this.save(gitIgnore, ignoreRules);
        }
        return result;
    }

    @Override
    protected boolean handleAdditionalIgnores(String path, boolean directory) throws IOException {
        return this.checkExcludeFile(path, directory) != IgnoreNode.MatchResult.NOT_IGNORED && this.checkGlobalExcludeFile(path, directory) == IgnoreNode.MatchResult.IGNORED;
    }
}

