/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.openide.util.NbBundle;

public abstract class GitCommand {
    private final Repository repository;
    private final ProgressMonitor monitor;
    protected static final String EMPTY_ROOTS = NbBundle.getMessage(GitCommand.class, (String)"MSG_Error_NoFiles");

    protected GitCommand(Repository repository, ProgressMonitor monitor) {
        this.repository = repository;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws GitException {
        if (this.prepareCommand()) {
            try {
                this.monitor.started(this.getCommandDescription());
                this.run();
            }
            finally {
                this.monitor.finished();
            }
        }
    }

    protected abstract void run() throws GitException;

    protected boolean prepareCommand() throws GitException {
        boolean repositoryExists = this.repository.getDirectory().exists();
        if (!repositoryExists) {
            String message = NbBundle.getMessage(GitCommand.class, (String)"MSG_Error_RepositoryDoesNotExist", (Object)this.repository.getWorkTree());
            this.monitor.preparationsFailed(message);
            throw new GitException(message);
        }
        return repositoryExists;
    }

    protected Repository getRepository() {
        return this.repository;
    }

    protected abstract String getCommandDescription();
}

