/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FollowFilter;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.jgit.JGitRevisionInfo;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GetPreviousCommitCommand
extends GitCommand {
    private final String revision;
    private GitRevisionInfo previousRevision;
    private final File file;

    public GetPreviousCommitCommand(Repository repository, File file, String revision, ProgressMonitor monitor) {
        super(repository, monitor);
        this.file = file;
        this.revision = revision;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        RevWalk walk = null;
        try {
            RevCommit rev = Utils.findCommit(repository, this.revision);
            if (rev.getParentCount() == 1) {
                Iterator it;
                walk = new RevWalk(repository);
                walk.markStart(walk.parseCommit((AnyObjectId)rev.getParent(0)));
                String path = Utils.getRelativePath(repository.getWorkTree(), this.file);
                if (path != null) {
                    walk.setTreeFilter((TreeFilter)FollowFilter.create((String)path));
                }
                if ((it = walk.iterator()).hasNext()) {
                    this.previousRevision = new JGitRevisionInfo(new RevWalk(repository).parseCommit((AnyObjectId)it.next()), repository);
                }
            }
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(ex.getObjectId().toString(), GitObjectType.COMMIT);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
        finally {
            if (walk != null) {
                walk.release();
            }
        }
    }

    @Override
    protected String getCommandDescription() {
        StringBuilder sb = new StringBuilder("git log ");
        sb.append(this.revision).append(' ');
        sb.append("-- ").append(this.file.getPath());
        return sb.toString();
    }

    public GitRevisionInfo getRevision() {
        return this.previousRevision;
    }
}

