/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.IOException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.GitRefUpdateResult;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class DeleteTagCommand
extends GitCommand {
    private final String tagName;
    private GitRefUpdateResult result;

    public DeleteTagCommand(Repository repository, String tagName, ProgressMonitor monitor) {
        super(repository, monitor);
        this.tagName = tagName;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        Ref currentRef = (Ref)repository.getTags().get(this.tagName);
        if (currentRef == null) {
            throw new GitException.MissingObjectException(this.tagName, GitObjectType.TAG);
        }
        String fullName = currentRef.getName();
        try {
            RefUpdate update = repository.updateRef(fullName);
            update.setRefLogMessage("tag deleted", false);
            update.setForceUpdate(true);
            RefUpdate.Result deleteResult = update.delete();
            switch (deleteResult) {
                case IO_FAILURE: 
                case LOCK_FAILURE: 
                case REJECTED: {
                    throw new GitException.RefUpdateException("Cannot delete tag " + this.tagName, GitRefUpdateResult.valueOf(deleteResult.name()));
                }
            }
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git tag -d " + this.tagName;
    }
}

