/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.JGitBranch;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class CreateBranchCommand
extends GitCommand {
    private final String revision;
    private final String branchName;
    private GitBranch branch;

    public CreateBranchCommand(Repository repository, String branchName, String revision, ProgressMonitor monitor) {
        super(repository, monitor);
        this.branchName = branchName;
        this.revision = revision;
    }

    @Override
    protected void run() throws GitException {
        Ref ref;
        Repository repository = this.getRepository();
        org.eclipse.jgit.api.CreateBranchCommand cmd = new Git(repository).branchCreate();
        cmd.setName(this.branchName);
        if (this.revision.startsWith("refs/heads/") || this.revision.startsWith("refs/remotes/")) {
            cmd.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK);
        } else {
            cmd.setStartPoint(Utils.findCommit(repository, this.revision));
        }
        cmd.setStartPoint(this.revision);
        try {
            ref = cmd.call();
        }
        catch (GitAPIException ex) {
            throw new GitException(ex);
        }
        this.branch = this.getBranch(false, ref);
    }

    @Override
    protected String getCommandDescription() {
        return "git branch --track " + this.branchName + ' ' + this.revision;
    }

    public GitBranch getBranch() {
        return this.branch;
    }

    private GitBranch getBranch(boolean isRemote, Ref ref) {
        String refName = ref.getLeaf().getName();
        String name = refName.substring(refName.indexOf(47, 5) + 1);
        return new JGitBranch(name, isRemote, false, ref.getLeaf().getObjectId());
    }
}

