/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefComparator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.NotTreeFilter;
import org.eclipse.jgit.treewalk.filter.OrTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitObjectType;
import org.netbeans.libs.git.jgit.ExactPathFilter;
import org.netbeans.libs.git.jgit.JGitBranch;
import org.openide.util.NbBundle;

public final class Utils {
    private Utils() {
    }

    public static Repository getRepositoryForWorkingDir(File workDir) throws IOException, IllegalArgumentException {
        return ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(Utils.getMetadataFolder(workDir))).readEnvironment()).findGitDir()).build();
    }

    public static File getMetadataFolder(File workDir) {
        return new File(workDir, ".git");
    }

    public static boolean checkExecutable(Repository repository) {
        return repository.getConfig().getBoolean("core", null, "filemode", true);
    }

    public static Collection<PathFilter> getPathFilters(File workDir, File[] roots) {
        List<String> relativePaths = Utils.getRelativePaths(workDir, roots);
        return Utils.getPathFilters(relativePaths);
    }

    public static TreeFilter getExcludeExactPathsFilter(File workDir, File[] roots) {
        List<String> relativePaths = Utils.getRelativePaths(workDir, roots);
        TreeFilter filter = null;
        if (relativePaths.size() > 0) {
            Collection<PathFilter> filters = Utils.getPathFilters(relativePaths);
            LinkedList<ExactPathFilter> exactPathFilters = new LinkedList<ExactPathFilter>();
            for (PathFilter f : filters) {
                exactPathFilters.add(ExactPathFilter.create(f));
            }
            return NotTreeFilter.create((TreeFilter)(exactPathFilters.size() == 1 ? (TreeFilter)exactPathFilters.get(0) : OrTreeFilter.create(exactPathFilters)));
        }
        return filter;
    }

    private static Collection<PathFilter> getPathFilters(Collection<String> relativePaths) {
        LinkedList<PathFilter> filters = new LinkedList<PathFilter>();
        for (String path : relativePaths) {
            filters.add(PathFilter.create((String)path));
        }
        return filters;
    }

    public static List<String> getRelativePaths(File workDir, File[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (File root : roots) {
            if (workDir.equals(root)) {
                paths.clear();
                break;
            }
            paths.add(Utils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(File repo, File file) {
        StringBuilder relativePath = new StringBuilder("");
        File parent = file;
        if (!parent.equals(repo)) {
            while (parent != null && !parent.equals(repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " is not under " + repo.getAbsolutePath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static boolean isUnderOrEqual(TreeWalk treeWalk, Collection<PathFilter> filters) {
        boolean retval = filters.isEmpty();
        for (PathFilter filter : filters) {
            if (!filter.include(treeWalk) || treeWalk.getPathString().length() < filter.getPath().length()) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public static Collection<byte[]> getPaths(Collection<PathFilter> pathFilters) {
        LinkedList<byte[]> paths = new LinkedList<byte[]>();
        for (PathFilter filter : pathFilters) {
            paths.add(Constants.encode((String)filter.getPath()));
        }
        return paths;
    }

    public static RevCommit findCommit(Repository repository, String revision) throws GitException.MissingObjectException, GitException {
        try {
            ObjectId commitId = Utils.parseObjectId(repository, revision);
            if (commitId == null) {
                throw new GitException.MissingObjectException(revision, GitObjectType.COMMIT);
            }
            return new RevWalk(repository).parseCommit((AnyObjectId)commitId);
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(revision, GitObjectType.COMMIT, ex);
        }
        catch (IncorrectObjectTypeException ex) {
            throw new GitException(NbBundle.getMessage(Utils.class, (String)"MSG_Exception_IdNotACommit", (Object)revision));
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static ObjectId parseObjectId(Repository repository, String objectId) throws GitException {
        try {
            return repository.resolve(objectId);
        }
        catch (RevisionSyntaxException ex) {
            throw new GitException.MissingObjectException(objectId, GitObjectType.COMMIT, ex);
        }
        catch (AmbiguousObjectException ex) {
            throw new GitException(NbBundle.getMessage(Utils.class, (String)"MSG_Exception_IdNotACommit", (Object)objectId), ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static RevObject findObject(Repository repository, String objectId) throws GitException.MissingObjectException, GitException {
        try {
            ObjectId commitId = Utils.parseObjectId(repository, objectId);
            if (commitId == null) {
                throw new GitException.MissingObjectException(objectId, GitObjectType.UNKNOWN);
            }
            return new RevWalk(repository).parseAny((AnyObjectId)commitId);
        }
        catch (MissingObjectException ex) {
            throw new GitException.MissingObjectException(objectId, GitObjectType.UNKNOWN, ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static String getRefName(Ref ref) {
        String name = ref.getName();
        for (String prefix : Arrays.asList("refs/heads/", "refs/remotes/", "refs/tags/", "refs/")) {
            if (!name.startsWith(prefix)) continue;
            name = name.substring(prefix.length());
        }
        return name;
    }

    public static Map<String, GitBranch> refsToBranches(Collection<Ref> allRefs, String prefix) {
        HashMap<String, GitBranch> branches = new HashMap<String, GitBranch>();
        Ref head = null;
        for (Ref ref : allRefs) {
            if (!ref.getLeaf().getName().equals("HEAD")) continue;
            head = ref;
            break;
        }
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith(prefix)) continue;
            String name = refName.substring(prefix.length());
            branches.put(name, new JGitBranch(name, false, head != null && ref.getObjectId().equals((AnyObjectId)head.getObjectId()), ref.getLeaf().getObjectId()));
        }
        return branches;
    }

    public static Map<String, String> refsToTags(Collection<Ref> allRefs) {
        HashMap<String, String> tags = new HashMap<String, String>();
        for (Ref ref : RefComparator.sort(allRefs)) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith("refs/tags/")) continue;
            String name = refName.substring("refs/tags/".length());
            tags.put(name, ObjectId.toString((ObjectId)ref.getLeaf().getObjectId()));
        }
        return tags;
    }
}

