/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import org.eclipse.jgit.diff.DiffEntry;
import org.netbeans.libs.git.GitConflictDescriptor;
import org.netbeans.libs.git.GitStatus;

public class JGitStatus
implements GitStatus {
    private final GitStatus.Status statusHeadWC;
    private final DiffEntry diffEntry;
    private final boolean tracked;
    private final String relativePath;
    private final File correspondingFile;
    private final GitStatus.Status statusHeadIndex;
    private final GitStatus.Status statusIndexWC;
    private final GitConflictDescriptor conflictDescriptor;
    private final boolean isFolder;
    private final String workTreePath;

    public JGitStatus(boolean tracked, String relativePath, String workTreePath, File correspondingFile, GitStatus.Status statusHeadIndex, GitStatus.Status statusIndexWC, GitStatus.Status statusHeadWC, GitConflictDescriptor conflictDescriptor, boolean isFolder, DiffEntry diffEntry) {
        this.tracked = tracked;
        this.relativePath = relativePath;
        this.workTreePath = workTreePath;
        this.correspondingFile = correspondingFile;
        this.statusHeadIndex = statusHeadIndex;
        this.statusIndexWC = statusIndexWC;
        this.statusHeadWC = statusHeadWC;
        this.conflictDescriptor = conflictDescriptor;
        this.isFolder = isFolder;
        this.diffEntry = diffEntry;
    }

    @Override
    public File getFile() {
        return this.correspondingFile;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public GitStatus.Status getStatusHeadIndex() {
        return this.statusHeadIndex;
    }

    @Override
    public GitStatus.Status getStatusIndexWC() {
        return this.statusIndexWC;
    }

    @Override
    public GitStatus.Status getStatusHeadWC() {
        return this.statusHeadWC;
    }

    @Override
    public boolean isTracked() {
        return this.tracked;
    }

    @Override
    public boolean isConflict() {
        return this.conflictDescriptor != null;
    }

    @Override
    public boolean isFolder() {
        return this.isFolder;
    }

    @Override
    public boolean isCopied() {
        return this.diffEntry != null && this.diffEntry.getChangeType().equals((Object)DiffEntry.ChangeType.COPY);
    }

    @Override
    public boolean isRenamed() {
        return this.diffEntry != null && this.diffEntry.getChangeType().equals((Object)DiffEntry.ChangeType.RENAME);
    }

    @Override
    public File getOldPath() {
        if (this.isRenamed() || this.isCopied()) {
            return new File(this.workTreePath + File.separator + this.diffEntry.getOldPath());
        }
        return null;
    }

    @Override
    public GitConflictDescriptor getConflictDescriptor() {
        return this.conflictDescriptor;
    }
}

