/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jgit.transport.RemoteConfig;
import org.netbeans.libs.git.GitRemoteConfig;

public class JGitRemoteConfig
implements GitRemoteConfig {
    private final List<String> uris;
    private final List<String> pushUris;
    private final List<String> fetchSpecs;
    private final List<String> pushSpecs;
    private final String remoteName;

    public JGitRemoteConfig(RemoteConfig config) {
        this.remoteName = config.getName();
        this.uris = JGitRemoteConfig.getAsStrings(config.getURIs());
        this.pushUris = JGitRemoteConfig.getAsStrings(config.getPushURIs());
        this.fetchSpecs = JGitRemoteConfig.getAsStrings(config.getFetchRefSpecs());
        this.pushSpecs = JGitRemoteConfig.getAsStrings(config.getPushRefSpecs());
    }

    @Override
    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public List<String> getUris() {
        return Collections.unmodifiableList(this.uris);
    }

    @Override
    public List<String> getPushUris() {
        return Collections.unmodifiableList(this.pushUris);
    }

    @Override
    public List<String> getFetchRefSpecs() {
        return Collections.unmodifiableList(this.fetchSpecs);
    }

    @Override
    public List<String> getPushRefSpecs() {
        return Collections.unmodifiableList(this.pushSpecs);
    }

    private static List<String> getAsStrings(List<? extends Object> list) {
        HashSet<String> set = new HashSet<String>();
        for (Object object : list) {
            set.add(object.toString());
        }
        return new LinkedList<String>(set);
    }
}

