/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.lib.ObjectId;
import org.netbeans.libs.git.GitMergeResult;

public class JGitMergeResult
implements GitMergeResult {
    private final GitMergeResult.MergeStatus mergeStatus;
    private final File workDir;
    private final List<File> conflicts;
    private final List<File> failures;
    private final String newHead;
    private final String base;
    private final String[] mergedCommits;

    public JGitMergeResult(MergeResult result, File workDir) {
        this.mergeStatus = GitMergeResult.MergeStatus.valueOf(result.getMergeStatus().name());
        this.workDir = workDir;
        this.newHead = result.getNewHead() == null ? null : result.getNewHead().getName();
        this.base = result.getBase() == null ? null : result.getBase().getName();
        this.mergedCommits = this.getMergedCommits(result);
        this.conflicts = this.getConflicts(result);
        this.failures = this.getFailures(result);
    }

    @Override
    public GitMergeResult.MergeStatus getMergeStatus() {
        return this.mergeStatus;
    }

    @Override
    public String getBase() {
        return this.base;
    }

    @Override
    public String[] getMergedCommits() {
        return this.mergedCommits;
    }

    @Override
    public String getNewHead() {
        return this.newHead;
    }

    @Override
    public Collection<File> getConflicts() {
        return this.conflicts;
    }

    @Override
    public Collection<File> getFailures() {
        return this.failures;
    }

    private String[] getMergedCommits(MergeResult result) {
        ObjectId[] mergedObjectIds = result.getMergedCommits();
        String[] commits = new String[mergedObjectIds.length];
        for (int i = 0; i < mergedObjectIds.length; ++i) {
            commits[i] = ObjectId.toString((ObjectId)mergedObjectIds[i]);
        }
        return commits;
    }

    private List<File> getConflicts(MergeResult result) {
        LinkedList<File> files = new LinkedList<File>();
        Map mergeConflicts = result.getConflicts();
        if (mergeConflicts != null) {
            for (Map.Entry conflict : mergeConflicts.entrySet()) {
                files.add(new File(this.workDir, (String)conflict.getKey()));
            }
        }
        return Collections.unmodifiableList(files);
    }

    private List<File> getFailures(MergeResult result) {
        LinkedList<File> files = new LinkedList<File>();
        Map obstructions = result.getFailingPaths();
        if (obstructions != null) {
            for (Map.Entry failure : obstructions.entrySet()) {
                files.add(new File(this.workDir, (String)failure.getKey()));
            }
        }
        return Collections.unmodifiableList(files);
    }
}

