/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit;

import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitClientFactory;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.JGitClient;
import org.netbeans.libs.git.jgit.JGitRepository;
import org.netbeans.libs.git.jgit.JGitSshSessionFactory;
import org.openide.util.Lookup;

public final class JGitClientFactory
extends GitClientFactory {
    private static JGitClientFactory instance;
    private final Map<File, JGitRepository> repositoryPool = new WeakHashMap<File, JGitRepository>(5);

    static synchronized JGitClientFactory getInstance() {
        if (instance == null) {
            instance = (JGitClientFactory)Lookup.getDefault().lookup(JGitClientFactory.class);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRepositoryPool() {
        Map<File, JGitRepository> map = this.repositoryPool;
        synchronized (map) {
            this.repositoryPool.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GitClient getClient(File repositoryLocation) throws GitException {
        Map<File, JGitRepository> map = this.repositoryPool;
        synchronized (map) {
            JGitRepository repository = this.repositoryPool.get(repositoryLocation);
            if (repository == null) {
                repository = new JGitRepository(new File(repositoryLocation.getParentFile(), repositoryLocation.getName()));
                this.repositoryPool.put(repositoryLocation, repository);
            }
            SshSessionFactory.setInstance((SshSessionFactory)JGitSshSessionFactory.getDefault());
            return this.createClient(repository);
        }
    }

    private GitClient createClient(JGitRepository repository) {
        return new JGitClient(repository);
    }
}

