/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.util.Collection;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.openide.util.Lookup;

public abstract class GitClientFactory {
    private static GitClientFactory instance;

    public abstract GitClient getClient(File var1) throws GitException;

    public static synchronized GitClientFactory getInstance(String preferredFactory) {
        GitClientFactory selectedFactory = instance;
        if (instance == null || !instance.getClass().getName().equals(preferredFactory)) {
            Collection factories = Lookup.getDefault().lookupAll(GitClientFactory.class);
            if (!factories.isEmpty()) {
                selectedFactory = (GitClientFactory)factories.iterator().next();
            }
            for (GitClientFactory fact : factories) {
                if (!fact.getClass().getName().equals(preferredFactory)) continue;
                selectedFactory = fact;
                break;
            }
            if (instance == null) {
                instance = selectedFactory;
            }
        }
        return selectedFactory;
    }
}

