/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git;

import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.netbeans.libs.git.GitBlameResult;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClientCallback;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitMergeResult;
import org.netbeans.libs.git.GitPullResult;
import org.netbeans.libs.git.GitPushResult;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevertResult;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.GitTransportUpdate;
import org.netbeans.libs.git.GitUser;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.libs.git.progress.ProgressMonitor;

public interface GitClient {
    public void add(File[] var1, ProgressMonitor var2) throws GitException;

    public void addNotificationListener(NotificationListener var1);

    public GitBlameResult blame(File var1, String var2, ProgressMonitor var3) throws GitException.MissingObjectException, GitException;

    public boolean catFile(File var1, String var2, OutputStream var3, ProgressMonitor var4) throws GitException.MissingObjectException, GitException;

    public boolean catIndexEntry(File var1, int var2, OutputStream var3, ProgressMonitor var4) throws GitException;

    public void checkout(File[] var1, String var2, boolean var3, ProgressMonitor var4) throws GitException.MissingObjectException, GitException;

    public void checkoutRevision(String var1, boolean var2, ProgressMonitor var3) throws GitException.MissingObjectException, GitException;

    public void clean(File[] var1, ProgressMonitor var2) throws GitException;

    public GitRevisionInfo commit(File[] var1, String var2, GitUser var3, GitUser var4, ProgressMonitor var5) throws GitException;

    public void copyAfter(File var1, File var2, ProgressMonitor var3) throws GitException;

    public GitBranch createBranch(String var1, String var2, ProgressMonitor var3) throws GitException;

    public GitTag createTag(String var1, String var2, String var3, boolean var4, boolean var5, ProgressMonitor var6) throws GitException;

    public void deleteBranch(String var1, boolean var2, ProgressMonitor var3) throws GitException.NotMergedException, GitException;

    public void deleteTag(String var1, ProgressMonitor var2) throws GitException;

    public void exportCommit(String var1, OutputStream var2, ProgressMonitor var3) throws GitException;

    public void exportDiff(File[] var1, DiffMode var2, OutputStream var3, ProgressMonitor var4) throws GitException;

    public Map<String, GitTransportUpdate> fetch(String var1, ProgressMonitor var2) throws GitException.AuthorizationException, GitException;

    public Map<String, GitTransportUpdate> fetch(String var1, List<String> var2, ProgressMonitor var3) throws GitException.AuthorizationException, GitException;

    public Map<String, GitBranch> getBranches(boolean var1, ProgressMonitor var2) throws GitException;

    public Map<String, GitTag> getTags(ProgressMonitor var1, boolean var2) throws GitException;

    public GitRevisionInfo getCommonAncestor(String[] var1, ProgressMonitor var2) throws GitException;

    public GitRevisionInfo getPreviousRevision(File var1, String var2, ProgressMonitor var3) throws GitException;

    public Map<File, GitStatus> getConflicts(File[] var1, ProgressMonitor var2) throws GitException;

    public Map<File, GitStatus> getStatus(File[] var1, ProgressMonitor var2) throws GitException;

    public GitRemoteConfig getRemote(String var1, ProgressMonitor var2) throws GitException;

    public Map<String, GitRemoteConfig> getRemotes(ProgressMonitor var1) throws GitException;

    public GitRepositoryState getRepositoryState(ProgressMonitor var1) throws GitException;

    public File[] ignore(File[] var1, ProgressMonitor var2) throws GitException;

    public void init(ProgressMonitor var1) throws GitException;

    public File[] listModifiedIndexEntries(File[] var1, ProgressMonitor var2) throws GitException;

    public Map<String, GitBranch> listRemoteBranches(String var1, ProgressMonitor var2) throws GitException.AuthorizationException, GitException;

    public Map<String, String> listRemoteTags(String var1, ProgressMonitor var2) throws GitException.AuthorizationException, GitException;

    public GitRevisionInfo log(String var1, ProgressMonitor var2) throws GitException.MissingObjectException, GitException;

    public GitRevisionInfo[] log(SearchCriteria var1, ProgressMonitor var2) throws GitException.MissingObjectException, GitException;

    public GitMergeResult merge(String var1, ProgressMonitor var2) throws GitException.CheckoutConflictException, GitException;

    public GitPullResult pull(String var1, List<String> var2, String var3, ProgressMonitor var4) throws GitException.AuthorizationException, GitException.CheckoutConflictException, GitException.MissingObjectException, GitException;

    public GitPushResult push(String var1, List<String> var2, List<String> var3, ProgressMonitor var4) throws GitException.AuthorizationException, GitException;

    public void remove(File[] var1, boolean var2, ProgressMonitor var3) throws GitException;

    public void removeNotificationListener(NotificationListener var1);

    public void removeRemote(String var1, ProgressMonitor var2) throws GitException;

    public void rename(File var1, File var2, boolean var3, ProgressMonitor var4) throws GitException;

    public void reset(File[] var1, String var2, boolean var3, ProgressMonitor var4) throws GitException.MissingObjectException, GitException;

    public void reset(String var1, ResetType var2, ProgressMonitor var3) throws GitException.MissingObjectException, GitException;

    public GitRevertResult revert(String var1, String var2, boolean var3, ProgressMonitor var4) throws GitException.MissingObjectException, GitException.CheckoutConflictException, GitException;

    public void setCallback(GitClientCallback var1);

    public void setRemote(GitRemoteConfig var1, ProgressMonitor var2) throws GitException;

    public File[] unignore(File[] var1, ProgressMonitor var2) throws GitException;

    public GitUser getUser() throws GitException;

    public static enum DiffMode {
        HEAD_VS_INDEX,
        HEAD_VS_WORKINGTREE,
        INDEX_VS_WORKINGTREE;

    }

    public static enum ResetType {
        SOFT{

            public String toString() {
                return "--soft";
            }
        }
        ,
        MIXED{

            public String toString() {
                return "--mixed";
            }
        }
        ,
        HARD{

            public String toString() {
                return "--hard";
            }
        };

    }
}

