/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.util.List;
import java.util.concurrent.Callable;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.project.spi.XDebugStarter;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.support.RunScript;
import org.netbeans.modules.php.project.ui.actions.support.XDebugStarterFactory;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class DebugScript
extends RunScript {
    private final Provider provider;

    public DebugScript(Provider provider) {
        super(provider);
        this.provider = provider;
    }

    @Override
    public void run() {
        RP.post(new Runnable(){

            @Override
            public void run() {
                Callable<Cancellable> callable = DebugScript.this.getCallable();
                XDebugStarter dbgStarter = XDebugStarterFactory.getInstance();
                assert (dbgStarter != null);
                if (dbgStarter.isAlreadyRunning()) {
                    if (CommandUtils.warnNoMoreDebugSession()) {
                        dbgStarter.stop();
                        this.run();
                    }
                } else {
                    XDebugStarter.Properties props = XDebugStarter.Properties.create(DebugScript.this.provider.getStartFile(), true, DebugScript.this.provider.getDebugPathMapping(), DebugScript.this.provider.getDebugProxy());
                    dbgStarter.start(DebugScript.this.provider.getProject(), callable, props);
                }
            }
        });
    }

    @Override
    protected boolean isControllable() {
        return false;
    }

    @Override
    protected String getOutputTabTitle() {
        return String.format("%s %s", super.getOutputTabTitle(), NbBundle.getMessage(DebugScript.class, (String)"MSG_Suffix_Debug"));
    }

    @Override
    protected ExternalProcessBuilder getProcessBuilder() {
        return super.getProcessBuilder().addEnvironmentVariable("XDEBUG_CONFIG", "idekey=" + PhpOptions.getInstance().getDebuggerSessionId());
    }

    public static interface Provider
    extends RunScript.Provider {
        public Project getProject();

        public FileObject getStartFile();

        public List<Pair<String, String>> getDebugPathMapping();

        public Pair<String, Integer> getDebugProxy();
    }
}

