/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.ConfigManager;
import org.netbeans.modules.php.project.connections.common.RemoteValidator;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteConfigurationPanel;
import org.netbeans.modules.php.project.ui.LastUsedFolders;
import org.netbeans.modules.php.project.ui.Utils;
import org.netbeans.modules.php.project.ui.customizer.RunAsValidator;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SftpConfigurationPanel
extends JPanel
implements RemoteConfigurationPanel {
    private static final long serialVersionUID = 2815423138730L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private String error = null;
    private String warning = null;
    private JLabel hostLabel;
    private JTextField hostTextField;
    private JButton identityFileBrowseButton;
    private JLabel identityFileLabel;
    private JTextField identityFileTextField;
    private JLabel initialDirectoryLabel;
    private JTextField initialDirectoryTextField;
    private JButton knownHostsFileBrowseButton;
    private JLabel knownHostsFileLabel;
    private JTextField knownHostsFileTextField;
    private JLabel passwordLabel;
    private JLabel passwordLabelInfo;
    private JPasswordField passwordTextField;
    private JLabel portLabel;
    private JTextField portTextField;
    private JLabel timeoutLabel;
    private JTextField timeoutTextField;
    private JLabel userLabel;
    private JTextField userTextField;

    public SftpConfigurationPanel() {
        this.initComponents();
        this.registerListeners();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public boolean isValidConfiguration() {
        String err = RemoteValidator.validateHost(this.hostTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        err = RemoteValidator.validatePort(this.portTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        err = RemoteValidator.validateUser(this.userTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        if (!this.validateIdentityFile()) {
            return false;
        }
        if (!this.validateKnownHostsFile()) {
            return false;
        }
        if (!this.validateInitialDirectory()) {
            return false;
        }
        err = RemoteValidator.validateTimeout(this.timeoutTextField.getText());
        if (err != null) {
            this.setError(err);
            return false;
        }
        this.setError(null);
        return true;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected void setError(String error) {
        this.error = error;
    }

    @Override
    public String getWarning() {
        return this.warning;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    private void registerListeners() {
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.hostTextField.getDocument().addDocumentListener(documentListener);
        this.portTextField.getDocument().addDocumentListener(documentListener);
        this.userTextField.getDocument().addDocumentListener(documentListener);
        this.passwordTextField.getDocument().addDocumentListener(documentListener);
        this.knownHostsFileTextField.getDocument().addDocumentListener(documentListener);
        this.identityFileTextField.getDocument().addDocumentListener(documentListener);
        this.initialDirectoryTextField.getDocument().addDocumentListener(documentListener);
        this.timeoutTextField.getDocument().addDocumentListener(documentListener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private boolean validateIdentityFile() {
        return this.validateFile(this.getIdentityFile(), NbBundle.getMessage(SftpConfiguration.class, (String)"LBL_IdentityFile"));
    }

    private boolean validateKnownHostsFile() {
        return this.validateFile(this.getKnownHostsFile(), NbBundle.getMessage(SftpConfiguration.class, (String)"LBL_KnownHostsFile"));
    }

    private boolean validateFile(String path, String label) {
        if (!StringUtils.hasText((String)path)) {
            return true;
        }
        File file = new File(path);
        if (!file.isFile()) {
            this.setError(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"MSG_FileNotFile", (Object)label));
            return false;
        }
        if (!file.isAbsolute()) {
            this.setError(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"MSG_FileNotAbsolute", (Object)label));
            return false;
        }
        return true;
    }

    private boolean validateInitialDirectory() {
        String err = RunAsValidator.validateUploadDirectory(this.getInitialDirectory(), false);
        if (err != null) {
            this.setError(err);
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.hostLabel = new JLabel();
        this.knownHostsFileLabel = new JLabel();
        this.hostTextField = new JTextField();
        this.portLabel = new JLabel();
        this.portTextField = new JTextField();
        this.userLabel = new JLabel();
        this.userTextField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordTextField = new JPasswordField();
        this.passwordLabelInfo = new JLabel();
        this.identityFileLabel = new JLabel();
        this.identityFileTextField = new JTextField();
        this.identityFileBrowseButton = new JButton();
        this.knownHostsFileTextField = new JTextField();
        this.knownHostsFileBrowseButton = new JButton();
        this.initialDirectoryLabel = new JLabel();
        this.initialDirectoryTextField = new JTextField();
        this.timeoutLabel = new JLabel();
        this.timeoutTextField = new JTextField();
        this.setFocusTraversalPolicy(null);
        this.hostLabel.setLabelFor(this.hostTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.text"));
        this.knownHostsFileLabel.setLabelFor(this.knownHostsFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.knownHostsFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.text"));
        this.hostTextField.setMinimumSize(new Dimension(150, 19));
        this.portLabel.setLabelFor(this.portTextField);
        Mnemonics.setLocalizedText((JLabel)this.portLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.text"));
        this.userLabel.setLabelFor(this.userTextField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.text"));
        this.passwordLabel.setLabelFor(this.passwordTextField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.text"));
        this.passwordLabelInfo.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabelInfo, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.text"));
        this.identityFileLabel.setLabelFor(this.identityFileTextField);
        Mnemonics.setLocalizedText((JLabel)this.identityFileLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.identityFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.text"));
        this.identityFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SftpConfigurationPanel.this.identityFileBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.knownHostsFileBrowseButton, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.text"));
        this.knownHostsFileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SftpConfigurationPanel.this.knownHostsFileBrowseButtonActionPerformed(evt);
            }
        });
        this.initialDirectoryLabel.setLabelFor(this.initialDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.initialDirectoryLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.text"));
        this.timeoutLabel.setLabelFor(this.timeoutTextField);
        Mnemonics.setLocalizedText((JLabel)this.timeoutLabel, (String)NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.text"));
        this.timeoutTextField.setMinimumSize(new Dimension(20, 19));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabel).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostLabel).addComponent(this.userLabel).addComponent(this.initialDirectoryLabel).addComponent(this.timeoutLabel).addComponent(this.identityFileLabel).addComponent(this.knownHostsFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.passwordLabelInfo, -2, -1, -2).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.knownHostsFileTextField, -1, 185, Short.MAX_VALUE).addComponent(this.identityFileTextField, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.userTextField, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.hostTextField, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.timeoutTextField, GroupLayout.Alignment.LEADING, -1, 185, Short.MAX_VALUE).addComponent(this.passwordTextField, -1, 185, Short.MAX_VALUE).addComponent(this.initialDirectoryTextField, -1, 185, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.portLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.portTextField)).addComponent(this.identityFileBrowseButton)).addComponent(this.knownHostsFileBrowseButton, GroupLayout.Alignment.TRAILING)).addGap(0, 0, 0)))));
        layout.linkSize(0, this.identityFileBrowseButton, this.knownHostsFileBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostLabel).addComponent(this.portLabel).addComponent(this.portTextField, -2, -1, -2).addComponent(this.hostTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordLabelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.identityFileTextField, -2, -1, -2).addComponent(this.identityFileLabel).addComponent(this.identityFileBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.knownHostsFileTextField, -2, -1, -2).addComponent(this.knownHostsFileBrowseButton).addComponent(this.knownHostsFileLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initialDirectoryLabel).addComponent(this.initialDirectoryTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeoutTextField, -2, -1, -2).addComponent(this.timeoutLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        this.hostLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleName"));
        this.hostLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostLabel.AccessibleContext.accessibleDescription"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleName"));
        this.knownHostsFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileLabel.AccessibleContext.accessibleDescription"));
        this.hostTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleName"));
        this.hostTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.hostTextField.AccessibleContext.accessibleDescription"));
        this.portLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleName"));
        this.portLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portLabel.AccessibleContext.accessibleDescription"));
        this.portTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleName"));
        this.portTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.portTextField.AccessibleContext.accessibleDescription"));
        this.userLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleName"));
        this.userLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userLabel.AccessibleContext.accessibleDescription"));
        this.userTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleName"));
        this.userTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.userTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleName"));
        this.passwordLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabel.AccessibleContext.accessibleDescription"));
        this.passwordTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleName"));
        this.passwordTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordTextField.AccessibleContext.accessibleDescription"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleName"));
        this.passwordLabelInfo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.passwordLabelInfo.AccessibleContext.accessibleDescription"));
        this.identityFileLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleName"));
        this.identityFileLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileLabel.AccessibleContext.accessibleDescription"));
        this.identityFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleName"));
        this.identityFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileTextField.AccessibleContext.accessibleDescription"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleName"));
        this.identityFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.identityFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleName"));
        this.knownHostsFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileTextField.AccessibleContext.accessibleDescription"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleName"));
        this.knownHostsFileBrowseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.knownHostsFileBrowseButton.AccessibleContext.accessibleDescription"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleName"));
        this.initialDirectoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryLabel.AccessibleContext.accessibleDescription"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleName"));
        this.initialDirectoryTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.initialDirectoryTextField.AccessibleContext.accessibleDescription"));
        this.timeoutLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleName"));
        this.timeoutLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutLabel.AccessibleContext.accessibleDescription"));
        this.timeoutTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleName"));
        this.timeoutTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.timeoutTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SftpConfigurationPanel.class, (String)"SftpConfigurationPanel.AccessibleContext.accessibleDescription"));
    }

    private void identityFileBrowseButtonActionPerformed(ActionEvent evt) {
        File newFile = Utils.browseFileAction(this, LastUsedFolders.getPrivateKey(), NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectIdentityFile"));
        if (newFile != null) {
            this.setIdentityFile(newFile.getAbsolutePath());
            LastUsedFolders.setPrivateKey(newFile);
        }
    }

    private void knownHostsFileBrowseButtonActionPerformed(ActionEvent evt) {
        File newFile = Utils.browseFileAction(this, LastUsedFolders.getKnownHosts(), NbBundle.getMessage(SftpConfigurationPanel.class, (String)"LBL_SelectKnownHostsFile"));
        if (newFile != null) {
            this.setKnownHostsFile(newFile.getAbsolutePath());
            LastUsedFolders.setKnownHosts(newFile);
        }
    }

    public String getHostName() {
        return this.hostTextField.getText();
    }

    public void setHostName(String hostName) {
        this.hostTextField.setText(hostName);
    }

    public String getPort() {
        return this.portTextField.getText();
    }

    public void setPort(String port) {
        this.portTextField.setText(port);
    }

    public String getUserName() {
        return this.userTextField.getText();
    }

    public void setUserName(String userName) {
        this.userTextField.setText(userName);
    }

    public String getPassword() {
        return new String(this.passwordTextField.getPassword());
    }

    public void setPassword(String password) {
        this.passwordTextField.setText(password);
    }

    public String getKnownHostsFile() {
        return this.knownHostsFileTextField.getText();
    }

    public void setKnownHostsFile(String knownHostsFile) {
        this.knownHostsFileTextField.setText(knownHostsFile);
    }

    public String getIdentityFile() {
        return this.identityFileTextField.getText();
    }

    public void setIdentityFile(String identityFile) {
        this.identityFileTextField.setText(identityFile);
    }

    public String getInitialDirectory() {
        return this.initialDirectoryTextField.getText();
    }

    public void setInitialDirectory(String initialDirectory) {
        this.initialDirectoryTextField.setText(initialDirectory);
    }

    public String getTimeout() {
        return this.timeoutTextField.getText();
    }

    public void setTimeout(String timeout) {
        this.timeoutTextField.setText(timeout);
    }

    @Override
    public void read(ConfigManager.Configuration cfg) {
        this.setHostName(cfg.getValue("host"));
        this.setPort(cfg.getValue("port"));
        this.setUserName(cfg.getValue("user"));
        this.setPassword(cfg.getValue("password", true));
        this.setKnownHostsFile(cfg.getValue("knownHostsFile"));
        this.setIdentityFile(cfg.getValue("identityFile"));
        this.setInitialDirectory(cfg.getValue("initialDirectory"));
        this.setTimeout(cfg.getValue("timeout"));
    }

    @Override
    public void store(ConfigManager.Configuration cfg) {
        cfg.putValue("host", this.getHostName());
        cfg.putValue("port", this.getPort());
        cfg.putValue("user", this.getUserName());
        cfg.putValue("password", this.getPassword(), true);
        cfg.putValue("knownHostsFile", this.getKnownHostsFile());
        cfg.putValue("identityFile", this.getIdentityFile());
        cfg.putValue("initialDirectory", RunAsValidator.sanitizeUploadDirectory(this.getInitialDirectory(), false));
        cfg.putValue("timeout", this.getTimeout());
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            SftpConfigurationPanel.this.fireChange();
        }
    }
}

