/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class ConfigManager {
    static final Logger LOGGER = Logger.getLogger(ConfigManager.class.getName());
    private static final String PROP_DISPLAY_NAME = "$label";
    private final Map<String, Map<String, String>> configs;
    private final Map<String, String> configErrors = new HashMap<String, String>();
    private final ConfigProvider configProvider;
    private final String[] propertyNames;
    private final ChangeSupport changeSupport;
    private volatile String currentConfig;

    public ConfigManager(ConfigProvider configProvider) {
        this(configProvider, null);
    }

    public ConfigManager(ConfigProvider configProvider, String currentConfig) {
        this.configProvider = configProvider;
        this.changeSupport = new ChangeSupport((Object)this);
        this.configs = ConfigManager.createEmptyConfigs();
        this.configs.putAll(configProvider.getConfigs());
        this.currentConfig = currentConfig;
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(configProvider.getConfigProperties()));
        tmp.add(PROP_DISPLAY_NAME);
        this.propertyNames = tmp.toArray(new String[tmp.size()]);
    }

    public static Map<String, Map<String, String>> createEmptyConfigs() {
        TreeMap<String, Map<String, String>> configs = new TreeMap<String, Map<String, String>>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1 != null ? (s2 != null ? s1.compareTo(s2) : 1) : (s2 != null ? -1 : 0);
            }
        });
        configs.put(null, null);
        return configs;
    }

    public static Comparator<Configuration> getConfigurationComparator() {
        return new Comparator<Configuration>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(Configuration c1, Configuration c2) {
                String lbl1 = c1.getDisplayName();
                String lbl2 = c2.getDisplayName();
                return this.coll.compare(lbl1, lbl2);
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public synchronized void reset() {
        this.configs.clear();
        this.configErrors.clear();
        this.configs.putAll(this.configProvider.getConfigs());
    }

    public synchronized boolean exists(String name) {
        return this.configs.keySet().contains(name) && this.configs.get(name) != null;
    }

    public synchronized Configuration createNew(String name, String displayName) {
        assert (!this.exists(name));
        this.configs.put(name, new HashMap());
        Configuration retval = new Configuration(name);
        if (!name.equals(displayName)) {
            retval.putValue(PROP_DISPLAY_NAME, displayName);
        }
        this.markAsCurrentConfiguration(name);
        return retval;
    }

    public synchronized Collection<String> configurationNames() {
        return this.configs.keySet();
    }

    public synchronized Configuration currentConfiguration() {
        if (this.exists(this.currentConfig)) {
            return new Configuration(this.currentConfig);
        }
        LOGGER.log(Level.WARNING, "Missing configuration \"{0}\" found - perhaps deleted?", this.currentConfig);
        return this.createNew(this.currentConfig, this.currentConfig);
    }

    public Configuration defaultConfiguration() {
        return new Configuration();
    }

    public synchronized Configuration configurationFor(String name) {
        return new Configuration(name);
    }

    public synchronized void markAsCurrentConfiguration(String currentConfig) {
        assert (this.configs.keySet().contains(currentConfig));
        this.currentConfig = currentConfig;
        this.changeSupport.fireChange();
    }

    private String[] getPropertyNames() {
        return this.propertyNames;
    }

    private Map<String, String> getProperties(String config) {
        return this.configs.get(config);
    }

    public static interface ConfigProvider {
        public String[] getConfigProperties();

        public Map<String, Map<String, String>> getConfigs();
    }

    public final class Configuration {
        private final String name;

        private Configuration() {
            this((String)null);
        }

        private Configuration(String name) {
            if (name != null && name.trim().length() == 0) {
                name = null;
            }
            assert (ConfigManager.this.configs.keySet().contains(name)) : "Unknown configuration: " + name;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            String retval = this.getValue(ConfigManager.PROP_DISPLAY_NAME);
            retval = retval != null ? retval : this.getName();
            return retval != null ? retval : NbBundle.getMessage(ConfigManager.class, (String)"LBL_DefaultConfiguration");
        }

        public boolean isDefault() {
            return this.name == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                ConfigManager.this.configs.put(this.getName(), null);
                ConfigManager.this.configErrors.put(this.getName(), null);
                ConfigManager.this.markAsCurrentConfiguration(null);
            }
        }

        private boolean isDeleted() {
            return ConfigManager.this.configs.get(this.getName()) == null;
        }

        public String getValue(String propertyName, boolean decode) {
            String value = this.getValue(propertyName);
            if (decode && value != null) {
                value = this.rot13coder(value);
            }
            return value;
        }

        private String rot13coder(String input) {
            char[] out = new char[input.length()];
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c >= 'a' && c <= 'm') {
                    c = (char)(c + 13);
                } else if (c >= 'n' && c <= 'z') {
                    c = (char)(c - 13);
                } else if (c >= 'A' && c <= 'M') {
                    c = (char)(c + 13);
                } else if (c >= 'A' && c <= 'Z') {
                    c = (char)(c - 13);
                }
                out[i] = c;
            }
            return String.valueOf(out);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getValue(String propertyName) {
            assert (Arrays.asList(this.getPropertyNames()).contains(propertyName)) : "Unknown property: " + propertyName;
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                return !this.isDeleted() ? (String)ConfigManager.this.getProperties(this.getName()).get(propertyName) : null;
            }
        }

        public void putValue(String propertyName, String value, boolean encode) {
            if (encode && value != null) {
                value = this.rot13coder(value);
            }
            this.putValue(propertyName, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putValue(String propertyName, String value) {
            assert (Arrays.asList(this.getPropertyNames()).contains(propertyName)) : "Unknown property: " + propertyName;
            assert (!this.isDeleted());
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                ConfigManager.this.getProperties(this.getName()).put(propertyName, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getPropertyNames() {
            ConfigManager configManager = ConfigManager.this;
            synchronized (configManager) {
                return ConfigManager.this.getPropertyNames();
            }
        }

        public String getErrorMessage() {
            return (String)ConfigManager.this.configErrors.get(this.name);
        }

        public void setErrorMessage(String errorMessage) {
            ConfigManager.this.configErrors.put(this.name, errorMessage);
        }

        public boolean isValid() {
            return ConfigManager.this.configErrors.get(this.name) == null;
        }
    }
}

