/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.ui.AddToFavoritesAction;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class OpenTerminalAction
extends SingleHostAction {
    private JMenu remotePopupMenu;
    private JMenu localPopupMenu;

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"OpenTerminalMenuItem");
    }

    @Override
    protected void performAction(ExecutionEnvironment env, Node node) {
    }

    @Override
    public boolean isVisible(Node node) {
        return true;
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        JMenu out = this.localPopupMenu;
        Node[] activatedNodes = this.getActivatedNodes();
        if (activatedNodes != null && activatedNodes.length == 1 && this.isRemote(activatedNodes[0])) {
            out = this.remotePopupMenu;
        }
        return out;
    }

    private void createSubMenu() {
        if (this.remotePopupMenu == null) {
            this.remotePopupMenu = new JMenu(this.getName());
            this.remotePopupMenu.add(((AddHome)SystemAction.get(AddHome.class)).getPopupPresenter());
            this.remotePopupMenu.add(((AddMirror)SystemAction.get(AddMirror.class)).getPopupPresenter());
            this.remotePopupMenu.add(((AddRoot)SystemAction.get(AddRoot.class)).getPopupPresenter());
        }
        if (this.localPopupMenu == null) {
            this.localPopupMenu = new JMenu(this.getName());
            this.localPopupMenu.add(((AddHome)SystemAction.get(AddHome.class)).getPopupPresenter());
            this.localPopupMenu.add(((AddRoot)SystemAction.get(AddRoot.class)).getPopupPresenter());
        }
    }

    private static final class AddMirror
    extends AddPlace {
        public AddMirror() {
            super(PLACE.MIRROR);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot(env);
            return remoteSyncRoot;
        }
    }

    private static final class AddProjects
    extends AddPlace {
        public AddProjects() {
            super(PLACE.PROJECTS);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static final class AddHome
    extends AddPlace {
        public AddHome() {
            super(PLACE.HOME);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                if (hostInfo != null) {
                    String userDir = hostInfo.getUserDir();
                    return userDir;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    private static final class AddRoot
    extends AddPlace {
        public AddRoot() {
            super(PLACE.ROOT);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static abstract class AddPlace
    extends SingleHostAction {
        private final PLACE place;

        private AddPlace(PLACE place) {
            this.place = place;
            this.putProperty("noIconInMenu", Boolean.TRUE);
        }

        protected abstract String getPath(ExecutionEnvironment var1);

        @Override
        protected void performAction(final ExecutionEnvironment env, Node node) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenTerminalAction.class, (String)"OpenTerminalAction.opening"));
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionManager.getInstance().connectTo(env);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    final String path = AddPlace.this.getPath(env);
                    if (path != null) {
                        Runnable openFavorites = new Runnable(){

                            @Override
                            public void run() {
                                TerminalSupport.openTerminal((String)env.getDisplayName(), (ExecutionEnvironment)env, (String)path);
                            }
                        };
                        SwingUtilities.invokeLater(openFavorites);
                    } else {
                        String msg = !ConnectionManager.getInstance().isConnectedTo(env) ? NbBundle.getMessage(AddToFavoritesAction.class, (String)"NotConnected", (Object)AddPlace.this.getPath(env), (Object)env.getDisplayName()) : NbBundle.getMessage(AddToFavoritesAction.class, (String)"NoRemotePath", (Object)AddPlace.this.getPath(env));
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                    }
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }

        public String getName() {
            return this.place.getName();
        }
    }

    private static enum PLACE {
        ROOT("OpenRoot"),
        HOME("OpenHome"),
        PROJECTS("OpenProjects"),
        MIRROR("OpenMirror");

        private final String name;

        private PLACE(String nameKey) {
            this.name = NbBundle.getMessage(OpenTerminalAction.class, (String)nameKey);
        }

        private String getName() {
            return this.name;
        }
    }
}

