/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AddToFavoritesAction
extends SingleHostAction {
    private JMenu popupMenu;

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"AddToFavoritesMenuItem");
    }

    @Override
    protected void performAction(ExecutionEnvironment env, Node node) {
        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        FileObject fo = fs.getRoot();
        if (!Favorites.getDefault().isInFavorites(fo)) {
            try {
                Favorites.getDefault().add(new FileObject[]{fo});
            }
            catch (NullPointerException ex) {
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isVisible(Node node) {
        TopComponent favoritesComponent = AddToFavoritesAction.getFavorites();
        return favoritesComponent != null && this.isRemote(node);
    }

    private static TopComponent getFavorites() {
        TopComponent favoritesComponent = WindowManager.getDefault().findTopComponent("favorites");
        return favoritesComponent;
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.popupMenu;
    }

    private void createSubMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JMenu(this.getName());
            this.popupMenu.add(new AddHome().getPopupPresenter());
            this.popupMenu.add(new AddMirror().getPopupPresenter());
            this.popupMenu.add(new AddRoot().getPopupPresenter());
        }
    }

    private static final class AddMirror
    extends AddPlace {
        public AddMirror() {
            super(PLACE.MIRROR);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            String path = this.getPath(env);
            return path == null ? null : fs.findResource(path);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot(env);
            return remoteSyncRoot;
        }
    }

    private static final class AddProjects
    extends AddPlace {
        public AddProjects() {
            super(PLACE.PROJECTS);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            return fs.getRoot();
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static final class AddHome
    extends AddPlace {
        public AddHome() {
            super(PLACE.HOME);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            String path = this.getPath(env);
            return path == null ? null : fs.findResource(path);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                if (hostInfo != null) {
                    String userDir = hostInfo.getUserDir();
                    return userDir;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
    }

    private static final class AddRoot
    extends AddPlace {
        public AddRoot() {
            super(PLACE.ROOT);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            return fs.getRoot();
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static abstract class AddPlace
    extends SingleHostAction {
        private final PLACE place;

        private AddPlace(PLACE place) {
            this.place = place;
            this.putProperty("noIconInMenu", Boolean.TRUE);
        }

        protected abstract FileObject getRoot(ExecutionEnvironment var1, FileSystem var2);

        protected abstract String getPath(ExecutionEnvironment var1);

        @Override
        protected void performAction(final ExecutionEnvironment env, Node node) {
            TopComponent favorites = AddToFavoritesAction.getFavorites();
            if (favorites != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ConnectionManager.getInstance().connectTo(env);
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (CancellationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                        final FileObject fo = AddPlace.this.getRoot(env, fs);
                        if (fo != null) {
                            Runnable openFavorites = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Favorites.getDefault().selectWithAddition(fo);
                                    }
                                    catch (DataObjectNotFoundException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(openFavorites);
                        } else {
                            String msg = !ConnectionManager.getInstance().isConnectedTo(env) ? NbBundle.getMessage(AddToFavoritesAction.class, (String)"NotConnected", (Object)AddPlace.this.getPath(env), (Object)env.getDisplayName()) : NbBundle.getMessage(AddToFavoritesAction.class, (String)"NoRemotePath", (Object)AddPlace.this.getPath(env));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                        }
                    }
                };
                RequestProcessor.getDefault().post(runnable);
            }
        }

        public String getName() {
            return this.place.getName();
        }
    }

    private static enum PLACE {
        ROOT("AddRoot"),
        HOME("AddHome"),
        PROJECTS("AddProjects"),
        MIRROR("AddMirror");

        private final String name;

        private PLACE(String nameKey) {
            this.name = NbBundle.getMessage(AddToFavoritesAction.class, (String)nameKey);
        }

        private String getName() {
            return this.name;
        }
    }
}

