/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.remote.support.RemoteProjectSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.RemoteBuildProjectActionHandlerFactory;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

class RemoteBuildProjectActionHandler
implements ProjectActionHandler {
    private ProjectActionHandler delegate;
    private ProjectActionEvent pae;
    private ExecutionEnvironment execEnv;
    private final List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private PrintWriter out;
    private PrintWriter err;
    private static final String testWorkerRunningProp = "cnd.remote.sync.worker.running";

    RemoteBuildProjectActionHandler() {
    }

    public void init(ProjectActionEvent pae, ProjectActionEvent[] paes) {
        this.pae = pae;
        this.delegate = RemoteBuildProjectActionHandlerFactory.createDelegateHandler(pae);
        this.delegate.init(pae, paes);
        this.execEnv = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment();
    }

    public void addExecutionListener(ExecutionListener l) {
        this.delegate.addExecutionListener(l);
        this.listeners.add(l);
    }

    public void removeExecutionListener(ExecutionListener l) {
        this.delegate.removeExecutionListener(l);
        this.listeners.remove(l);
    }

    public boolean canCancel() {
        return this.delegate.canCancel();
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public void execute(InputOutput io) {
        if (this.execEnv.isLocal()) {
            this.delegate.execute(io);
            return;
        }
        try {
            ConnectionManager.getInstance().connectTo(this.execEnv);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            if (io != null) {
                io.getErr().printf("%s\n", new Object[]{ex.getMessage()});
            }
            this.delegate.cancel();
            return;
        }
        catch (CancellationException ex) {
            this.delegate.cancel();
            return;
        }
        if (io != null) {
            this.err = io.getErr();
            this.out = io.getOut();
        }
        if (!RemoteProjectSupport.projectExists(this.pae.getProject())) {
            this.delegate.cancel();
            return;
        }
        File privProjectStorage = RemoteProjectSupport.getPrivateStorage(this.pae.getProject());
        MakeConfiguration conf = this.pae.getConfiguration();
        File[] sourceDirs = RemoteProjectSupport.getProjectSourceDirs(this.pae.getProject(), conf);
        RemoteSyncFactory syncFactory = conf.getRemoteSyncFactory();
        final RemoteSyncWorker worker = syncFactory == null ? null : syncFactory.createNew(this.execEnv, this.out, this.err, privProjectStorage, sourceDirs);
        CndUtils.assertTrue((worker != null ? 1 : 0) != 0, (String)"RemoteSyncWorker shouldn't be null");
        if (worker == null) {
            this.delegate.execute(io);
            return;
        }
        HashMap env2add = new HashMap();
        System.setProperty(testWorkerRunningProp, "true");
        if (worker.startup(env2add)) {
            ExecutionListener listener = new ExecutionListener(){

                public void executionStarted(int pid) {
                }

                public void executionFinished(int rc) {
                    worker.shutdown();
                    RemoteBuildProjectActionHandler.this.delegate.removeExecutionListener((ExecutionListener)this);
                    System.setProperty(RemoteBuildProjectActionHandler.testWorkerRunningProp, "false");
                }
            };
            this.delegate.addExecutionListener(listener);
            Env env = this.pae.getProfile().getEnvironment();
            for (Map.Entry entry : env2add.entrySet()) {
                if (RemoteUtil.LOGGER.isLoggable(Level.FINE)) {
                    RemoteUtil.LOGGER.fine(String.format("\t%s=%s", entry.getKey(), entry.getValue()));
                }
                env.putenv((String)entry.getKey(), (String)entry.getValue());
            }
            this.delegate.execute(io);
        } else {
            System.setProperty(testWorkerRunningProp, "false");
            for (ExecutionListener l : this.listeners) {
                l.executionFinished(-8);
            }
            if (this.err != null) {
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Build_Failed"));
            }
        }
    }

    static void testWaitWorkerFinished(int timeout) throws TimeoutException, InterruptedException {
        long end = System.currentTimeMillis() + (long)(timeout * 1000);
        while (Boolean.getBoolean(testWorkerRunningProp)) {
            long rest = end - System.currentTimeMillis();
            if (rest < 0L) {
                throw new TimeoutException();
            }
            RemoteUtil.LOGGER.finest("Waiting until sync worker is finished");
            Thread.sleep(rest < 200L ? rest : 200L);
        }
    }
}

