/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.view.widget.ExpandableWidget;
import org.netbeans.modules.websvc.design.view.widget.ExpanderWidget;
import org.netbeans.modules.websvc.design.view.widget.RoundedBorder3D;

public abstract class AbstractTitledWidget
extends Widget
implements ExpandableWidget {
    public static final Color BORDER_COLOR = new Color(169, 197, 235);
    public static final Color TITLE_COLOR = new Color(184, 215, 255);
    public static final Color TITLE_COLOR_BRIGHT = new Color(241, 245, 252);
    public static final Color TITLE_COLOR_PARAMETER = new Color(235, 255, 255);
    public static final Color TITLE_COLOR_OUTPUT = new Color(240, 240, 240);
    public static final Color TITLE_COLOR_FAULT = new Color(245, 227, 225);
    public static final Color TITLE_COLOR_DESC = new Color(240, 240, 240);
    public static final Color BORDER_COLOR_BLACK = Color.BLACK;
    public static final int RADIUS = 12;
    private Color borderColor = BORDER_COLOR;
    private int radius = 12;
    private int hgap = 12;
    private int cgap = 12;
    private int depth = this.radius / 3;
    private boolean expanded;
    private transient Widget headerWidget;
    private transient Widget seperatorWidget;
    private transient Widget contentWidget;
    private transient ExpanderWidget expander;

    public AbstractTitledWidget(ObjectScene scene, int radius, Color color) {
        this(scene, radius, radius, radius, color);
    }

    public AbstractTitledWidget(ObjectScene scene, int radius, int hgap, int cgap, Color color) {
        super((Scene)scene);
        this.radius = radius;
        this.borderColor = color;
        this.hgap = hgap;
        this.cgap = cgap;
        this.depth = radius / 3;
        this.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)0));
        this.setBorder(new RoundedBorder3D(this, radius, this.depth, 0, 0, this.borderColor));
        this.headerWidget = new Widget(this.getScene());
        this.headerWidget.setBorder(BorderFactory.createEmptyBorder((int)hgap, (int)(hgap / 2)));
        this.headerWidget.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)hgap));
        this.addChild(this.headerWidget);
        this.seperatorWidget = new SeparatorWidget(this.getScene(), SeparatorWidget.Orientation.HORIZONTAL);
        this.seperatorWidget.setForeground(this.borderColor);
        if (this.isExpandable()) {
            this.contentWidget = this.createContentWidget();
            this.expanded = ExpanderWidget.isExpanded(this, true);
            if (this.expanded) {
                this.expandWidget();
            } else {
                this.collapseWidget();
            }
            this.expander = new ExpanderWidget(this.getScene(), this, this.expanded);
        }
        this.getActions().addAction(scene.createSelectAction());
    }

    protected Widget getContentWidget() {
        return this.contentWidget;
    }

    protected final Widget createContentWidget() {
        Widget widget = new Widget(this.getScene());
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)this.cgap));
        widget.setBorder(BorderFactory.createEmptyBorder((int)this.cgap));
        return widget;
    }

    protected final Widget createHeaderWidget() {
        Widget widget = new Widget(this.getScene());
        widget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)this.radius));
        return widget;
    }

    protected Widget getHeaderWidget() {
        return this.headerWidget;
    }

    protected ExpanderWidget getExpanderWidget() {
        return this.expander;
    }

    protected final void paintWidget() {
        Rectangle bounds = this.getClientArea();
        Graphics2D g = this.getGraphics();
        Paint oldPaint = g.getPaint();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double((float)bounds.x + 0.75f, (float)bounds.y + 0.75f, (float)bounds.width - 1.5f, (float)bounds.height - 1.5f, this.radius, this.radius);
        if (this.isExpanded()) {
            int titleHeight = this.headerWidget.getBounds().height;
            Area titleArea = new Area(rect);
            titleArea.subtract(new Area(new Rectangle(bounds.x, bounds.y + titleHeight, bounds.width, bounds.height)));
            g.setPaint(this.getTitlePaint(titleArea.getBounds()));
            g.fill(titleArea);
            if (this.isOpaque()) {
                Area bodyArea = new Area(rect);
                bodyArea.subtract(titleArea);
                g.setPaint(this.getBackground());
                g.fill(bodyArea);
            }
        } else {
            g.setPaint(this.getTitlePaint(bounds));
            g.fill(rect);
        }
        g.setPaint(oldPaint);
    }

    protected Paint getTitlePaint(Rectangle bounds) {
        return new GradientPaint(bounds.x, bounds.y, TITLE_COLOR_BRIGHT, bounds.x, bounds.y + bounds.height, TITLE_COLOR);
    }

    protected void collapseWidget() {
        if (this.seperatorWidget.getParentWidget() != null) {
            this.removeChild(this.seperatorWidget);
        }
        if (this.getContentWidget().getParentWidget() != null) {
            this.removeChild(this.getContentWidget());
        }
    }

    protected void expandWidget() {
        if (this.seperatorWidget.getParentWidget() == null) {
            this.addChild(this.seperatorWidget);
        }
        if (this.getContentWidget().getParentWidget() == null) {
            this.addChild(this.getContentWidget());
        }
    }

    @Override
    public Object hashKey() {
        return null;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (!this.isExpandable()) {
            return;
        }
        if (this.expanded != expanded) {
            this.expanded = expanded;
            this.revalidate(true);
            if (expanded) {
                this.expandWidget();
            } else {
                this.collapseWidget();
            }
            this.getScene().validate();
            this.expander.setSelected(expanded);
        }
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    protected boolean isExpandable() {
        return true;
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Object key = this.hashKey();
        if (key != null) {
            this.getObjectScene().addObject(key, new Widget[]{this});
        }
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        Object key = this.hashKey();
        if (key != null && this.getObjectScene().isObject(key)) {
            this.getObjectScene().removeObject(key);
        }
    }

    protected void notifyStateChanged(ObjectState previousState, ObjectState state) {
        if (previousState.isSelected() != state.isSelected()) {
            this.revalidate(true);
        }
    }

    protected ObjectScene getObjectScene() {
        return (ObjectScene)super.getScene();
    }
}

