/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util.status;

import java.io.File;
import javax.swing.Action;
import org.netbeans.modules.versioning.util.common.VCSFileInformation;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public abstract class VCSStatusNode<T extends VCSFileNode>
extends AbstractNode {
    protected final T node;
    protected final NameProperty nameProperty;
    protected final PathProperty pathProperty;
    protected final StatusProperty statusProperty;
    private static final String[] zeros = new String[]{"", "00", "0", ""};

    protected VCSStatusNode(T node) {
        super(Children.LEAF, Lookups.fixed((Object[])((VCSFileNode)node).getLookupObjects()));
        this.node = node;
        this.nameProperty = new NameProperty(this);
        this.pathProperty = new PathProperty(this);
        this.statusProperty = new StatusProperty(this);
    }

    public abstract Action getPreferredAction();

    public String getHtmlDisplayName() {
        return ((VCSFileInformation)((VCSFileNode)this.node).getInformation()).annotateNameHtml(this.nameProperty.getValue());
    }

    public String getName() {
        return ((VCSFileNode)this.node).getName();
    }

    public File getFile() {
        return ((VCSFileNode)this.node).getFile();
    }

    public final T getFileNode() {
        return this.node;
    }

    public abstract void refresh();

    public static class StatusProperty
    extends NodeProperty<String> {
        public static final String NAME = "status";
        public static final String DISPLAY_NAME = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_Status.DisplayName");
        public static final String DESCRIPTION = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_Status.Description");
        private final VCSFileNode fileNode;

        public StatusProperty(VCSStatusNode statusNode) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            String sortable = Integer.toString(((VCSFileInformation)((VCSFileNode)statusNode.getFileNode()).getInformation()).getComparableStatus());
            this.setValue("sortkey", zeros[sortable.length()] + sortable + "\t" + ((VCSFileNode)statusNode.getFileNode()).getName());
            this.fileNode = statusNode.node;
        }

        @Override
        public String getValue() {
            Object finfo = this.fileNode.getInformation();
            return ((VCSFileInformation)finfo).getStatusText();
        }
    }

    public static class NameProperty
    extends NodeProperty<String> {
        public static final String NAME = "name";
        public static final String DISPLAY_NAME = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_File.DisplayName");
        public static final String DESCRIPTION = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_File.Description");
        private final VCSFileNode fileNode;

        public NameProperty(VCSStatusNode statusNode) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            this.setValue("sortkey", ((VCSFileNode)statusNode.getFileNode()).getName());
            this.fileNode = statusNode.getFileNode();
        }

        @Override
        public String getValue() {
            return this.fileNode.getName();
        }
    }

    public static class PathProperty
    extends NodeProperty<String> {
        private String shortPath;
        public static final String NAME = "path";
        public static final String DISPLAY_NAME = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_Path.DisplayName");
        public static final String DESCRIPTION = NbBundle.getMessage(VCSStatusNode.class, (String)"LBL_Path.Description");

        public PathProperty(VCSStatusNode statusNode) {
            super(NAME, String.class, DISPLAY_NAME, DESCRIPTION);
            this.shortPath = ((VCSFileNode)statusNode.getFileNode()).getRelativePath();
            this.setValue("sortkey", this.shortPath + "\t" + statusNode.getName());
        }

        @Override
        public String getValue() {
            return this.shortPath;
        }
    }

    protected static abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String name, Class<T> type, String displayName, String description) {
            super(name, type, displayName, description);
        }

        public String toString() {
            return this.getValue().toString();
        }

        public abstract T getValue();
    }
}

