/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSupport;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteFileObjectBase
extends FileObject
implements Serializable {
    protected final RemoteFileSystem fileSystem;
    protected final ExecutionEnvironment execEnv;
    protected final String remotePath;
    protected final File cache;
    private boolean valid;
    private CopyOnWriteArrayList<FileChangeListener> listeners = new CopyOnWriteArrayList();
    private final FileLock lock = new FileLock();
    static final long serialVersionUID = 1931650016889811086L;

    public RemoteFileObjectBase(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, FileObject parent, String remotePath, File cache) {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.fileSystem = fileSystem;
        this.execEnv = execEnv;
        this.remotePath = remotePath;
        this.cache = cache;
        this.valid = true;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public String getPath() {
        return this.remotePath;
    }

    public void addFileChangeListener(FileChangeListener fcl) {
        this.listeners.add(fcl);
    }

    public void removeFileChangeListener(FileChangeListener fcl) {
        this.listeners.remove(fcl);
    }

    protected void fireDataCreated(FileObject fo) {
        for (FileChangeListener fcl : this.listeners) {
            fcl.fileDataCreated(new FileEvent((FileObject)this, fo));
        }
    }

    protected void fireFolderCreated(FileObject fo) {
        for (FileChangeListener fcl : this.listeners) {
            fcl.fileFolderCreated(new FileEvent((FileObject)this, fo));
        }
    }

    protected void fireDeleted(FileObject fo) {
        for (FileChangeListener fcl : this.listeners) {
            fcl.fileDeleted(new FileEvent((FileObject)this, fo));
        }
    }

    protected abstract void deleteImpl() throws IOException;

    protected abstract void postDeleteChild(FileObject var1);

    public void delete(FileLock lock) throws IOException {
        this.deleteImpl();
        this.invalidate();
        RemoteFileObjectBase parent = this.getParent();
        if (parent != null) {
            parent.postDeleteChild(this);
        }
    }

    public String getExt() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? "" : nameExt.substring(pointPos + 1);
    }

    public RemoteFileSystem getFileSystem() {
        return this.fileSystem;
    }

    protected RemoteFileSupport getRemoteFileSupport() {
        return this.fileSystem.getRemoteFileSupport();
    }

    public String getName() {
        String nameExt = this.getNameExt();
        int pointPos = nameExt.lastIndexOf(46);
        return pointPos < 0 ? nameExt : nameExt.substring(0, pointPos);
    }

    public String getNameExt() {
        int slashPos = this.remotePath.lastIndexOf(47);
        return slashPos < 0 ? "" : this.remotePath.substring(slashPos + 1);
    }

    public OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new ReadOnlyException();
    }

    public abstract RemoteFileObjectBase getFileObject(String var1);

    public abstract RemoteFileObjectBase getFileObject(String var1, String var2);

    public abstract RemoteFileObjectBase[] getChildren();

    public RemoteFileObjectBase getParent() {
        int slashPos = this.remotePath.lastIndexOf(47);
        if (slashPos > 0) {
            String parentPath = this.remotePath.substring(0, slashPos);
            RemoteFileObjectBase parent = this.fileSystem.findResource(parentPath);
            RemoteLogger.assertTrue(parent != null, "Null parent for " + this.remotePath);
            return parent;
        }
        return this.fileSystem.getRoot();
    }

    public long getSize() {
        RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
        if (parent != null) {
            return parent.getSize(this);
        }
        return 0L;
    }

    @Deprecated
    public boolean isReadOnly() {
        return true;
    }

    public boolean canRead() {
        try {
            RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (parent == null) {
                return true;
            }
            return parent.canRead(this.getNameExt());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    public boolean canWrite() {
        try {
            RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
            if (parent == null) {
                return false;
            }
            return parent.canWrite(this.getNameExt());
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return true;
        }
    }

    public boolean isRoot() {
        return false;
    }

    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    public boolean isVirtual() {
        return false;
    }

    public Date lastModified() {
        RemoteDirectory parent = RemoteFileSystemUtils.getCanonicalParent(this);
        if (parent != null) {
            return parent.lastModified(this);
        }
        return new Date(0L);
    }

    public FileLock lock() throws IOException {
        return this.lock;
    }

    public void rename(FileLock lock, String name, String ext) throws IOException {
        throw new ReadOnlyException();
    }

    public Object getAttribute(String attrName) {
        return this.fileSystem.getAttribute(this, attrName);
    }

    public Enumeration<String> getAttributes() {
        return this.fileSystem.getAttributes(this);
    }

    public void setAttribute(String attrName, Object value) throws IOException {
        this.fileSystem.setAttribute(this, attrName, value);
    }

    @Deprecated
    public void setImportant(boolean b) {
    }

    protected abstract void ensureSync() throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException;

    public abstract FileType getType();

    public String toString() {
        return this.execEnv.toString() + ":" + this.remotePath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFileObjectBase other = (RemoteFileObjectBase)obj;
        if (!(this.fileSystem == other.fileSystem || this.fileSystem != null && ((Object)((Object)this.fileSystem)).equals((Object)other.fileSystem))) {
            return false;
        }
        if (!(this.execEnv == other.execEnv || this.execEnv != null && this.execEnv.equals(other.execEnv))) {
            return false;
        }
        return this.cache == other.cache || this.cache != null && this.cache.equals(other.cache);
    }

    public int hashCode() {
        int hash = 3;
        hash = 11 * hash + (this.fileSystem != null ? ((Object)((Object)this.fileSystem)).hashCode() : 0);
        hash = 11 * hash + (this.execEnv != null ? this.execEnv.hashCode() : 0);
        hash = 11 * hash + (this.cache != null ? this.cache.hashCode() : 0);
        return hash;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.execEnv, this.remotePath);
    }

    private static class SerializedForm
    implements Serializable {
        private final ExecutionEnvironment env;
        private final String remotePath;

        public SerializedForm(ExecutionEnvironment env, String remotePath) {
            this.env = env;
            this.remotePath = remotePath;
        }

        Object readResolve() throws ObjectStreamException {
            RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.env);
            RemoteFileObjectBase fo = fs.findResource(this.remotePath);
            if (fo == null) {
                fo = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)this.remotePath);
            }
            return fo;
        }
    }

    private static class ReadOnlyException
    extends IOException {
        public ReadOnlyException() {
            super("The remote file system is read-only");
        }
    }
}

