/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.ConnectException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.impl.fs.CachedRemoteInputStream;
import org.netbeans.modules.remote.impl.fs.DirectoryReader;
import org.netbeans.modules.remote.impl.fs.DirectoryStorage;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemUtils;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RemoteDirectory
extends RemoteFileObjectBase {
    public static final String FLAG_FILE_NAME = ".rfs";
    private static final boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
    private Reference<DirectoryStorage> storageRef;
    private final Object refLock = new RefLock();
    private static boolean wrongDateFormatReported = false;

    public RemoteDirectory(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, FileObject parent, String remotePath, File cache) {
        super(fileSystem, execEnv, parent, remotePath, cache);
    }

    public boolean isFolder() {
        return true;
    }

    public boolean isData() {
        return false;
    }

    public RemoteFileObjectBase getFileObject(String name, String ext) {
        return this.getFileObject(name + '.' + ext);
    }

    boolean canWrite(String childNameExt) throws IOException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(true);
            DirectoryStorage.Entry entry = storage.getEntry(childNameExt);
            return entry != null && entry.canWrite(this.execEnv.getUser(), new String[0]);
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (CancellationException ex) {
            return false;
        }
    }

    boolean canRead(String childNameExt) throws IOException {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(true);
            DirectoryStorage.Entry entry = storage.getEntry(childNameExt);
            return entry != null && entry.canRead(this.execEnv.getUser(), new String[0]);
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return false;
        }
        catch (CancellationException ex) {
            return false;
        }
    }

    public FileObject createData(String name) throws IOException {
        return this.create(name, false);
    }

    public FileObject createData(String name, String ext) throws IOException {
        if (ext == null || ext.length() == 0) {
            return this.create(name, false);
        }
        return this.create(name + '.' + ext, false);
    }

    public FileObject createFolder(String name) throws IOException {
        return this.create(name, true);
    }

    protected void postDeleteChild(FileObject child) {
        try {
            DirectoryStorage ds = this.getDirectoryStorage(false);
            ds.removeEntry(child.getNameExt());
            ds.store();
            this.fireDeleted(child);
        }
        catch (ConnectException ex) {
            RemoteLogger.getInstance().log(Level.INFO, "Error post removing child " + child, ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    protected void deleteImpl() throws IOException {
        RemoteFileSystemUtils.delete(this.execEnv, this.remotePath, true);
    }

    private FileObject create(String name, boolean directory) throws IOException {
        ProcessUtils.ExitStatus res;
        String path = this.remotePath + '/' + name;
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            throw new ConnectException("Can not create " + this.getUrlToReport(path) + ": connection required");
        }
        if (directory) {
            res = ProcessUtils.execute((ExecutionEnvironment)this.execEnv, (String)"mkdir", (String[])new String[]{path});
        } else {
            String script = String.format("ls \"%s\" || touch \"%s\"", name, name);
            res = ProcessUtils.executeInDir((String)this.remotePath, (ExecutionEnvironment)this.execEnv, (String)"sh", (String[])new String[]{"-c", script});
            if (res.isOK() && res.error.length() == 0) {
                throw new IOException("Already exists: " + this.getUrlToReport(path));
            }
        }
        if (res.isOK()) {
            try {
                this.refreshImpl(false);
                this.ensureSync();
                RemoteFileObjectBase fo = this.getFileObject(name);
                if (fo == null) {
                    throw new FileNotFoundException("Can not create FileObject " + this.getUrlToReport(path));
                }
                if (directory) {
                    this.fireFolderCreated(fo);
                } else {
                    this.fireDataCreated(fo);
                }
                return fo;
            }
            catch (ConnectException ex) {
                throw new IOException("Can not create " + path + ": not connected", ex);
            }
            catch (InterruptedIOException ex) {
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (InterruptedException ex) {
                throw new IOException("Can not create " + path + ": interrupted", ex);
            }
            catch (CancellationException ex) {
                throw new IOException("Can not create " + path + ": cancelled", ex);
            }
        }
        throw new IOException("Can not create " + this.getUrlToReport(path) + ": " + res.error);
    }

    private String getUrlToReport(String path) {
        return this.execEnv.getDisplayName() + ':' + path;
    }

    private String removeDoubleSlashes(String path) {
        if (path == null) {
            return null;
        }
        return path.replace("//", "/");
    }

    public RemoteFileObjectBase getFileObject(String relativePath) {
        int slashPos;
        if ((relativePath = this.removeDoubleSlashes(relativePath)) != null && relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        if (relativePath.endsWith("/")) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if ((slashPos = relativePath.lastIndexOf(47)) > 0) {
            String parentRemotePath = this.remotePath + '/' + relativePath.substring(0, slashPos);
            String childNameExt = relativePath.substring(slashPos + 1);
            RemoteFileObjectBase parentFileObject = this.fileSystem.findResource(parentRemotePath);
            if (parentFileObject != null && parentFileObject.isFolder()) {
                return parentFileObject.getFileObject(childNameExt);
            }
            return null;
        }
        if (".".equals(relativePath)) {
            return this;
        }
        if ("..".equals(relativePath)) {
            RemoteFileObjectBase parent = this.getParent();
            return parent == null ? this : parent;
        }
        RemoteLogger.assertTrue(slashPos == -1);
        try {
            DirectoryStorage storage = this.getDirectoryStorage(true);
            DirectoryStorage.Entry entry = storage.getEntry(relativePath);
            if (entry == null) {
                return null;
            }
            File childCache = new File(this.cache, entry.getCache());
            String remoteAbsPath = this.remotePath + '/' + relativePath;
            if (entry.getFileType() == FileType.Directory) {
                return this.fileSystem.getFactory().createRemoteDirectory(this, remoteAbsPath, childCache);
            }
            if (entry.getFileType() == FileType.Symlink) {
                return this.fileSystem.getFactory().createRemoteLink(this, remoteAbsPath, entry.getLink());
            }
            return this.fileSystem.getFactory().createRemotePlainFile(this, remoteAbsPath, childCache, entry.getFileType());
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex);
            return null;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public RemoteFileObjectBase[] getChildren() {
        try {
            DirectoryStorage storage = this.getDirectoryStorage(true);
            List<DirectoryStorage.Entry> entries = storage.list();
            RemoteFileObjectBase[] childrenFO = new RemoteFileObjectBase[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                DirectoryStorage.Entry entry = entries.get(i);
                String childPath = this.remotePath + '/' + entry.getName();
                File childCache = new File(this.cache, entry.getCache());
                childrenFO[i] = entry.getFileType() == FileType.Directory ? this.fileSystem.getFactory().createRemoteDirectory(this, childPath, childCache) : (entry.getFileType() == FileType.Symlink ? this.fileSystem.getFactory().createRemoteLink(this, childPath, entry.getLink()) : this.fileSystem.getFactory().createRemotePlainFile(this, childPath, childCache, entry.getFileType()));
            }
            return childrenFO;
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (FileNotFoundException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
        }
        return new RemoteFileObjectBase[0];
    }

    protected void ensureSync() throws ConnectException, IOException, InterruptedException, CancellationException {
        this.getDirectoryStorage(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryStorage getDirectoryStorage(boolean sync) throws ConnectException, IOException, InterruptedException, CancellationException {
        DirectoryStorage directoryStorage;
        block3: {
            long time = System.currentTimeMillis();
            try {
                directoryStorage = this.getDirectoryStorageImpl(sync);
                if (!trace) break block3;
            }
            catch (Throwable throwable) {
                if (trace) {
                    this.trace("sync took {0} ms", System.currentTimeMillis() - time);
                }
                throw throwable;
            }
            this.trace("sync took {0} ms", System.currentTimeMillis() - time);
        }
        return directoryStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private DirectoryStorage getDirectoryStorageImpl(boolean sync) throws ConnectException, IOException, InterruptedException, CancellationException {
        Iterator<Object> i$;
        HashSet<DirectoryStorage.Entry> keepCacheNames;
        boolean changed;
        HashMap<String, DirectoryStorage.Entry> entries;
        boolean hasDups;
        HashMap<String, List<DirectoryStorage.Entry>> dupLowerNames;
        File storageFile;
        DirectoryStorage storage;
        block67: {
            Object e4;
            boolean loaded;
            storage = null;
            storageFile = new File(this.cache, FLAG_FILE_NAME);
            Object object = this.refLock;
            // MONITORENTER : object
            if (this.storageRef != null) {
                storage = this.storageRef.get();
            }
            // MONITOREXIT : object
            if (storage != null) {
                if (storageFile.lastModified() >= this.fileSystem.getDirtyTimestamp()) {
                    this.trace("timestamps check passed; returning cached storage", new Object[0]);
                    return storage;
                }
                if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    this.trace("timestamps check NOT passed, but the host is offline; returning cached storage", new Object[0]);
                    this.fileSystem.getRemoteFileSupport().addPendingFile(this);
                    return storage;
                }
                if (!sync) {
                    this.trace("timestamps check NOT passed, but no sync is required; returning cached storage", new Object[0]);
                    this.fileSystem.getRemoteFileSupport().addPendingFile(this);
                    return storage;
                }
            }
            if (trace && storageFile.lastModified() < this.fileSystem.getDirtyTimestamp()) {
                this.trace("dirty directory: file={0} fs={1}", storageFile.lastModified(), this.fileSystem.getDirtyTimestamp());
            }
            if (storage == null) {
                loaded = false;
                storage = new DirectoryStorage(storageFile);
                if (storageFile.exists()) {
                    Lock lock = RemoteFileSystem.getLock(this.cache).readLock();
                    try {
                        lock.lock();
                        try {
                            storage.load();
                            loaded = true;
                        }
                        catch (DirectoryStorage.FormatException e2) {
                            Level level = e2.isExpexted() ? Level.FINE : Level.WARNING;
                            RemoteLogger.getInstance().log(level, "Error reading directory cache", e2);
                            storageFile.delete();
                        }
                        catch (InterruptedIOException e3) {
                            throw e3;
                        }
                        catch (IOException e4) {
                            Exceptions.printStackTrace((Throwable)e4);
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
            } else {
                loaded = true;
            }
            if (loaded) {
                boolean ok = false;
                if (storageFile.lastModified() >= this.fileSystem.getDirtyTimestamp()) {
                    this.trace("timestamps check passed; returning just loaded storage", new Object[0]);
                    ok = true;
                } else if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
                    this.trace("timestamps check NOT passed, but the host is offline; returning just loaded storage", new Object[0]);
                    ok = true;
                    this.fileSystem.getRemoteFileSupport().addPendingFile(this);
                } else if (!sync) {
                    this.trace("timestamps check NOT passed, but no sync is required; returning just loaded storage", new Object[0]);
                    ok = true;
                    this.fileSystem.getRemoteFileSupport().addPendingFile(this);
                }
                if (ok) {
                    DirectoryStorage s;
                    e4 = this.refLock;
                    // MONITORENTER : e4
                    if (this.storageRef != null && (s = this.storageRef.get()) != null) {
                        if (trace) {
                            this.trace("returning storage that was loaded by other thread", new Object[0]);
                        }
                        // MONITOREXIT : e4
                        return s;
                    }
                    this.storageRef = new SoftReference<DirectoryStorage>(storage);
                    // MONITOREXIT : e4
                    if (!trace) return storage;
                    this.trace("returning just loaded storage", new Object[0]);
                    return storage;
                }
            }
            this.checkConnection(this, true);
            Lock lock = RemoteFileSystem.getLock(this.cache).writeLock();
            if (trace) {
                this.trace("waiting for lock", new Object[0]);
            }
            lock.lock();
            e4 = this.refLock;
            // MONITORENTER : e4
            if (trace) {
                this.trace("checking storageRef and timestamp: ref={0} file={1} fs: {2}", this.storageRef, storageFile.lastModified(), this.fileSystem.getDirtyTimestamp());
            }
            if (this.storageRef != null && storageFile.lastModified() >= this.fileSystem.getDirtyTimestamp()) {
                DirectoryStorage stor = this.storageRef.get();
                if (trace) {
                    this.trace("got storage: {0} -> {1}", this.storageRef, stor);
                }
                if (stor != null) {
                    DirectoryStorage directoryStorage = stor;
                    // MONITOREXIT : e4
                    return directoryStorage;
                }
            }
            // MONITOREXIT : e4
            if (!this.cache.exists()) {
                this.cache.mkdirs();
            }
            if (!this.cache.exists()) {
                throw new IOException("Can not create cache directory " + this.cache);
            }
            DirectoryReader directoryReader = new DirectoryReader(this.execEnv, this.remotePath);
            if (trace) {
                this.trace("synchronizing", new Object[0]);
            }
            try {
                directoryReader.readDirectory();
            }
            catch (FileNotFoundException ex) {
                throw ex;
            }
            catch (IOException ex) {
                if (ConnectionManager.getInstance().isConnectedTo(this.execEnv)) throw new ConnectException(ex.getMessage());
                this.fileSystem.getRemoteFileSupport().addPendingFile(this);
                if (!loaded) throw new ConnectException(ex.getMessage());
                if (storage == null) throw new ConnectException(ex.getMessage());
                DirectoryStorage directoryStorage = storage;
                lock.unlock();
                return directoryStorage;
            }
            this.fileSystem.incrementDirSyncCount();
            dupLowerNames = new HashMap<String, List<DirectoryStorage.Entry>>();
            hasDups = false;
            entries = new HashMap<String, DirectoryStorage.Entry>();
            for (DirectoryStorage.Entry entry : directoryReader.getEntries()) {
                entries.put(entry.getName(), entry);
            }
            changed = false;
            keepCacheNames = new HashSet<DirectoryStorage.Entry>();
            i$ = entries.values().iterator();
            break block67;
            finally {
                lock.unlock();
            }
        }
        while (i$.hasNext()) {
            String cacheName;
            DirectoryStorage.Entry entry;
            block69: {
                DirectoryStorage.Entry oldEntry;
                block70: {
                    block74: {
                        block73: {
                            block72: {
                                block71: {
                                    block68: {
                                        entry = (DirectoryStorage.Entry)i$.next();
                                        oldEntry = storage.getEntry(entry.getName());
                                        if (oldEntry != null) break block68;
                                        changed = true;
                                        cacheName = RemoteFileSystemUtils.escapeFileName(entry.getName());
                                        break block69;
                                    }
                                    if (oldEntry.getFileType() != entry.getFileType()) break block70;
                                    cacheName = oldEntry.getCache();
                                    keepCacheNames.add(entry);
                                    if (entry.getTimestamp().equals(oldEntry.getTimestamp())) break block69;
                                    if (entry.getFileType() != FileType.File) break block71;
                                    changed = true;
                                    File entryCache = new File(this.cache, oldEntry.getCache());
                                    if (entryCache.exists()) {
                                        if (trace) {
                                            this.trace("removing cache for updated file {0}", entryCache.getAbsolutePath());
                                        }
                                        entryCache.delete();
                                    }
                                    break block69;
                                }
                                if (RemoteDirectory.equals(entry.getLink(), oldEntry.getLink())) break block72;
                                changed = true;
                                this.fileSystem.getFactory().setLink(this, this.remotePath + '/' + entry.getName(), entry.getLink());
                                break block69;
                            }
                            if (entry.getAccessAsString().equals(oldEntry.getAccessAsString())) break block73;
                            changed = true;
                            break block69;
                        }
                        if (entry.getUser().equals(oldEntry.getUser())) break block74;
                        changed = true;
                        break block69;
                    }
                    if (!entry.getGroup().equals(oldEntry.getGroup())) {
                        changed = true;
                        break block69;
                    } else if (entry.getSize() != oldEntry.getSize()) {
                        changed = true;
                    }
                    break block69;
                }
                changed = true;
                this.invalidate(oldEntry);
                cacheName = RemoteFileSystemUtils.escapeFileName(entry.getName());
            }
            entry.setCache(cacheName);
            if (RemoteFileSystemUtils.isSystemCaseSensitive()) continue;
            String lowerCacheName = entry.getCache().toLowerCase();
            ArrayList<DirectoryStorage.Entry> dupEntries = (ArrayList<DirectoryStorage.Entry>)dupLowerNames.get(lowerCacheName);
            if (dupEntries == null) {
                dupEntries = new ArrayList<DirectoryStorage.Entry>();
                dupLowerNames.put(lowerCacheName, dupEntries);
            } else {
                hasDups = true;
            }
            dupEntries.add(entry);
        }
        if (changed || entries.size() != storage.size()) {
            for (DirectoryStorage.Entry entry : storage.list()) {
                if (entries.containsKey(entry.getName())) continue;
                changed = true;
                this.invalidate(entry);
            }
        }
        if (changed) {
            if (hasDups) {
                for (Map.Entry entry : new ArrayList(dupLowerNames.entrySet())) {
                    List dupEntries = (List)entry.getValue();
                    if (dupEntries.size() <= 1) continue;
                    block28: for (int i = 0; i < dupEntries.size(); ++i) {
                        DirectoryStorage.Entry entry2 = (DirectoryStorage.Entry)dupEntries.get(i);
                        if (keepCacheNames.contains(entry2) || i == 0) continue;
                        for (int j = 0; j < Integer.MAX_VALUE; ++j) {
                            String cacheName = (String)entry.getKey() + '_' + j;
                            String lowerCacheName = cacheName.toLowerCase();
                            if (dupLowerNames.containsKey(lowerCacheName)) continue;
                            if (trace) {
                                this.trace("resolving cache names conflict in {0}: {1} -> {2}", this.cache.getAbsolutePath(), entry2.getCache(), cacheName);
                            }
                            entry2.setCache(cacheName);
                            dupLowerNames.put(lowerCacheName, Collections.singletonList(entry2));
                            continue block28;
                        }
                    }
                }
            }
            storage.setEntries(entries.values());
            storage.store();
        }
        Object object = this.refLock;
        // MONITORENTER : object
        this.storageRef = new SoftReference<DirectoryStorage>(storage);
        // MONITOREXIT : object
        storageFile.setLastModified(System.currentTimeMillis());
        if (!trace) return storage;
        this.trace("set lastModified to {0}", storageFile.lastModified());
        return storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InputStream _getInputStream(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        Lock lock = RemoteFileSystem.getLock(child.cache).readLock();
        lock.lock();
        try {
            if (child.cache.exists()) {
                FileInputStream fileInputStream = new FileInputStream(child.cache);
                return fileInputStream;
            }
        }
        finally {
            lock.unlock();
        }
        this.checkConnection(child, true);
        DirectoryStorage storage = this.getDirectoryStorage(true);
        return new CachedRemoteInputStream(child, this.execEnv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureChildSync(RemotePlainFile child) throws ConnectException, IOException, InterruptedException, CancellationException, ExecutionException {
        block14: {
            Lock lock = RemoteFileSystem.getLock(child.cache).readLock();
            lock.lock();
            try {
                if (child.cache.exists()) {
                    return;
                }
            }
            finally {
                lock.unlock();
            }
            this.checkConnection(child, true);
            DirectoryStorage storage = this.getDirectoryStorage(true);
            lock = RemoteFileSystem.getLock(child.cache).writeLock();
            lock.lock();
            try {
                if (child.cache.exists()) {
                    return;
                }
                Future task = CommonTasksSupport.downloadFile((String)child.remotePath, (ExecutionEnvironment)this.execEnv, (String)child.cache.getAbsolutePath(), null);
                int rc = (Integer)task.get();
                if (rc == 0) {
                    this.fileSystem.incrementFileCopyCount();
                    break block14;
                }
                throw new IOException("Can't copy file " + child.cache.getAbsolutePath() + " from " + this.execEnv + ':' + this.remotePath + ": rc=" + rc);
            }
            catch (InterruptedException ex) {
                child.cache.delete();
                throw ex;
            }
            catch (ExecutionException ex) {
                child.cache.delete();
                throw ex;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void checkConnection(RemoteFileObjectBase fo, boolean throwConnectException) throws ConnectException {
        if (!ConnectionManager.getInstance().isConnectedTo(this.execEnv)) {
            this.fileSystem.getRemoteFileSupport().addPendingFile(fo);
            if (throwConnectException) {
                throw new ConnectException();
            }
        }
    }

    public FileType getType() {
        return FileType.Directory;
    }

    public final InputStream getInputStream() throws FileNotFoundException {
        throw new FileNotFoundException(this.getPath());
    }

    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        throw new IOException(this.getPath());
    }

    private void invalidate(DirectoryStorage.Entry oldEntry) {
        this.fileSystem.getFactory().invalidate(this.remotePath + '/' + oldEntry.getName());
        File oldEntryCache = new File(this.cache, oldEntry.getCache());
        this.removeFile(oldEntryCache);
    }

    private void removeFile(File cache) {
        if (cache.isDirectory()) {
            for (File child : cache.listFiles()) {
                this.removeFile(child);
            }
        }
        cache.delete();
    }

    private static void setStorageTimestamp(File cache, final long timestamp, boolean recursive) {
        cache.setLastModified(timestamp);
        if (recursive && cache.exists()) {
            cache.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    if (pathname.isDirectory()) {
                        File childCache = new File(pathname, RemoteDirectory.FLAG_FILE_NAME);
                        RemoteDirectory.setStorageTimestamp(childCache, timestamp, true);
                    }
                    return false;
                }
            });
        }
    }

    protected void refreshImpl(boolean recursive) {
        long timestamp = this.fileSystem.getDirtyTimestamp() - 1L;
        this.trace("setting last modified to {0}", timestamp);
        RemoteDirectory.setStorageTimestamp(new File(this.cache, FLAG_FILE_NAME), timestamp, true);
    }

    public void refresh(boolean expected) {
        this.refreshImpl(true);
    }

    public void refresh() {
        this.refreshImpl(true);
    }

    private void trace(String message, Object ... args) {
        if (trace) {
            message = "SYNC [" + this.remotePath + "][" + System.identityHashCode(this) + "][" + Thread.currentThread().getId() + "]: " + message;
            RemoteLogger.getInstance().log(Level.FINEST, message, args);
        }
    }

    private static boolean equals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    private DirectoryStorage.Entry getChildEntry(RemoteFileObjectBase child) {
        try {
            DirectoryStorage directoryStorage = this.getDirectoryStorage(false);
            if (directoryStorage != null) {
                DirectoryStorage.Entry entry = directoryStorage.getEntry(child.getNameExt());
                if (entry != null) {
                    return entry;
                }
                RemoteLogger.getInstance().log(Level.INFO, "Not found entry for file {0}", child);
            }
        }
        catch (ConnectException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (CancellationException ex) {
            RemoteLogger.finest(ex);
        }
        return null;
    }

    long getSize(RemoteFileObjectBase child) {
        DirectoryStorage.Entry childEntry = this.getChildEntry(child);
        if (childEntry != null) {
            return childEntry.getSize();
        }
        return 0L;
    }

    Date lastModified(RemoteFileObjectBase child) {
        block4: {
            DirectoryStorage.Entry childEntry = this.getChildEntry(child);
            if (childEntry != null) {
                String timestamp = childEntry.getTimestamp();
                try {
                    Date date;
                    if (timestamp != null && (date = DirectoryReader.getDate(timestamp)) != null) {
                        return date;
                    }
                }
                catch (ParseException ex) {
                    if (wrongDateFormatReported) break block4;
                    wrongDateFormatReported = true;
                    RemoteLogger.getInstance().log(Level.INFO, "Error parsing date string for " + child.remotePath + ": " + timestamp, ex);
                }
            }
        }
        return new Date(0L);
    }

    private static final class RefLock {
        private RefLock() {
        }
    }
}

