/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.support.RemoteLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryStorage {
    private final Map<String, Entry> entries = new HashMap<String, Entry>();
    private final File file;
    private static final int VERSION = 2;
    private static final int ODD_VERSION = 1;

    public DirectoryStorage(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException, FormatException {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            BufferedReader br = null;
            try {
                int version;
                br = new BufferedReader(new FileReader(this.file));
                String line = br.readLine();
                String prefix = "VERSION=";
                if (line == null || !line.startsWith(prefix)) {
                    throw this.wrongFormatException(line);
                }
                try {
                    version = Integer.parseInt(line.substring(prefix.length()));
                }
                catch (NumberFormatException nfe) {
                    throw new FormatException("wrong version format " + this.file.getAbsolutePath(), nfe);
                }
                if (version > 2) {
                    throw new FormatException("attributes file version " + version + " not supported: " + this.file.getAbsolutePath(), false);
                }
                if (version < 1) {
                    throw new FormatException("Discarding old attributes file version " + version + ' ' + this.file.getAbsolutePath(), true);
                }
                while ((line = br.readLine()) != null) {
                    if (line.length() == 0) continue;
                    Entry entry = this.parseLine(line);
                    this.entries.put(entry.name, entry);
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
            }
        }
    }

    private String escape(String text) {
        if (text.indexOf(32) < 0 && text.indexOf(92) < 0) {
            return text;
        }
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    result.append("\\ ");
                    continue block4;
                }
                case '\\': {
                    result.append("\\\\");
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    private Entry parseLine(String line) throws FormatException {
        long sz;
        String[] params = new String[8];
        int name = 0;
        int cache = 1;
        int access = 2;
        int user = 3;
        int group = 4;
        int size = 5;
        int timestamp = 6;
        int link = 7;
        StringBuilder currText = new StringBuilder();
        int currIndex = name;
        boolean escape = false;
        block7: for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            switch (c) {
                case '\\': {
                    if (!(currIndex != name && currIndex != cache || escape)) {
                        escape = true;
                        continue block7;
                    }
                    currText.append(c);
                    escape = false;
                    continue block7;
                }
                case ' ': {
                    if (currIndex == timestamp || escape) {
                        currText.append(c);
                    } else {
                        params[currIndex] = currText.toString();
                        currText = new StringBuilder();
                        ++currIndex;
                    }
                    escape = false;
                    continue block7;
                }
                case '\"': {
                    if (currIndex == timestamp) {
                        if (currText.length() != 0) {
                            params[timestamp] = currText.toString();
                            String t = line.substring(i + 1).trim();
                            params[link] = t.length() == 0 ? null : t;
                            break block7;
                        }
                    } else if (currIndex + 1 == timestamp) {
                        currIndex = timestamp;
                    } else {
                        currText.append(c);
                    }
                    escape = false;
                    continue block7;
                }
                default: {
                    currText.append(c);
                    escape = false;
                }
            }
        }
        if (currIndex < link - 1) {
            throw this.wrongFormatException(line);
        }
        try {
            sz = Long.parseLong(params[size]);
        }
        catch (NumberFormatException ex) {
            throw this.wrongFormatException(line);
        }
        return new Entry(params[name], params[cache], params[access], params[user], params[group], sz, params[timestamp], params[link]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() throws IOException {
        BufferedWriter wr = null;
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            try {
                wr = new BufferedWriter(new FileWriter(this.file));
                wr.write("VERSION=2\n");
                for (Entry entry : this.entries.values()) {
                    wr.write(this.escape(entry.name));
                    wr.write(32);
                    wr.write(this.escape(entry.cache));
                    wr.write(32);
                    wr.write(entry.type);
                    wr.write(entry.getAccessAsString());
                    wr.write(32);
                    wr.write(entry.user);
                    wr.write(32);
                    wr.write(entry.group);
                    wr.write(32);
                    wr.write(Long.toString(entry.size));
                    wr.write(32);
                    wr.write(34);
                    wr.write(entry.timestamp);
                    wr.write(34);
                    if (entry.link != null && entry.link.length() > 0) {
                        wr.write(32);
                        wr.write(entry.link);
                    }
                    wr.write(10);
                }
                wr.close();
                wr = null;
            }
            finally {
                if (wr != null) {
                    wr.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry getEntry(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.get(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry removeEntry(String fileName) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.remove(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEntries(Collection<Entry> newEntries) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            this.entries.clear();
            for (Entry entry : newEntries) {
                this.entries.put(entry.name, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entry> list() {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return new ArrayList<Entry>(this.entries.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void testAddEntry(Entry entry) {
        DirectoryStorage directoryStorage = this;
        synchronized (directoryStorage) {
            this.entries.put(entry.name, entry);
        }
    }

    private FormatException wrongFormatException(String line) {
        return new FormatException("Wrong file format " + this.file.getAbsolutePath() + " line " + line, false);
    }

    public static class Entry {
        private static final short USR_R = 256;
        private static final short USR_W = 128;
        private static final short USR_X = 64;
        private static final short GRP_R = 32;
        private static final short GRP_W = 16;
        private static final short GRP_X = 8;
        private static final short ALL_R = 4;
        private static final short ALL_W = 2;
        private static final short ALL_X = 1;
        private final String name;
        private String cache;
        private char type;
        private short access;
        private final String user;
        private final String group;
        private final long size;
        private final String timestamp;
        private final String link;

        public Entry(String name, String cache, String access, String user, String group, long size, String timestamp, String link) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            boolean assertions = false;
            if (!$assertionsDisabled) {
                assertions = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            if (assertions) {
                char c;
                int i;
                String assertionText = "Wrong access format: " + access;
                RemoteLogger.assertTrue(access.length() >= 10, assertionText);
                block5: for (i = 1; i < 0; ++i) {
                    c = access.charAt(i);
                    switch (i % 3) {
                        case 1: {
                            RemoteLogger.assertTrue(c == 'r' || c == '-', assertionText);
                            continue block5;
                        }
                        case 2: {
                            RemoteLogger.assertTrue(c == 'w' || c == '-', assertionText);
                            continue block5;
                        }
                        case 0: {
                            RemoteLogger.assertTrue(c == 'x' || c == '-' || c == 's' || c == 'S' || c == 't' || c == 'T', assertionText);
                        }
                    }
                }
                for (i = 1; i < 9; i += 3) {
                    c = access.charAt(i);
                }
                RemoteLogger.assertTrue(FileType.fromChar(access.charAt(0)) != null, "Can't get file type from access string: " + access);
            }
            this.type = access.charAt(0);
            this.name = name;
            this.cache = cache;
            this.access = this.stringToAcces(access);
            this.user = user;
            this.group = group;
            this.size = size;
            this.timestamp = timestamp;
            this.link = link;
        }

        public FileType getFileType() {
            return FileType.fromChar(this.type);
        }

        public String getName() {
            return this.name;
        }

        public String getCache() {
            return this.cache;
        }

        public void setCache(String cache) {
            this.cache = cache;
        }

        public String getGroup() {
            return this.group;
        }

        public String getLink() {
            return this.link;
        }

        public long getSize() {
            return this.size;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getUser() {
            return this.user;
        }

        public boolean canRead(String user, String ... groups) {
            if ((this.access & 4) > 0) {
                return true;
            }
            if ((this.access & 0x100) > 0 && this.user.equals(user)) {
                return true;
            }
            if ((this.access & 0x20) > 0 && groups != null) {
                for (String g : groups) {
                    if (!this.group.equals(g)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canWrite(String user, String ... groups) {
            if ((this.access & 2) > 0) {
                return true;
            }
            if ((this.access & 0x80) > 0 && this.user.equals(user)) {
                return true;
            }
            if ((this.access & 0x10) > 0 && groups != null) {
                for (String g : groups) {
                    if (!this.group.equals(g)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canExecute(String user, String ... groups) {
            if ((this.access & 1) > 0) {
                return true;
            }
            if ((this.access & 0x40) > 0 && this.user.equals(user)) {
                return true;
            }
            if ((this.access & 8) > 0 && groups != null) {
                for (String g : groups) {
                    if (!this.group.equals(g)) continue;
                    return true;
                }
            }
            return false;
        }

        public String getAccessAsString() {
            char[] accessChars = new char[]{(this.access & 0x100) == 0 ? (char)'-' : 'r', (this.access & 0x80) == 0 ? (char)'-' : 'w', (this.access & 0x40) == 0 ? (char)'-' : 'x', (this.access & 0x20) == 0 ? (char)'-' : 'r', (this.access & 0x10) == 0 ? (char)'-' : 'w', (this.access & 8) == 0 ? (char)'-' : 'x', (this.access & 4) == 0 ? (char)'-' : 'r', (this.access & 2) == 0 ? (char)'-' : 'w', (this.access & 1) == 0 ? (char)'-' : 'x'};
            return new String(accessChars);
        }

        private short stringToAcces(String accessString) {
            short result = 0;
            result = (short)(result | (accessString.charAt(1) == 'r' ? 256 : 0));
            result = (short)(result | (accessString.charAt(2) == 'w' ? 128 : 0));
            result = (short)(result | (accessString.charAt(3) == 'x' ? 64 : 0));
            result = (short)(result | (accessString.charAt(4) == 'r' ? 32 : 0));
            result = (short)(result | (accessString.charAt(5) == 'w' ? 16 : 0));
            result = (short)(result | (accessString.charAt(6) == 'x' ? 8 : 0));
            result = (short)(result | (accessString.charAt(7) == 'r' ? 4 : 0));
            result = (short)(result | (accessString.charAt(8) == 'w' ? 2 : 0));
            result = (short)(result | (accessString.charAt(9) == 'x' ? 1 : 0));
            return result;
        }

        public String toString() {
            return this.name + ' ' + this.getAccessAsString() + ' ' + this.user + ' ' + this.group + ' ' + this.timestamp + ' ' + this.link;
        }
    }

    public static class FormatException
    extends Exception {
        private final boolean expexted;

        public FormatException(String text, boolean expected) {
            super(text);
            this.expexted = expected;
        }

        public FormatException(String string, Throwable thrwbl) {
            super(string, thrwbl);
            this.expexted = false;
        }

        public boolean isExpexted() {
            return this.expexted;
        }
    }
}

