/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.litemodel;

import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.litemodel.api.Declaration;

public class DwarfRenderer {
    private static final boolean TRACE = true;
    private boolean PROCESS_TOP_LEVEL_DECLARATIONS = true;
    private boolean LIMIT_TO_COMPILATION_UNIT = true;
    private Map<String, String> onePath = new HashMap<String, String>();
    private Set<Declaration> sourceInfoMap = new HashSet<Declaration>();
    private String filePath;
    private String compDir;
    private Set<Long> antiLoop;
    private int fileEntryIdx = 0;

    private DwarfRenderer() {
    }

    public static DwarfRenderer createFullRenderer() {
        DwarfRenderer dwarfRenderer = new DwarfRenderer();
        dwarfRenderer.PROCESS_TOP_LEVEL_DECLARATIONS = false;
        dwarfRenderer.LIMIT_TO_COMPILATION_UNIT = false;
        return dwarfRenderer;
    }

    public static DwarfRenderer createTopLevelDeclarationsRenderer() {
        DwarfRenderer dwarfRenderer = new DwarfRenderer();
        dwarfRenderer.PROCESS_TOP_LEVEL_DECLARATIONS = true;
        dwarfRenderer.LIMIT_TO_COMPILATION_UNIT = false;
        return dwarfRenderer;
    }

    public static DwarfRenderer createTopLevelDeclarationsCompilationUnitsRenderer() {
        DwarfRenderer dwarfRenderer = new DwarfRenderer();
        dwarfRenderer.PROCESS_TOP_LEVEL_DECLARATIONS = true;
        dwarfRenderer.LIMIT_TO_COMPILATION_UNIT = true;
        return dwarfRenderer;
    }

    public void dumpModel(PrintStream out) {
        Map<String, Map<String, Declaration>> res = this.getLWM();
        for (Map.Entry<String, Map<String, Declaration>> entry : res.entrySet()) {
            out.println(entry.getKey());
            for (Map.Entry<String, Declaration> e : entry.getValue().entrySet()) {
                if (e.getValue().getReferencedType() != null) {
                    out.println("\t" + e.getValue().getQName() + " (" + e.getValue().getKind() + ") " + e.getValue().getReferencedType() + " :" + e.getValue().getLine());
                    continue;
                }
                out.println("\t" + e.getValue().getQName() + " (" + e.getValue().getKind() + ") :" + e.getValue().getLine());
            }
        }
    }

    public Map<String, Map<String, Declaration>> getLWM() {
        TreeMap<String, Map<String, Declaration>> res = new TreeMap<String, Map<String, Declaration>>();
        for (Declaration d : this.sourceInfoMap) {
            TreeMap<String, Declaration> map = (TreeMap<String, Declaration>)res.get(d.getFileName());
            if (map == null) {
                map = new TreeMap<String, Declaration>();
                res.put(d.getFileName(), map);
            }
            map.put(d.getQName(), d);
        }
        return res;
    }

    public void process(CompilationUnit compilationUnit) throws IOException {
        this.filePath = compilationUnit.getSourceFileAbsolutePath();
        this.compDir = compilationUnit.getCompilationDir();
        this.antiLoop = new HashSet<Long>();
        if (this.PROCESS_TOP_LEVEL_DECLARATIONS) {
            this.processEntries(compilationUnit, compilationUnit.getTopLevelEntries(), null);
        } else {
            this.processEntries(compilationUnit, compilationUnit.getDeclarations(false), null);
        }
    }

    private void processEntries(CompilationUnit compilationUnit, List<DwarfEntry> declarations, MyDeclaration parent) throws IOException {
        if (this.LIMIT_TO_COMPILATION_UNIT) {
            this.fileEntryIdx = compilationUnit.getStatementList().getFileEntryIdx(compilationUnit.getSourceFileName());
        }
        for (DwarfEntry entry : declarations) {
            this.prosessEntry(compilationUnit, entry, parent);
        }
    }

    private void prosessEntry(CompilationUnit compilationUnit, DwarfEntry entry, MyDeclaration parent) throws IOException {
        if (this.antiLoop.contains(entry.getRefference())) {
            return;
        }
        this.antiLoop.add(entry.getRefference());
        switch (entry.getKind()) {
            case DW_TAG_variable: 
            case DW_TAG_member: 
            case DW_TAG_inlined_subroutine: 
            case DW_TAG_subprogram: 
            case DW_TAG_SUN_function_template: 
            case DW_TAG_enumerator: 
            case DW_TAG_SUN_dtor: {
                if (this.LIMIT_TO_COMPILATION_UNIT && !entry.isEntryDefinedInFile(this.fileEntryIdx)) break;
                MyDeclaration functionToLine = null;
                if (entry.getLine() >= 0 && entry.getDeclarationFilePath() != null) {
                    functionToLine = new MyDeclaration(this.filePath, this.compDir, entry, this.onePath);
                    if (functionToLine.getQName() != null) {
                        this.sourceInfoMap.add(functionToLine);
                    } else {
                        System.err.println("Entry has empty qname\n" + entry);
                    }
                } else if (parent != null && parent.getLine() >= 0 && parent.getFileName() != null) {
                    functionToLine = new MyDeclaration(entry, parent, this.onePath);
                    if (functionToLine.getQName() != null) {
                        this.sourceInfoMap.add(functionToLine);
                    } else {
                        System.err.println("Entry has empty qname\n" + entry);
                    }
                }
                if (functionToLine == null) break;
                switch (entry.getKind()) {
                    case DW_TAG_variable: 
                    case DW_TAG_member: 
                    case DW_TAG_inlined_subroutine: 
                    case DW_TAG_subprogram: 
                    case DW_TAG_SUN_function_template: {
                        DwarfEntry type = compilationUnit.getReferencedType(entry);
                        if (type == null) break;
                        functionToLine.setReferencedType(type, this.onePath);
                    }
                }
                break;
            }
            case DW_TAG_inheritance: {
                DwarfEntry inh = compilationUnit.getReferencedType(entry);
                if (inh == null || parent == null || parent.getLine() < 0 || parent.getFileName() == null) break;
                MyDeclaration functionToLine = new MyDeclaration(entry, parent, inh, this.onePath);
                if (functionToLine.getQName() != null) {
                    this.sourceInfoMap.add(functionToLine);
                    break;
                }
                System.err.println("Entry has empty qname\n" + inh);
                break;
            }
            case DW_TAG_friend: {
                DwarfEntry friend = compilationUnit.getReferencedFriend(entry);
                if (friend == null || parent == null || parent.getLine() < 0 || parent.getFileName() == null) break;
                MyDeclaration functionToLine = new MyDeclaration(entry, parent, friend, this.onePath);
                if (functionToLine.getQName() != null) {
                    this.sourceInfoMap.add(functionToLine);
                    break;
                }
                System.err.println("Entry has empty qname\n" + friend);
                break;
            }
            case DW_TAG_namespace: {
                if (this.LIMIT_TO_COMPILATION_UNIT && !entry.isEntryDefinedInFile(this.fileEntryIdx)) break;
                MyDeclaration aParent = null;
                if (entry.getLine() >= 0 && entry.getDeclarationFilePath() != null) {
                    aParent = new MyDeclaration(this.filePath, this.compDir, entry, this.onePath);
                    if (aParent.getQName() != null) {
                        this.sourceInfoMap.add(aParent);
                    } else {
                        System.err.println("Entry has empty qname\n" + entry);
                    }
                }
                this.processEntries(compilationUnit, entry.getChildren(), aParent);
                break;
            }
            case DW_TAG_SUN_class_template: 
            case DW_TAG_SUN_struct_template: 
            case DW_TAG_SUN_union_template: 
            case DW_TAG_class_type: 
            case DW_TAG_structure_type: 
            case DW_TAG_union_type: 
            case DW_TAG_enumeration_type: {
                if (this.LIMIT_TO_COMPILATION_UNIT && !entry.isEntryDefinedInFile(this.fileEntryIdx)) break;
                MyDeclaration aParent = null;
                if (entry.getLine() >= 0 && entry.getDeclarationFilePath() != null) {
                    aParent = new MyDeclaration(this.filePath, this.compDir, entry, this.onePath);
                    if (aParent.getQName() != null) {
                        this.sourceInfoMap.add(aParent);
                    } else {
                        System.err.println("Entry has empty qname\n" + entry);
                    }
                }
                this.processEntries(compilationUnit, entry.getChildren(), aParent);
                break;
            }
            case DW_TAG_typedef: 
            case DW_TAG_const_type: 
            case DW_TAG_pointer_type: 
            case DW_TAG_reference_type: 
            case DW_TAG_array_type: 
            case DW_TAG_ptr_to_member_type: {
                if (this.LIMIT_TO_COMPILATION_UNIT && !entry.isEntryDefinedInFile(this.fileEntryIdx)) break;
                MyDeclaration functionToLine = null;
                if (entry.getLine() >= 0 && entry.getDeclarationFilePath() != null) {
                    functionToLine = new MyDeclaration(this.filePath, this.compDir, entry, this.onePath);
                    if (functionToLine.getQName() != null) {
                        this.sourceInfoMap.add(functionToLine);
                    } else {
                        System.err.println("Entry has empty qname\n" + entry);
                    }
                }
                DwarfEntry type = compilationUnit.getReferencedType(entry);
                if (functionToLine == null || type == null) break;
                functionToLine.setReferencedType(type, this.onePath);
                this.prosessEntry(compilationUnit, type, null);
            }
        }
    }

    private static final class MyDeclaration
    implements Declaration {
        private final int baseLine;
        private final String filePath;
        private final Declaration.Kind kind;
        private final String qname;
        private String referencedType;

        public MyDeclaration(String filePath, String compDir, DwarfEntry entry, Map<String, String> onePath) throws IOException {
            this.kind = this.kind2kind(entry.getKind());
            this.baseLine = entry.getLine();
            this.qname = this.initName(entry, onePath);
            this.filePath = this.initPath(filePath, compDir, entry, onePath);
        }

        private Declaration.Kind kind2kind(TAG tag) {
            return Declaration.Kind.valueOf((String)tag.toString().substring(7));
        }

        private void setReferencedType(DwarfEntry entry, Map<String, String> onePath) throws IOException {
            this.referencedType = this.getString(entry.getType(), onePath);
        }

        public String getReferencedType() {
            return this.referencedType;
        }

        private String initName(DwarfEntry entry, Map<String, String> onePath) throws IOException {
            if (entry.getKind() == TAG.DW_TAG_subprogram) {
                return this.getString(entry.getQualifiedName() + entry.getParametersString(false), onePath);
            }
            return this.getString(entry.getQualifiedName(), onePath);
        }

        public MyDeclaration(DwarfEntry entry, MyDeclaration parent, Map<String, String> onePath) throws IOException {
            this.kind = this.kind2kind(entry.getKind());
            this.baseLine = parent.getLine();
            this.qname = this.initName(entry, onePath);
            this.filePath = parent.getFileName();
        }

        public MyDeclaration(DwarfEntry entry, MyDeclaration parent, DwarfEntry reference, Map<String, String> onePath) throws IOException {
            this.kind = this.kind2kind(entry.getKind());
            this.baseLine = parent.getLine();
            this.qname = this.initName(reference, onePath);
            this.filePath = parent.getFileName();
        }

        public String getFileName() {
            return this.filePath;
        }

        public int getLine() {
            return this.baseLine;
        }

        public Declaration.Kind getKind() {
            return this.kind;
        }

        public String getQName() {
            return this.qname;
        }

        private String normalizeFile(String path) {
            int i;
            path = path.replace("/./", "/");
            while ((i = path.indexOf("/../")) >= 0) {
                int prev = -1;
                for (int j = i - 1; j >= 0; --j) {
                    if (path.charAt(j) != '/') continue;
                    prev = j;
                    break;
                }
                if (prev == -1) break;
                path = path.substring(0, prev) + path.substring(i + 3);
            }
            return path;
        }

        private String initPath(String filePath, String compDir, DwarfEntry entry, Map<String, String> onePath) throws IOException {
            String res = this._initPath(filePath, compDir, entry);
            if ((res = res.replace('\\', '/')).indexOf("/../") >= 0 || res.indexOf("/./") >= 0) {
                res = this.normalizeFile(res);
            }
            return this.getString(res, onePath);
        }

        private String getString(String path, Map<String, String> onePath) {
            String cached = onePath.get(path);
            if (cached == null) {
                onePath.put(path, path);
                cached = path;
            }
            return cached;
        }

        private String _initPath(String filePath, String compDir, DwarfEntry entry) throws IOException {
            String entyFilePath = entry.getDeclarationFilePath();
            if (entyFilePath != null && filePath.endsWith(entyFilePath)) {
                return filePath;
            }
            if (entyFilePath != null && (entyFilePath.startsWith("/") || entyFilePath.length() > 2 && entyFilePath.charAt(1) == ':')) {
                return entyFilePath;
            }
            if (compDir.endsWith("/") || compDir.endsWith("\\")) {
                return compDir + entyFilePath;
            }
            return compDir + "/" + entyFilePath;
        }

        public String toString() {
            return this.qname + "(" + this.kind + ") " + this.filePath + "(" + this.baseLine + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof MyDeclaration) {
                MyDeclaration other = (MyDeclaration)obj;
                if (this.baseLine != other.baseLine) {
                    return false;
                }
                if (this.kind != other.kind) {
                    return false;
                }
                if (!this.filePath.equals(other.filePath)) {
                    return false;
                }
                return this.qname.equals(other.qname);
            }
            return false;
        }

        public int hashCode() {
            int hash = 5;
            hash = 83 * hash + this.baseLine;
            hash = 83 * hash + this.filePath.hashCode();
            hash = 83 * hash + this.kind.ordinal();
            hash = 83 * hash + this.qname.hashCode();
            return hash;
        }
    }
}

