/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Embeddable;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.MappedSuperclass;
import org.openide.filesystems.FileObject;

public class ModelUtils {
    public static Entity getEntity(EntityMappingsMetadata metadata, TypeElement clazz) {
        assert (metadata != null) : "Metadata is null";
        assert (clazz != null) : "TypeElement is null";
        Name clName = clazz.getQualifiedName();
        for (Entity entity : metadata.getRoot().getEntity()) {
            if (!clName.contentEquals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static Entity getEntity(EntityMappingsMetadata metadata, String qualifiedClassName) {
        for (Entity entity : metadata.getRoot().getEntity()) {
            if (!qualifiedClassName.equals(entity.getClass2())) continue;
            return entity;
        }
        return null;
    }

    public static Embeddable getEmbeddable(EntityMappingsMetadata metadata, TypeElement clazz) {
        for (Embeddable embeddable : metadata.getRoot().getEmbeddable()) {
            if (!clazz.getQualifiedName().contentEquals(embeddable.getClass2())) continue;
            return embeddable;
        }
        return null;
    }

    public static MappedSuperclass getMappedSuperclass(EntityMappingsMetadata metadata, TypeElement clazz) {
        for (MappedSuperclass mappedSuperclass : metadata.getRoot().getMappedSuperclass()) {
            if (!clazz.getQualifiedName().contentEquals(mappedSuperclass.getClass2())) continue;
            return mappedSuperclass;
        }
        return null;
    }

    public static TypeElement getTypeElementFromModel(CompilationInfo info, Object modelElement) {
        String className = null;
        if (modelElement instanceof Entity) {
            className = ((Entity)modelElement).getClass2();
        }
        if (className != null) {
            return info.getElements().getTypeElement(className);
        }
        return null;
    }

    public static void resolveJavaElementFromModel(JPAProblemContext problemCtx, AttributeWrapper attr) {
        String attrName = attr.getName();
        attr.setInstanceVariable(ModelUtils.getField(problemCtx.getJavaClass(), attrName));
        attr.setAccesor(ModelUtils.getAccesor(problemCtx.getJavaClass(), attrName));
        if (attr.getInstanceVariable() != null) {
            attr.setMutator(ModelUtils.getMutator(problemCtx.getCompilationInfo(), problemCtx.getJavaClass(), attr.getInstanceVariable()));
        }
        if (problemCtx.getAccessType() == AccessType.FIELD) {
            attr.setJavaElement(attr.getInstanceVariable());
        } else if (problemCtx.getAccessType() == AccessType.PROPERTY) {
            attr.setJavaElement(attr.getAccesor());
        }
    }

    public static ExecutableElement getAccesor(TypeElement clazz, String fieldName) {
        for (ExecutableElement method : ModelUtils.getMethod(clazz, ModelUtils.getAccesorName(fieldName))) {
            if (method.getParameters().size() != 0) continue;
            return method;
        }
        for (ExecutableElement method : ModelUtils.getMethod(clazz, ModelUtils.getBooleanAccesorName(fieldName))) {
            if (method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public static ExecutableElement getMutator(CompilationInfo info, TypeElement clazz, VariableElement field) {
        ExecutableElement[] matchingMethods;
        for (ExecutableElement potentialMutator : matchingMethods = ModelUtils.getMethod(clazz, ModelUtils.getMutatorName(field.getSimpleName().toString()))) {
            if (potentialMutator.getParameters().size() != 1) continue;
            TypeMirror argType = potentialMutator.getParameters().get(0).asType();
            if (!info.getTypes().isSameType(argType, field.asType())) continue;
            return potentialMutator;
        }
        return null;
    }

    public static ExecutableElement[] getMethod(TypeElement clazz, String methodName) {
        ArrayList<ExecutableElement> methods = new ArrayList<ExecutableElement>();
        for (ExecutableElement method : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
            if (!method.getSimpleName().contentEquals(methodName)) continue;
            methods.add(method);
        }
        return methods.toArray(new ExecutableElement[methods.size()]);
    }

    public static String getAccesorName(String fieldName) {
        return "get" + Character.toString(fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
    }

    public static String getBooleanAccesorName(String fieldName) {
        return "is" + Character.toString(fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
    }

    public static String getMutatorName(String fieldName) {
        return "set" + Character.toString(fieldName.charAt(0)).toUpperCase() + fieldName.substring(1);
    }

    public static String getFieldNameFromAccessor(String accessorName) {
        if (!accessorName.startsWith("get")) {
            throw new IllegalArgumentException("accessor name must start with 'get'");
        }
        return String.valueOf(accessorName.charAt(3)).toLowerCase() + accessorName.substring(4);
    }

    public static VariableElement getField(TypeElement clazz, String fieldName) {
        for (VariableElement field : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
            if (!field.getSimpleName().contentEquals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public static MetadataModel<EntityMappingsMetadata> getModel(FileObject sourceFile) {
        EntityClassScope scope = EntityClassScope.getEntityClassScope((FileObject)sourceFile);
        if (scope != null) {
            return scope.getEntityMappingsModel(false);
        }
        return null;
    }

    public static Collection<String> extractAnnotationNames(Element elem) {
        LinkedList<String> annotationsOnElement = new LinkedList<String>();
        for (AnnotationMirror annotationMirror : elem.getAnnotationMirrors()) {
            DeclaredType annType = annotationMirror.getAnnotationType();
            Element typeElem = annType.asElement();
            String typeName = ((TypeElement)typeElem).getQualifiedName().toString();
            annotationsOnElement.add(typeName);
        }
        return annotationsOnElement;
    }

    public static String shortAnnotationName(String annClass) {
        return "@" + annClass.substring(annClass.lastIndexOf(".") + 1);
    }
}

