/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.uid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;

public final class UIDCsmConverter {
    private UIDCsmConverter() {
    }

    public static boolean isIdentifiable(Object object) {
        return object instanceof CsmIdentifiable;
    }

    public static CsmFile UIDtoFile(CsmUID<CsmFile> csmUID) {
        try {
            CsmFile csmFile = csmUID == null ? null : (CsmFile)csmUID.getObject();
            return csmFile;
        }
        catch (StackOverflowError stackOverflowError) {
            Exception exception = new Exception("StackOverflowError for UID " + csmUID);
            exception.setStackTrace(stackOverflowError.getStackTrace());
            DiagnosticExceptoins.register(exception);
            return null;
        }
    }

    public static <T> T UIDtoCsmObject(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : csmUID.getObject());
    }

    public static CsmNamespace UIDtoNamespace(CsmUID<CsmNamespace> csmUID) {
        return csmUID == null ? null : (CsmNamespace)csmUID.getObject();
    }

    public static CsmProject UIDtoProject(CsmUID<CsmProject> csmUID) {
        return csmUID == null ? null : (CsmProject)csmUID.getObject();
    }

    public static <T extends CsmDeclaration> T UIDtoDeclaration(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : (CsmDeclaration)csmUID.getObject());
    }

    public static CsmScope UIDtoScope(CsmUID<CsmScope> csmUID) {
        return csmUID == null ? null : (CsmScope)csmUID.getObject();
    }

    public static CsmClass UIDtoClass(CsmUID<CsmClass> csmUID) {
        return csmUID == null ? null : (CsmClass)csmUID.getObject();
    }

    public static <T> Collection<T> UIDsToNamespaces(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static <T extends CsmDeclaration> Collection<T> UIDsToDeclarations(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static CsmInheritance UIDsToInheritance(CsmUID<CsmInheritance> csmUID) {
        return csmUID == null ? null : (CsmInheritance)csmUID.getObject();
    }

    public static <T extends CsmInheritance> Collection<T> UIDsToInheritances(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static CsmUID<CsmInheritance> inheritanceToUID(CsmInheritance csmInheritance) {
        return csmInheritance == null ? null : UIDs.get((Object)csmInheritance);
    }

    public static <T extends CsmDeclaration> Iterator<T> UIDsToDeclarationsFiltered(Collection<CsmUID<T>> collection, CsmSelect.CsmFilter csmFilter) {
        return new LazyCsmCollection(new ArrayList(collection), true).iterator(csmFilter);
    }

    public static <T> Collection<T> UIDsToDeclarationsUnsafe(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, true);
        return collection2;
    }

    public static <T> Collection<T> UIDsToMacros(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static <T> Iterator<T> UIDsToMacros(Collection<CsmUID<T>> collection, CsmSelect.CsmFilter csmFilter) {
        return new LazyCsmCollection(new ArrayList(collection), true).iterator(csmFilter);
    }

    public static <T> Collection<T> UIDsToIncludes(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static <T> Iterator<T> UIDsToIncludes(Collection<CsmUID<T>> collection, CsmSelect.CsmFilter csmFilter) {
        return new LazyCsmCollection(new ArrayList(collection), true).iterator(csmFilter);
    }

    public static <T> Collection<T> UIDsToInstantiations(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    public static <T> Iterator<T> UIDsToInstantiations(Collection<CsmUID<T>> collection, CsmSelect.CsmFilter csmFilter) {
        return new LazyCsmCollection(new ArrayList(collection), true).iterator(csmFilter);
    }

    public static <T> Collection<T> UIDsToCsmObjects(Collection<CsmUID<T>> collection) {
        Collection<T> collection2 = UIDCsmConverter.UIDsToList(collection, false);
        return collection2;
    }

    private static <T> Collection<T> UIDsToList(Collection<CsmUID<T>> collection, boolean bl) {
        return new LazyCsmCollection(new ArrayList(collection), bl |= TraceFlags.SAFE_UID_ACCESS);
    }

    public static <T> Iterator<T> UIDsToDeclarations(Collection<CsmUID<T>> collection, CsmSelect.CsmFilter csmFilter) {
        return new LazyCsmCollection(collection, true).iterator(csmFilter);
    }

    public static <T> T UIDtoIdentifiable(CsmUID<T> csmUID) {
        return (T)(csmUID == null ? null : csmUID.getObject());
    }

    public static CsmUID<CsmFile> fileToUID(CsmFile csmFile) {
        return csmFile == null ? null : UIDs.get((Object)csmFile);
    }

    public static CsmUID<CsmNamespace> namespaceToUID(CsmNamespace csmNamespace) {
        return csmNamespace == null ? null : UIDs.get((Object)csmNamespace);
    }

    public static CsmUID<CsmProject> projectToUID(CsmProject csmProject) {
        return csmProject == null ? null : UIDs.get((Object)csmProject);
    }

    public static <T extends CsmDeclaration> CsmUID<T> declarationToUID(T t) {
        return t == null ? null : UIDs.get(t);
    }

    public static CsmUID<CsmScope> scopeToUID(CsmScope csmScope) {
        return csmScope == null ? null : UIDs.get((Object)csmScope);
    }

    public static <T> CsmUID<T> identifiableToUID(CsmIdentifiable csmIdentifiable) {
        if (csmIdentifiable == null) {
            return null;
        }
        CsmUID<?> csmUID = csmIdentifiable.getUID();
        return csmUID;
    }

    public static <T extends CsmObject> CsmUID<T> objectToUID(T t) {
        if (t == null) {
            return null;
        }
        return UIDs.get(t);
    }

    public static <T extends CsmObject> Collection<CsmUID<T>> objectsToUIDs(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return new ArrayList<CsmUID<T>>(0);
        }
        ArrayList<CsmUID<T>> arrayList = new ArrayList<CsmUID<T>>(collection.size());
        for (CsmObject csmObject : collection) {
            CsmUID csmUID = UIDs.get((Object)csmObject);
            arrayList.add(csmUID);
        }
        return arrayList;
    }
}

