/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public final class NativeProjectProvider {
    private NativeProjectProvider() {
    }

    public static NativeProject createProject(String string, List<File> list, List<String> list2, List<String> list3, List<String> list4, List<String> list5, boolean bl) {
        NativeProjectImpl nativeProjectImpl = new NativeProjectImpl(string, list2, list3, list4, list5, bl);
        nativeProjectImpl.addFiles(list);
        return nativeProjectImpl;
    }

    public static void fireAllFilesChanged(NativeProject nativeProject) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).fireAllFilesChanged();
        }
    }

    public static void setUserMacros(NativeProject nativeProject, List<String> list) {
        if (nativeProject instanceof NativeProjectImpl) {
            ((NativeProjectImpl)nativeProject).usrMacros.clear();
            ((NativeProjectImpl)nativeProject).usrMacros.addAll(list);
        }
    }

    public static NativeFileItem.Language getLanguage(File file, DataObject dataObject) {
        CndUtils.assertNotNull((Object)file, (String)"null file");
        FileObject fileObject = null;
        if (dataObject != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        String string = "";
        string = fileObject != null ? MIMESupport.getFileMIMEType((FileObject)fileObject) : MIMESupport.getFileMIMEType((File)file);
        return NativeProjectProvider.getLanguage(string);
    }

    public static NativeFileItem.Language getLanguage(FileObject fileObject, DataObject dataObject) {
        CndUtils.assertNotNull((Object)fileObject, (String)"null file object");
        String string = MIMESupport.getFileMIMEType((FileObject)fileObject);
        return NativeProjectProvider.getLanguage(string);
    }

    private static NativeFileItem.Language getLanguage(String string) {
        if ("text/x-c++".equals(string)) {
            return NativeFileItem.Language.CPP;
        }
        if ("text/x-c".equals(string)) {
            return NativeFileItem.Language.C;
        }
        if ("text/x-fortran".equals(string)) {
            return NativeFileItem.Language.FORTRAN;
        }
        if ("text/x-h".equals(string)) {
            return NativeFileItem.Language.C_HEADER;
        }
        return NativeFileItem.Language.OTHER;
    }

    public static DataObject getDataObject(FileObject fileObject) {
        DataObject dataObject = null;
        if (fileObject != null) {
            try {
                dataObject = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return dataObject;
    }

    public static DataObject getDataObject(File file) {
        CndUtils.assertNormalized((File)file);
        return NativeProjectProvider.getDataObject(CndFileUtils.toFileObject((File)file));
    }

    static void registerItemInDataObject(DataObject dataObject, NativeFileItem nativeFileItem) {
        NativeFileItemSet nativeFileItemSet;
        if (dataObject != null && (nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class)) != null) {
            nativeFileItemSet.add(nativeFileItem);
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(File file, NativeProjectImpl nativeProjectImpl, NativeFileItem.Language language) {
            this.project = nativeProjectImpl;
            this.file = CndFileUtils.normalizeFile((File)file);
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return CndFileUtils.toFileObject((File)this.file);
        }

        public String getAbsolutePath() {
            return this.file.getAbsolutePath();
        }

        public String getName() {
            return this.file.getName();
        }

        public List<FSPath> getSystemIncludePaths() {
            List<FSPath> list = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        public List<FSPath> getUserIncludePaths() {
            List<FSPath> list = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        private List<FSPath> toAbsolute(List<FSPath> list) {
            File file = this.file.getParentFile();
            ArrayList<FSPath> arrayList = new ArrayList<FSPath>(list.size());
            for (FSPath fSPath : list) {
                File file2 = new File(fSPath.getPath());
                if (file2.isAbsolute()) {
                    arrayList.add(fSPath);
                    continue;
                }
                file2 = new File(file, fSPath.getPath());
                arrayList.add(new FSPath(CndFileUtils.getLocalFileSystem(), file2.getAbsolutePath()));
            }
            return arrayList;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }
    }

    public static final class NativeProjectImpl
    implements NativeProject {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        private boolean pathsRelCurFile;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        public NativeProjectImpl(String string, List<String> list, List<String> list2, List<String> list3, List<String> list4, boolean bl) {
            this.projectRoot = string;
            this.pathsRelCurFile = bl;
            this.sysIncludes = this.createIncludes(list);
            this.usrIncludes = this.createIncludes(list2);
            this.sysMacros = new ArrayList<String>(list3);
            this.usrMacros = new ArrayList<String>(list4);
        }

        private List<String> createIncludes(List<String> list) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file = new File(string);
                arrayList.add(file.getAbsolutePath());
            }
            return arrayList;
        }

        private void addFiles(List<File> list) {
            for (File file : list) {
                this.addFile(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file.getAbsoluteFile())));
            }
        }

        public Object getProject() {
            return null;
        }

        public FileSystem getFileSystem() {
            return CndFileUtils.getLocalFileSystem();
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return "DummyProject";
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public NativeFileSearch getNativeFileSearch() {
            return new NativeFileSearch(){

                public Collection<CharSequence> searchFile(NativeProject nativeProject, String string) {
                    return Collections.emptyList();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileChanged(FileObject fileObject) {
            ArrayList<NativeProjectItemsListener> arrayList;
            NativeFileItem nativeFileItem = this.findFileItem(fileObject);
            Iterator iterator = this.listenersLock;
            synchronized (iterator) {
                arrayList = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            for (NativeProjectItemsListener nativeProjectItemsListener : arrayList) {
                nativeProjectItemsListener.filePropertiesChanged(nativeFileItem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireFileAdded(FileObject fileObject) {
            ArrayList<NativeProjectItemsListener> arrayList;
            NativeFileItem nativeFileItem = this.findFileItem(fileObject);
            if (nativeFileItem == null) {
                nativeFileItem = this.addFile(fileObject);
            }
            Iterator iterator = this.listenersLock;
            synchronized (iterator) {
                arrayList = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            for (NativeProjectItemsListener nativeProjectItemsListener : arrayList) {
                nativeProjectItemsListener.fileAdded(nativeFileItem);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireAllFilesChanged() {
            ArrayList<NativeProjectItemsListener> arrayList;
            List<NativeFileItem> list = this.listenersLock;
            synchronized (list) {
                arrayList = new ArrayList<NativeProjectItemsListener>(this.listeners);
            }
            list = Collections.unmodifiableList(this.files);
            for (NativeProjectItemsListener nativeProjectItemsListener : arrayList) {
                nativeProjectItemsListener.filesPropertiesChanged(list);
            }
        }

        public NativeFileItem findFileItem(FileObject fileObject) {
            return this.findFileItem(CndFileUtils.getNormalizedPath((FileObject)fileObject));
        }

        private NativeFileItem findFileItem(String string) {
            for (NativeFileItem nativeFileItem : this.files) {
                if (!nativeFileItem.getAbsolutePath().equalsIgnoreCase(string)) continue;
                return nativeFileItem;
            }
            return null;
        }

        public List<FSPath> getSystemIncludePaths() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.sysIncludes);
        }

        public List<FSPath> getUserIncludePaths() {
            return CndFileUtils.toFSPathList((FileSystem)CndFileUtils.getLocalFileSystem(), this.usrIncludes);
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        private NativeFileItem addFile(FileObject fileObject) {
            File file = FileUtil.toFile((FileObject)fileObject);
            DataObject dataObject = NativeProjectProvider.getDataObject(fileObject);
            NativeFileItem.Language language = NativeProjectProvider.getLanguage(fileObject, dataObject);
            NativeFileItemImpl nativeFileItemImpl = new NativeFileItemImpl(file, this, language);
            this.files.add(nativeFileItemImpl);
            return nativeFileItemImpl;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable namedRunnable) {
            namedRunnable.run();
        }

        public NativeExitStatus execute(String string, String[] stringArray, String ... stringArray2) {
            return null;
        }

        public String getPlatformName() {
            return null;
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }
}

