/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryListenerImpl;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.api.RepositoryTranslation;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class RepositoryUtils {
    private static final boolean TRACE_ARGS = CndUtils.getBoolean((String)"cnd.repository.trace.args", (boolean)false);
    private static final boolean TRACE_REPOSITORY_ACCESS = TRACE_ARGS || DebugUtils.getBoolean((String)"cnd.modelimpl.trace.repository", (boolean)false);
    private static final Repository repository = RepositoryAccessor.getRepository();
    private static final RepositoryTranslation translator = RepositoryAccessor.getTranslator();
    private static int CURRENT_VERSION_OF_PERSISTENCY = 104;
    private static volatile int counter = 0;
    private static RepositoryListenerProxy myRepositoryListenerProxy;

    private RepositoryUtils() {
    }

    public static <T> T get(CsmUID<T> csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        Persistent persistent = RepositoryUtils.get(key);
        assert (persistent == null || persistent instanceof CsmIdentifiable) : "unexpected object with class " + persistent.getClass() + persistent;
        Persistent persistent2 = persistent;
        return (T)persistent2;
    }

    public static Persistent tryGet(Key key) {
        assert (key != null);
        Persistent persistent = repository.tryGet(key);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            System.err.printf("%d:trying key %s got %s", RepositoryUtils.nextIndex(), key, persistent);
        }
        return persistent;
    }

    public static Persistent get(Key key) {
        assert (key != null);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            long l = System.currentTimeMillis();
            int n = RepositoryUtils.nextIndex();
            System.err.println(n + ": " + System.identityHashCode(key) + "@getting key " + key);
            Persistent persistent = repository.get(key);
            l = System.currentTimeMillis() - l;
            System.err.println(n + ": " + System.identityHashCode(key) + "@got" + (persistent == null ? " - NULL" : "") + " in " + l + "ms the key " + key);
            return persistent;
        }
        return repository.get(key);
    }

    private static synchronized int nextIndex() {
        return counter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void remove(CsmUID<T> csmUID, CsmObject csmObject) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        if (key != null) {
            try {
                if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                    long l = System.currentTimeMillis();
                    int n = RepositoryUtils.nextIndex();
                    System.err.println(n + ": " + System.identityHashCode(key) + "@removing key " + key);
                    if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                        repository.remove(key);
                    }
                    l = System.currentTimeMillis() - l;
                    System.err.println(n + ": " + System.identityHashCode(key) + "@removed in " + l + "ms the key " + key);
                    return;
                }
                if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                    repository.remove(key);
                }
            }
            finally {
                RepositoryUtils.disposeUID(csmUID, csmObject);
            }
        }
    }

    public static <T> void disposeUID(CsmUID<T> csmUID, CsmObject csmObject) {
        if (csmUID instanceof KeyBasedUID) {
            ((KeyBasedUID)csmUID).dispose(csmObject);
        }
    }

    public static <T> void remove(Collection<? extends CsmUID<T>> collection) {
        if (collection != null) {
            for (CsmUID<T> csmUID : collection) {
                RepositoryUtils.remove(csmUID, null);
            }
        }
    }

    public static <T> CsmUID<T> put(T t) {
        CsmUID<T> csmUID = null;
        if (t != null) {
            csmUID = UIDProviderIml.get(t, false);
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.put(key, (Persistent)t);
            if (!(t instanceof CsmNamespace) && !(t instanceof CsmProject)) assert (csmUID.getObject() != null);
        }
        return csmUID;
    }

    public static void put(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ": " + System.identityHashCode(key) + "@putting key " + key);
                repository.put(key, persistent);
                l = System.currentTimeMillis() - l;
                System.err.println(n + ": " + System.identityHashCode(key) + "@put in " + l + "ms the key " + key);
                return;
            }
            repository.put(key, persistent);
        }
    }

    public static void hang(Object object) {
        CsmUID<Object> csmUID = null;
        if (object != null) {
            csmUID = UIDProviderIml.get(object, false);
            assert (csmUID != null);
            Key key = RepositoryUtils.UIDtoKey(csmUID);
            RepositoryUtils.hang(key, (Persistent)object);
            if (!(object instanceof CsmNamespace) && !(object instanceof CsmProject)) assert (csmUID.getObject() != null);
        }
    }

    public static void hang(Key key, Persistent persistent) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long l = System.currentTimeMillis();
                int n = RepositoryUtils.nextIndex();
                System.err.println(n + ": " + System.identityHashCode(key) + "@hanging key " + key);
                repository.hang(key, persistent);
                l = System.currentTimeMillis() - l;
                System.err.println(n + ": " + System.identityHashCode(key) + "@hung in " + l + "ms the key " + key);
                return;
            }
            repository.hang(key, persistent);
        }
    }

    public static <T> Collection<CsmUID<T>> put(Collection<T> collection) {
        assert (collection != null);
        ArrayList<CsmUID<T>> arrayList = new ArrayList<CsmUID<T>>(collection.size());
        for (T t : collection) {
            if (!(t instanceof CsmIdentifiable)) continue;
            CsmUID<T> csmUID = RepositoryUtils.put(t);
            arrayList.add(csmUID);
        }
        return arrayList;
    }

    public static <T extends CsmObject> void setSelfUIDs(Collection<T> collection) {
        assert (collection != null);
        for (CsmObject csmObject : collection) {
            Utils.setSelfUID(csmObject);
        }
    }

    public static <T> Key UIDtoKey(CsmUID<T> csmUID) {
        if (csmUID instanceof KeyHolder) {
            return ((KeyHolder)csmUID).getKey();
        }
        return null;
    }

    public static <T> CharSequence getUnitName(CsmUID<T> csmUID) {
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        assert (key != null);
        CharSequence charSequence = key.getUnit();
        return charSequence;
    }

    public static void startup() {
        repository.startup(CURRENT_VERSION_OF_PERSISTENCY);
        repository.unregisterRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
        repository.registerRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
    }

    private static synchronized RepositoryListenerProxy getRepositoryListenerProxy() {
        if (myRepositoryListenerProxy == null) {
            myRepositoryListenerProxy = new RepositoryListenerProxy();
        }
        return myRepositoryListenerProxy;
    }

    public static void shutdown() {
        repository.shutdown();
    }

    public static void cleanCashes() {
        repository.cleanCaches();
    }

    public static void debugClear() {
        repository.debugClear();
    }

    public static <T> void closeUnit(CsmUID<T> csmUID, Set<CharSequence> set, boolean bl) {
        RepositoryUtils.closeUnit(RepositoryUtils.UIDtoKey(csmUID), set, bl);
    }

    public static void closeUnit(CharSequence charSequence, Set<CharSequence> set, boolean bl) {
        RepositoryListenerImpl.instance().onExplicitClose(charSequence);
        RepositoryUtils._closeUnit(charSequence, set, bl);
    }

    public static void closeUnit(Key key, Set<CharSequence> set, boolean bl) {
        assert (key != null);
        RepositoryUtils._closeUnit(key.getUnit(), set, bl);
        if (bl) {
            UIDManager.instance().clearProjectCache(key);
        }
    }

    private static void _closeUnit(CharSequence charSequence, Set<CharSequence> set, boolean bl) {
        int n;
        assert (charSequence != null);
        if (!bl && (n = myRepositoryListenerProxy.getErrorCount(charSequence)) > 0) {
            System.err.println("Clean index for project \"" + charSequence + "\" because index was corrupted (was " + n + " errors).");
            bl = true;
        }
        myRepositoryListenerProxy.cleanErrorCount(charSequence);
        repository.closeUnit(charSequence, bl, set);
    }

    public static int getRepositoryErrorCount(ProjectBase projectBase) {
        return RepositoryUtils.getRepositoryListenerProxy().getErrorCount(projectBase.getUniqueName());
    }

    public static void onProjectDeleted(NativeProject nativeProject) {
        Key key = KeyUtilities.createProjectKey(nativeProject);
        repository.removeUnit(key.getUnit());
    }

    public static void openUnit(ProjectBase projectBase) {
        CsmUID<CsmProject> csmUID = projectBase.getUID();
        assert (csmUID != null);
        Key key = RepositoryUtils.UIDtoKey(csmUID);
        RepositoryUtils.openUnit(key);
    }

    public static void openUnit(Key key) {
        RepositoryUtils.openUnit(key.getUnitId(), key.getUnit());
    }

    private static void openUnit(int n, CharSequence charSequence) {
        RepositoryListenerImpl.instance().onExplicitOpen(charSequence);
        repository.openUnit(n, charSequence);
    }

    public static void unregisterRepositoryListener(RepositoryListener repositoryListener) {
        repository.unregisterRepositoryListener(repositoryListener);
    }

    static int getUnitId(CharSequence charSequence) {
        return translator.getUnitId(charSequence);
    }

    static CharSequence getUnitName(int n) {
        return translator.getUnitName(n);
    }

    static int getFileIdByName(int n, CharSequence charSequence) {
        return translator.getFileIdByName(n, charSequence);
    }

    static CharSequence getFileNameByIdSafe(int n, int n2) {
        return translator.getFileNameByIdSafe(n, n2);
    }

    static CharSequence getFileNameById(int n, int n2) {
        return translator.getFileNameById(n, n2);
    }

    private static boolean isTracingKey(Key key) {
        if (TRACE_ARGS) {
            return key.getDepth() == 3 && ("argc".contentEquals(key.getAt(2)) || "main".contentEquals(key.getAt(2)));
        }
        return true;
    }

    private static class RepositoryListenerProxy
    implements RepositoryListener {
        private RepositoryListener parent = RepositoryListenerImpl.instance();
        private Map<CharSequence, Integer> wasErrors = new ConcurrentHashMap<CharSequence, Integer>();

        private RepositoryListenerProxy() {
        }

        public int getErrorCount(CharSequence charSequence) {
            Integer n = this.wasErrors.get(charSequence);
            if (n == null) {
                return 0;
            }
            return n;
        }

        public void cleanErrorCount(CharSequence charSequence) {
            this.wasErrors.remove(charSequence);
        }

        public boolean unitOpened(CharSequence charSequence) {
            return this.parent.unitOpened(charSequence);
        }

        public void unitClosed(CharSequence charSequence) {
            this.parent.unitClosed(charSequence);
        }

        public void anExceptionHappened(CharSequence charSequence, RepositoryException repositoryException) {
            this.primitiveErrorStrategy(charSequence, repositoryException);
            this.parent.anExceptionHappened(charSequence, repositoryException);
        }

        private void primitiveErrorStrategy(CharSequence charSequence, RepositoryException repositoryException) {
            Integer n = this.wasErrors.get(charSequence);
            n = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
            this.wasErrors.put(charSequence, n);
        }
    }
}

