/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.spi;

import java.util.Collection;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.openide.util.Lookup;

public abstract class CsmParserProvider {
    public static final CsmParserProvider DEFAULT = new Default();

    public static CsmParser createParser(CsmFile csmFile) {
        return DEFAULT.create(csmFile);
    }

    protected abstract CsmParser create(CsmFile var1);

    private static final class Default
    extends CsmParserProvider {
        private final Collection<? extends CsmParserProvider> parserProviders = Lookup.getDefault().lookupAll(CsmParserProvider.class);

        @Override
        protected CsmParser create(CsmFile csmFile) {
            for (CsmParserProvider csmParserProvider : this.parserProviders) {
                CsmParser csmParser = csmParserProvider.create(csmFile);
                if (csmParser == null) continue;
                return csmParser;
            }
            return null;
        }
    }

    public static interface CsmParserResult {
        public void render(Object ... var1);

        public boolean isEmptyAST();

        public Object getAST();

        public void dumpAST();

        public int getErrorCount();
    }

    public static interface CsmParser {
        public void init(CsmObject var1, TokenStream var2);

        public CsmParserResult parse(ConstructionKind var1);

        public static enum ConstructionKind {
            TRANSLATION_UNIT,
            CLASS_BODY,
            TRY_BLOCK,
            COMPOUND_STATEMENT,
            NAMESPACE_DEFINITION_BODY;

        }
    }
}

