/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.utils.CndUtils;

public class ClassifierResolverImpl
extends CsmClassifierResolver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getTypeClassifier(CsmType csmType, CsmFile csmFile, int n, boolean bl) {
        CsmClassifier csmClassifier2;
        CsmProject csmProject = csmFile.getProject();
        if (csmProject != null && csmProject.isArtificial()) {
            for (CsmClassifier csmClassifier2 : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, n)) {
                if (csmClassifier2.getStartFile() == null) continue;
                csmFile = csmClassifier2.getStartFile();
                break;
            }
        }
        Resolver resolver = ResolverFactory.createResolver(csmFile, n);
        csmClassifier2 = null;
        try {
            csmClassifier2 = csmType.getClassifier();
            if (bl) {
                csmClassifier2 = resolver.getOriginalClassifier(csmClassifier2);
            }
        }
        finally {
            ResolverFactory.releaseResolver(resolver);
        }
        return csmClassifier2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier, CsmFile csmFile) {
        if (csmClassifier instanceof CsmOffsetable) {
            CsmProject csmProject = csmFile.getProject();
            if (csmProject != null && csmProject.isArtificial()) {
                for (CsmClassifier csmClassifier2 : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, 0)) {
                    if (csmClassifier2.getStartFile() == null) continue;
                    csmFile = csmClassifier2.getStartFile();
                    break;
                }
            }
            Resolver resolver = ResolverFactory.createResolver((CsmOffsetable)csmClassifier, csmFile);
            try {
                CsmClassifier csmClassifier2;
                csmClassifier2 = resolver.getOriginalClassifier(csmClassifier);
                return csmClassifier2;
            }
            finally {
                ResolverFactory.releaseResolver(resolver);
            }
        }
        return csmClassifier;
    }

    public boolean isForwardClass(CsmObject csmObject) {
        return CsmKindUtilities.isDeclaration((CsmObject)csmObject) && ForwardClass.isForwardClass((CsmDeclaration)csmObject);
    }

    public CsmClassifier findClassifierUsedInFile(CharSequence charSequence, CsmFile csmFile, boolean bl) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject == null) {
            return null;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        CsmClassifier csmClassifier = this.findVisibleDeclaration(csmProject, charSequence, csmFile, atomicBoolean, bl);
        if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier) && atomicBoolean.get()) {
            assert (csmClassifier != null) : "how can visible be true without a result?";
            return csmClassifier;
        }
        Collection<CsmProject> collection = this.getLibraries(csmFile, 0);
        Iterator<CsmProject> iterator = collection.iterator();
        while (iterator.hasNext()) {
            atomicBoolean.set(false);
            CsmProject csmProject2 = iterator.next();
            CsmClassifier csmClassifier2 = this.findVisibleDeclaration(csmProject2, charSequence, csmFile, atomicBoolean, bl);
            if (!ForwardClass.isForwardClass((CsmDeclaration)csmClassifier2) && atomicBoolean.get()) {
                return csmClassifier2;
            }
            if (csmClassifier != null) continue;
            csmClassifier = csmClassifier2;
        }
        return csmClassifier;
    }

    private CsmClassifier findVisibleDeclaration(CsmProject csmProject, CharSequence charSequence, CsmFile csmFile, AtomicBoolean atomicBoolean, boolean bl) {
        Collection collection = csmProject.findClassifiers(charSequence);
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        CsmClassifier csmClassifier = null;
        CsmIncludeResolver csmIncludeResolver = CsmIncludeResolver.getDefault();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        AtomicBoolean atomicBoolean2 = new AtomicBoolean(false);
        for (Object object : collection) {
            if (bl && !CsmKindUtilities.isClass((CsmObject)object)) continue;
            if (csmClassifier == null || ForwardClass.isForwardClass(csmClassifier)) {
                csmClassifier = object;
            }
            if (!csmIncludeResolver.isObjectVisible(csmFile, (CsmObject)object)) continue;
            if (CsmKindUtilities.isTypedef((CsmObject)object)) {
                CharSequence charSequence2 = ((CsmTypedef)object).getType().getClassifierText();
                if (object.getName().equals(charSequence2)) {
                    if (atomicBoolean2.get()) continue;
                    arrayList.add((CsmClassifier)object);
                    arrayList2.add((CsmTypedef)object);
                    continue;
                }
                arrayList.add((CsmClassifier)object);
                continue;
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)object) || ForwardClass.isForwardClass((CsmDeclaration)object)) {
                if (atomicBoolean2.get()) continue;
                arrayList.add((CsmClassifier)object);
                arrayList2.add(object);
                continue;
            }
            if (arrayList2 != null) {
                arrayList.removeAll(arrayList2);
                arrayList2.clear();
            }
            atomicBoolean2.set(true);
            arrayList.add((CsmClassifier)object);
        }
        if (!arrayList.isEmpty()) {
            atomicBoolean.set(true);
            if (CndUtils.isDebugMode() && !CndUtils.isUnitTestMode() && arrayList.size() > 1) {
                System.err.printf("findVisibleDeclaration: we have several classifiers %s visible from %s\n", charSequence, csmFile.getAbsolutePath());
                int n = 0;
                for (CsmClassifier csmClassifier2 : arrayList) {
                    System.err.printf("[%d] %s\n", n++, csmClassifier2);
                }
            }
            return (CsmClassifier)arrayList.get(0);
        }
        return csmClassifier;
    }

    private Collection<CsmProject> getLibraries(CsmFile csmFile, int n) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject == null) {
            return Collections.emptyList();
        }
        if (csmProject.isArtificial()) {
            HashSet<CsmProject> hashSet = new HashSet<CsmProject>(2);
            for (CsmCompilationUnit csmCompilationUnit : CsmFileInfoQuery.getDefault().getCompilationUnits(csmFile, n)) {
                hashSet.addAll(csmCompilationUnit.getStartProject().getLibraries());
            }
            return hashSet;
        }
        return csmProject.getLibraries();
    }
}

