/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.fsm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModule;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;

public final class ModuleImpl
extends OffsetableDeclarationBase<CsmNamespaceDefinition>
implements CsmModule,
CsmNamespaceDefinition,
MutableDeclarationsContainer,
Disposable {
    private final List<CsmUID<CsmOffsetableDeclaration>> declarations;
    private final CharSequence name;

    private ModuleImpl(CsmFile csmFile, int n, int n2, String string) {
        super(csmFile, n, n2);
        this.declarations = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        this.name = NameCache.getManager().getString((CharSequence)string);
    }

    public static ModuleImpl create(CsmFile csmFile, int n, int n2, String string) {
        ModuleImpl moduleImpl = new ModuleImpl(csmFile, n, n2, string);
        ModuleImpl.postObjectCreateRegistration(true, moduleImpl);
        return moduleImpl;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> collection;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            collection = UIDCsmConverter.UIDsToDeclarations(this.declarations);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        Iterator<CsmOffsetableDeclaration> iterator;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            iterator = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations, csmFilter);
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        CsmUID csmUID = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            csmUID = UIDUtilities.findExistingUIDInList(this.declarations, n, n2, charSequence);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID = RepositoryUtils.put(csmOffsetableDeclaration);
        assert (csmUID != null);
        Object object = this.declarations;
        synchronized (object) {
            UIDUtilities.insertIntoSortedUIDList(csmUID, this.declarations);
        }
        if (csmOffsetableDeclaration instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope(object = (FunctionImpl)csmOffsetableDeclaration)) {
            ((FunctionImpl)object).setScope((CsmScope)this);
        }
        RepositoryUtils.put(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
        assert (csmUID != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            this.declarations.remove(csmUID);
        }
        RepositoryUtils.remove(csmUID, (CsmObject)csmOffsetableDeclaration);
        RepositoryUtils.put(this);
    }

    public CsmNamespace getNamespace() {
        return null;
    }

    public CharSequence getQualifiedName() {
        return this.name;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        for (CsmDeclaration csmDeclaration : this.getDeclarations()) {
            if (!this.isOfMyScope(csmDeclaration)) continue;
            arrayList.add((CsmScopeElement)csmDeclaration);
        }
        return arrayList;
    }

    private boolean isOfMyScope(CsmDeclaration csmDeclaration) {
        if (csmDeclaration instanceof VariableImpl) {
            return !NamespaceImpl.isNamespaceScope((VariableImpl)csmDeclaration, false);
        }
        if (csmDeclaration instanceof FunctionImpl) {
            return !NamespaceImpl.isNamespaceScope((FunctionImpl)csmDeclaration);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList;
        Collection<CsmOffsetableDeclaration> collection;
        super.dispose();
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            collection = this.getDeclarations();
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations);
            this.declarations.clear();
        }
        Utils.disposeAll(collection);
        RepositoryUtils.remove(arrayList);
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUIDCollection(this.declarations, dataOutput, true);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        if (this.getName().length() == 0) {
            this.writeUID(dataOutput);
        }
    }

    public ModuleImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        int n = dataInput.readInt();
        this.declarations = n < 0 ? new ArrayList<CsmUID<CsmOffsetableDeclaration>>() : new ArrayList<CsmUID<CsmOffsetableDeclaration>>(n);
        uIDObjectFactory.readUIDCollection(this.declarations, dataInput, n);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        if (this.getName().length() == 0) {
            this.readUID(dataInput);
        }
    }
}

