/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.Parser;
import org.netbeans.modules.cnd.antlr.RecognitionException;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ErrorDirectiveImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponentDeclarations;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponentIncludes;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponentInstantiations;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponentMacros;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponentReferences;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileStateCache;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileTokenStreamCache;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferDoc;
import org.netbeans.modules.cnd.modelimpl.repository.FileDeclarationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileIncludesKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileMacrosKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.syntaxerr.spi.ReadOnlyTokenBuffer;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public final class FileImpl
implements CsmFile,
MutableDeclarationsContainer,
Disposable,
Persistent,
SelfPersistent,
CsmIdentifiable {
    public static final boolean reportErrors = TraceFlags.REPORT_PARSING_ERRORS | TraceFlags.DEBUG;
    private static final boolean reportParse = Boolean.getBoolean("parser.log.parse");
    private static final boolean logState = Boolean.getBoolean("parser.log.state");
    private static final boolean emptyAstStatictics = Boolean.getBoolean("parser.empty.ast.statistics");
    public static final int UNDEFINED_FILE = 0;
    public static final int SOURCE_FILE = 1;
    public static final int SOURCE_C_FILE = 2;
    public static final int SOURCE_CPP_FILE = 3;
    public static final int HEADER_FILE = 4;
    private static volatile AtomicLong parseCount = new AtomicLong(1L);
    private FileBuffer fileBuffer;
    public static final Collection<APTPreprocHandler> DUMMY_HANDLERS = new EmptyCollection<APTPreprocHandler>();
    public static final APTPreprocHandler.State DUMMY_STATE = new APTPreprocHandler.State(){

        public boolean isCleaned() {
            return true;
        }

        public boolean isCompileContext() {
            return false;
        }

        public boolean isValid() {
            return false;
        }
    };
    private Object projectRef;
    private final CsmUID<CsmProject> projectUID;
    private final Set<ErrorDirectiveImpl> errors = this.createErrors();
    private final ReadWriteLock errorsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock projectLock = new ReentrantReadWriteLock();
    private int errorCount = 0;
    private int lastParseTime;
    private volatile State state;
    private volatile ParsingState parsingState;
    private CsmFile.FileType fileType = CsmFile.FileType.UNDEFINED_FILE;
    private final Object stateLock = new StateLock();
    private final List<CsmUID<FunctionImplEx<?>>> fakeFunctionRegistrations = new CopyOnWriteArrayList();
    private final List<FakeIncludePair> fakeIncludeRegistrations = new CopyOnWriteArrayList<FakeIncludePair>();
    private FileSnapshot fileSnapshot;
    private final Object snapShotLock = new Object();
    private long lastParsed = Long.MIN_VALUE;
    private int hash = 0;
    private Reference<List<CsmReference>> lastMacroUsages = null;
    private static Hook hook = null;
    private final AtomicBoolean inEnsureParsed = new AtomicBoolean(false);
    private final Object changeStateLock = new ChangeStateLock();
    private final Object tokStreamLock = new TokenStreamLock();
    private Reference<FileTokenStreamCache> tsRef = new SoftReference<Object>(null);
    public static final Comparator<CsmOffsetable> START_OFFSET_COMPARATOR = new Comparator<CsmOffsetable>(){

        @Override
        public int compare(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
            int n;
            if (csmOffsetable == csmOffsetable2) {
                return 0;
            }
            int n2 = csmOffsetable.getStartOffset();
            if (n2 == (n = csmOffsetable2.getStartOffset())) {
                return 0;
            }
            return n2 - n;
        }
    };
    private static final boolean TRACE_SCHUDULE_PARSING = Boolean.getBoolean("cnd.trace.schedule.parsing");
    private volatile boolean alreadyInFixFakeRegistrations = false;
    private CsmUID<CsmFile> uid = null;
    private final FileStateCache stateCache = new FileStateCache(this);
    private final FileDeclarationsKey fileDeclarationsKey;
    private final ProjectBase.WeakContainer<FileComponentDeclarations> weakFileDeclarations;
    private final FileMacrosKey fileMacrosKey;
    private final ProjectBase.WeakContainer<FileComponentMacros> weakFileMacros;
    private final AtomicBoolean hasBrokenIncludes;
    private final FileIncludesKey fileIncludesKey;
    private final ProjectBase.WeakContainer<FileComponentIncludes> weakFileIncludes;
    private final FileReferencesKey fileReferencesKey;
    private final ProjectBase.WeakContainer<FileComponentReferences> weakFileReferences;
    private final FileInstantiationsKey fileInstantiationsKey;
    private final ProjectBase.WeakContainer<FileComponentInstantiations> weakFileInstantiationReferences;

    public static void incParseCount() {
        parseCount.incrementAndGet();
    }

    public static int getParseCount() {
        return (int)(parseCount.get() & 0xFFFFFFFFL);
    }

    public FileImpl(FileBuffer fileBuffer, ProjectBase projectBase, CsmFile.FileType fileType, NativeFileItem nativeFileItem) {
        this.state = State.INITIAL;
        this.parsingState = ParsingState.NOT_BEING_PARSED;
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        this.fileBuffer = fileBuffer;
        this.fileDeclarationsKey = new FileDeclarationsKey(this);
        this.weakFileDeclarations = new ProjectBase.WeakContainer(projectBase, this.fileDeclarationsKey);
        new FileComponentDeclarations(this);
        this.weakFileDeclarations.clear();
        this.fileMacrosKey = new FileMacrosKey(this);
        this.weakFileMacros = new ProjectBase.WeakContainer(projectBase, this.fileMacrosKey);
        new FileComponentMacros(this);
        this.weakFileMacros.clear();
        this.fileIncludesKey = new FileIncludesKey(this);
        this.weakFileIncludes = new ProjectBase.WeakContainer(projectBase, this.fileIncludesKey);
        new FileComponentIncludes(this);
        this.weakFileIncludes.clear();
        this.hasBrokenIncludes = new AtomicBoolean(false);
        this.fileReferencesKey = new FileReferencesKey(this);
        this.weakFileReferences = new ProjectBase.WeakContainer(projectBase, this.fileReferencesKey);
        new FileComponentReferences(this);
        this.weakFileReferences.clear();
        this.fileInstantiationsKey = new FileInstantiationsKey(this);
        this.weakFileInstantiationReferences = new ProjectBase.WeakContainer(projectBase, this.fileInstantiationsKey);
        new FileComponentInstantiations(this);
        this.weakFileInstantiationReferences.clear();
        this.projectRef = new WeakReference<ProjectBase>(projectBase);
        this.fileType = fileType;
        if (nativeFileItem != null) {
            projectBase.putNativeFileItem(this.getUID(), nativeFileItem);
        }
        Notificator.instance().registerNewFile(this);
    }

    public static void setHook(Hook hook) {
        FileImpl.hook = hook;
    }

    public final NativeFileItem getNativeFileItem() {
        return this.getProjectImpl(true).getNativeFileItem(this.getUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBase _getProject(boolean bl) {
        ProjectBase projectBase;
        Object object = this.projectRef;
        if (object instanceof ProjectBase) {
            return (ProjectBase)object;
        }
        if (object instanceof Reference && (projectBase = (ProjectBase)((Reference)object).get()) != null) {
            return projectBase;
        }
        this.projectLock.readLock().lock();
        try {
            projectBase = null;
            if (this.projectRef instanceof ProjectBase) {
                projectBase = (ProjectBase)this.projectRef;
            } else if (this.projectRef instanceof Reference) {
                projectBase = (ProjectBase)((Reference)this.projectRef).get();
            }
            if (projectBase == null) {
                projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                if (bl) assert (projectBase != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
                this.projectRef = new WeakReference<ProjectBase>(projectBase);
            }
            ProjectBase projectBase2 = projectBase;
            return projectBase2;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    public final boolean isSourceFile() {
        return FileImpl.isSourceFileType(this.fileType);
    }

    public static boolean isSourceFileType(CsmFile.FileType fileType) {
        switch (fileType) {
            case SOURCE_CPP_FILE: 
            case SOURCE_C_FILE: 
            case SOURCE_FILE: 
            case SOURCE_FORTRAN_FILE: {
                return true;
            }
        }
        return false;
    }

    public boolean isCppFile() {
        return this.fileType == CsmFile.FileType.SOURCE_CPP_FILE;
    }

    void setSourceFile() {
        if (this.fileType != CsmFile.FileType.SOURCE_C_FILE && this.fileType != CsmFile.FileType.SOURCE_CPP_FILE && this.fileType != CsmFile.FileType.SOURCE_FORTRAN_FILE) {
            this.fileType = CsmFile.FileType.SOURCE_FILE;
        }
    }

    public boolean isHeaderFile() {
        return this.fileType == CsmFile.FileType.HEADER_FILE;
    }

    public CsmFile.FileType getFileType() {
        return this.fileType;
    }

    void setHeaderFile() {
        if (this.fileType == CsmFile.FileType.UNDEFINED_FILE) {
            this.fileType = CsmFile.FileType.HEADER_FILE;
        }
    }

    public APTLanguageFilter getLanguageFilter(APTPreprocHandler.State state) {
        FileImpl fileImpl;
        FileImpl fileImpl2 = fileImpl = state == null ? null : Utils.getStartFile(state);
        if (fileImpl != null && fileImpl != this) {
            return fileImpl.getLanguageFilter(null);
        }
        return APTLanguageSupport.getInstance().getFilter(this.getFileLanguage());
    }

    public String getFileLanguage() {
        String string;
        if (this.fileType == CsmFile.FileType.SOURCE_CPP_FILE) {
            string = "Gnu C++ Language";
        } else if (this.fileType == CsmFile.FileType.SOURCE_C_FILE) {
            string = "Gnu C Language";
        } else if (this.fileType == CsmFile.FileType.SOURCE_FORTRAN_FILE) {
            string = "Fortran Language";
        } else {
            string = "Gnu C++ Language";
            String string2 = ((Object)this.getName()).toString();
            if (string2.length() > 2 && string2.endsWith(".c")) {
                string = "Gnu C Language";
            }
        }
        return string;
    }

    public APTPreprocHandler getPreprocHandler(int n) {
        PreprocessorStatePair preprocessorStatePair = this.getContextPreprocStatePair(n, n);
        return this.getPreprocHandler(preprocessorStatePair);
    }

    private APTPreprocHandler getPreprocHandler(PreprocessorStatePair preprocessorStatePair) {
        if (preprocessorStatePair == null) {
            return null;
        }
        ProjectBase projectBase = this.getProjectImpl(true);
        if (projectBase == null) {
            return null;
        }
        return projectBase.getPreprocHandler(this.fileBuffer.getAbsolutePath(), preprocessorStatePair);
    }

    public Collection<APTPreprocHandler> getPreprocHandlers() {
        ProjectBase projectBase = this.getProjectImpl(true);
        return projectBase == null ? Collections.emptyList() : projectBase.getPreprocHandlers(this.getAbsolutePath());
    }

    public Collection<PreprocessorStatePair> getPreprocStatePairs() {
        ProjectBase projectBase = this.getProjectImpl(true);
        if (projectBase == null) {
            return Collections.emptyList();
        }
        return projectBase.getPreprocessorStatePairs(this.getAbsolutePath());
    }

    private PreprocessorStatePair getContextPreprocStatePair(int n, int n2) {
        ProjectBase projectBase = this.getProjectImpl(true);
        if (projectBase == null) {
            return null;
        }
        Collection<PreprocessorStatePair> collection = projectBase.getPreprocessorStatePairs(this.getAbsolutePath());
        for (PreprocessorStatePair preprocessorStatePair : collection) {
            if (!preprocessorStatePair.pcState.isInActiveBlock(n, n2)) continue;
            return preprocessorStatePair;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(FileBuffer fileBuffer) {
        Object object = this.changeStateLock;
        synchronized (object) {
            this.fileBuffer = fileBuffer;
            if (this.state != State.INITIAL || this.parsingState != ParsingState.NOT_BEING_PARSED) {
                if (reportParse || logState || TraceFlags.DEBUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.printf("#setBuffer changing to MODIFIED %s is %s with current state %s %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                }
                this.state = State.MODIFIED;
                this.postMarkedAsModified();
            }
        }
    }

    private void postMarkedAsModified() {
        this.tsRef.clear();
        if (this.parsingState == ParsingState.BEING_PARSED) {
            this.parsingState = ParsingState.MODIFIED_WHILE_BEING_PARSED;
        }
    }

    public FileBuffer getBuffer() {
        return this.fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void ensureParsed(Collection<APTPreprocHandler> collection) {
        try {
            Iterator<APTPreprocHandler> iterator;
            if (!this.inEnsureParsed.compareAndSet(false, true)) assert (false) : "concurrent ensureParsed in file " + this.getAbsolutePath() + (Object)((Object)this.parsingState) + (Object)((Object)this.state);
            boolean bl = false;
            if (collection == DUMMY_HANDLERS) {
                bl = true;
                collection = this.getPreprocHandlers();
            }
            Object object = this.stateLock;
            // MONITORENTER : object
            try {
                Object object2 = this.changeStateLock;
                // MONITORENTER : object2
                State state = this.state;
                this.parsingState = ParsingState.BEING_PARSED;
                // MONITOREXIT : object2
                if ((reportParse || logState || TraceFlags.DEBUG) && FileImpl.traceFile(this.getAbsolutePath())) {
                    System.err.printf("#ensureParsed %s is %s, has %d handlers, state %s %s dummy=%s\n", new Object[]{this.getAbsolutePath(), this.fileType, collection.size(), state, this.parsingState, bl});
                    int n = 0;
                    for (APTPreprocHandler aPTPreprocHandler : collection) {
                        this.logParse("EnsureParsed handler " + n++, aPTPreprocHandler);
                    }
                }
                if ((object2 = this.getFileAPT(true)) == null) {
                    return;
                }
                switch (state) {
                    case PARSED: 
                    case INITIAL: 
                    case PARTIAL: {
                        if (TraceFlags.TIMING_PARSE_PER_FILE_FLAT && state == State.PARSED) {
                            System.err.printf("additional parse with PARSED state " + (Object)((Object)this.parsingState) + "for %s\n", this.getAbsolutePath());
                        }
                        long l = System.currentTimeMillis();
                        try {
                            for (APTPreprocHandler aPTPreprocHandler : collection) {
                                this._parse(aPTPreprocHandler, (APTFile)object2);
                                if (this.parsingState != ParsingState.MODIFIED_WHILE_BEING_PARSED) continue;
                                break;
                            }
                        }
                        finally {
                            this.postParse();
                            iterator = this.changeStateLock;
                        }
                        if (!TraceFlags.DUMP_PARSE_RESULTS) return;
                        new CsmTracer().dumpModel((CsmFile)this);
                        return;
                    }
                    case MODIFIED: {
                        boolean bl2 = true;
                        long l = System.currentTimeMillis();
                        try {
                            for (APTPreprocHandler aPTPreprocHandler : collection) {
                                if (bl2) {
                                    this._reparse(aPTPreprocHandler, (APTFile)object2);
                                    bl2 = false;
                                } else {
                                    this._parse(aPTPreprocHandler, (APTFile)object2);
                                }
                                if (this.parsingState != ParsingState.MODIFIED_WHILE_BEING_PARSED) continue;
                                break;
                            }
                        }
                        finally {
                            Object object3 = this.changeStateLock;
                        }
                        if (!TraceFlags.DUMP_PARSE_RESULTS && !TraceFlags.DUMP_REPARSE_RESULTS) return;
                        new CsmTracer().dumpModel((CsmFile)this);
                        return;
                    }
                    default: {
                        System.err.println("unexpected state in ensureParsed " + (Object)((Object)state));
                        return;
                    }
                }
            }
            finally {
                iterator = this.changeStateLock;
            }
        }
        finally {
            if (!this.inEnsureParsed.compareAndSet(true, false)) assert (false) : "broken state in file " + this.getAbsolutePath() + (Object)((Object)this.parsingState) + (Object)((Object)this.state);
        }
    }

    private void postParse() {
        if (this.isValid()) {
            RepositoryUtils.put(this);
        }
        if (this.isValid()) {
            this.getProjectImpl(true).getGraph().putFile(this);
        }
        if (this.isValid()) {
            Notificator.instance().registerChangedFile(this);
            Notificator.instance().flush();
        } else {
            Notificator.instance().reset();
        }
    }

    void onProjectParseFinished(boolean bl) {
        if (this.fixFakeRegistrations(true)) {
            if (this.isValid()) {
                RepositoryUtils.put(this);
            }
            if (this.isValid()) {
                Notificator.instance().registerChangedFile(this);
                Notificator.instance().flush();
                ProgressSupport.instance().fireFileParsingFinished(this);
            } else {
                Notificator.instance().reset();
            }
        }
    }

    int getLastParseTime() {
        return this.lastParseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        Object object = this.changeStateLock;
        synchronized (object) {
            long l;
            if (this.state == State.PARSED && (l = this.getBuffer().lastModified()) != this.lastParsed) {
                if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_191307_BUG) {
                    System.err.printf("VALIDATED %s\n\t lastModified=%d\n\t   lastParsed=%d\n", this.getAbsolutePath(), l, this.lastParsed);
                }
                if (reportParse || logState || TraceFlags.DEBUG) {
                    System.err.printf("#validate changing to MODIFIED %s is %s with current state %s %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                }
                this.state = State.MODIFIED;
                this.postMarkedAsModified();
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markReparseNeeded(boolean bl) {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (reportParse || logState || TraceFlags.DEBUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("#markReparseNeeded %s is %s with current state %s, %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                if (TraceFlags.TRACE_191307_BUG) {
                    new Exception("markReparseNeeded is called").printStackTrace(System.err);
                }
            }
            if (this.state != State.INITIAL || this.parsingState != ParsingState.NOT_BEING_PARSED) {
                this.state = State.MODIFIED;
                this.postMarkedAsModified();
            }
            if (bl) {
                FileBuffer fileBuffer = this.getBuffer();
                APTDriver.invalidateAPT((APTFileBuffer)fileBuffer);
                APTFileCacheManager.getInstance((FileSystem)fileBuffer.getFileSystem()).invalidate(fileBuffer.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markMoreParseNeeded() {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (reportParse || logState || TraceFlags.DEBUG) {
                System.err.printf("#markMoreParseNeeded %s is %s with current state %s, %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
            }
            switch (this.state) {
                case PARSED: {
                    this.state = State.PARTIAL;
                    break;
                }
            }
        }
    }

    public final int getErrorCount() {
        return this.errorCount;
    }

    private APTFile getFileAPT(boolean bl) {
        APTFile aPTFile = null;
        FileBufferDoc.ChangedSegment changedSegment = null;
        try {
            aPTFile = bl ? APTDriver.findAPT((APTFileBuffer)this.getBuffer(), (String)this.getFileLanguage()) : APTDriver.findAPTLight((APTFileBuffer)this.getBuffer());
            if (this.getBuffer() instanceof FileBufferDoc) {
                changedSegment = ((FileBufferDoc)this.getBuffer()).getLastChangedSegment();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            APTUtils.LOG.log(Level.WARNING, "FileImpl: file {0} not found, probably removed", new Object[]{this.getBuffer().getAbsolutePath()});
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
        }
        return aPTFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reparse(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------ reparsing " + this.fileBuffer.getUrl());
        }
        Object object = this.snapShotLock;
        synchronized (object) {
            this.fileSnapshot = new FileSnapshot(this);
        }
        this.getFileIncludes().clean();
        this.hasBrokenIncludes.set(false);
        this.getFileMacros().clean();
        this.getFileReferences().clean();
        this.getFileInstantiations().clean();
        this._clearErrors();
        if (reportParse || logState || TraceFlags.DEBUG) {
            this.logParse("ReParsing", aPTPreprocHandler);
        }
        if ((object = this.doParse(aPTPreprocHandler, aPTFile)) != null && this.isValid()) {
            this.disposeAll(false);
            object.render(new Object[0]);
        }
        this.fileSnapshot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmFile getSnapshot() {
        Object object = this.snapShotLock;
        synchronized (object) {
            FileSnapshot fileSnapshot = this.fileSnapshot;
            if (fileSnapshot != null) {
                return fileSnapshot;
            }
            return new FileSnapshot(this);
        }
    }

    @Override
    public void dispose() {
        this.onDispose();
        Notificator.instance().registerRemovedFile(this);
        this.disposeAll(true);
    }

    public void onProjectClose() {
        this.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispose() {
        RepositoryUtils.disposeUID(this.uid, this);
        this.projectLock.writeLock().lock();
        try {
            if (this.projectRef == null) {
                this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (this.projectRef != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
            }
        }
        finally {
            this.projectLock.writeLock().unlock();
        }
    }

    private void disposeAll(boolean bl) {
        Collection collection = this.getFileDeclarations().clean();
        this.clearFakeRegistrations();
        if (bl) {
            this.clearStateCache();
            this.getFileIncludes().clean();
            this.hasBrokenIncludes.set(false);
            this.getFileMacros().clean();
            this.getFileInstantiations().clean();
            this._clearErrors();
        }
        Collection collection2 = UIDCsmConverter.UIDsToDeclarations(collection);
        Utils.disposeAll(collection2);
        RepositoryUtils.remove(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearErrors() {
        try {
            this.errorsLock.writeLock().lock();
            this.errors.clear();
        }
        finally {
            this.errorsLock.writeLock().unlock();
        }
    }

    private Set<ErrorDirectiveImpl> createErrors() {
        return new TreeSet<CsmOffsetable>(START_OFFSET_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AST debugParse() {
        Collection<APTPreprocHandler> collection = this.getPreprocHandlers();
        if (collection.isEmpty()) {
            return null;
        }
        APTFile aPTFile = this.getFileAPT(true);
        Object object = this.stateLock;
        synchronized (object) {
            CsmParserProvider.CsmParserResult csmParserResult = this._parse(collection.iterator().next(), aPTFile);
            Object object2 = csmParserResult.getAST();
            if (object2 instanceof AST) {
                return (AST)object2;
            }
        }
        return null;
    }

    private CsmParserProvider.CsmParserResult _parse(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        Diagnostic.StopWatch stopWatch;
        Diagnostic.StopWatch stopWatch2 = stopWatch = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
        if (reportParse || logState || TraceFlags.DEBUG) {
            this.logParse("Parsing", aPTPreprocHandler);
        }
        CsmParserProvider.CsmParserResult csmParserResult = this.doParse(aPTPreprocHandler, aPTFile);
        if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
            stopWatch.stopAndReport("Parsing of " + this.fileBuffer.getUrl() + " took \t");
        }
        if (csmParserResult != null) {
            Diagnostic.StopWatch stopWatch3;
            Diagnostic.StopWatch stopWatch4 = stopWatch3 = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
            if (this.isValid()) {
                csmParserResult.render(new Object[0]);
                if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
                    stopWatch3.stopAndReport("Rendering of " + this.fileBuffer.getUrl() + " took \t");
                }
            }
        }
        return csmParserResult;
    }

    private void logParse(String string, APTPreprocHandler aPTPreprocHandler) {
        if (reportParse || logState || TraceFlags.DEBUG) {
            System.err.printf("# %s %s \n#\t(%s %s %s) \n#\t(Thread=%s)\n", string, this.fileBuffer.getUrl(), TraceUtils.getPreprocStateString(aPTPreprocHandler.getState()), TraceUtils.getMacroString(aPTPreprocHandler, TraceFlags.logMacros), TraceUtils.getPreprocStartEntryString(aPTPreprocHandler.getState()), Thread.currentThread().getName());
            if (logState) {
                System.err.printf("%s\n\n", aPTPreprocHandler.getState());
            }
        }
    }

    private boolean createAndCacheFullTokenStream(int n, int n2, FileTokenStreamCache fileTokenStreamCache) {
        PreprocessorStatePair preprocessorStatePair = this.getContextPreprocStatePair(n, n2);
        APTPreprocHandler aPTPreprocHandler = this.getPreprocHandler(preprocessorStatePair);
        if (aPTPreprocHandler == null) {
            return false;
        }
        APTPreprocHandler.State state = aPTPreprocHandler.getState();
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicReference<Object> atomicReference2 = new AtomicReference<Object>(null);
        TokenStream tokenStream = this.createParsingTokenStreamForHandler(aPTPreprocHandler, false, atomicReference, atomicReference2);
        APTLanguageFilter aPTLanguageFilter = this.getLanguageFilter(state);
        fileTokenStreamCache.addNewPair(atomicReference2.get(), tokenStream, aPTLanguageFilter);
        this.setAPTCacheEntry(aPTPreprocHandler, atomicReference.get(), false);
        return true;
    }

    private TokenStream createParsingTokenStreamForHandler(APTPreprocHandler aPTPreprocHandler, boolean bl, AtomicReference<APTFileCacheEntry> atomicReference, AtomicReference<FilePreprocessorConditionState.Builder> atomicReference2) {
        APTFile aPTFile = this.getFileAPT(true);
        if (aPTFile == null) {
            return null;
        }
        if (aPTPreprocHandler == null) {
            return null;
        }
        APTPreprocHandler.State state = aPTPreprocHandler.getState();
        ProjectBase projectBase = Utils.getStartProject(state);
        if (projectBase == null) {
            System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state) + "\n while getting TS of file " + this.getAbsolutePath() + "\n of project " + this.getProject());
            return null;
        }
        FilePreprocessorConditionState.Builder builder = new FilePreprocessorConditionState.Builder(this.getAbsolutePath());
        if (atomicReference2 != null) {
            atomicReference2.set(builder);
        }
        APTFileCacheEntry aPTFileCacheEntry = this.getAPTCacheEntry(aPTPreprocHandler, Boolean.FALSE);
        if (atomicReference != null) {
            atomicReference.set(aPTFileCacheEntry);
        }
        APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker(projectBase, aPTFile, this, aPTPreprocHandler, false, builder, aPTFileCacheEntry);
        return aPTParseFileWalker.getTokenStream(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TokenStream getTokenStream(int n, int n2, int n3, boolean bl) {
        boolean bl2 = false;
        FileTokenStreamCache fileTokenStreamCache = this.tsRef.get();
        TokenStream tokenStream = fileTokenStreamCache == null ? null : fileTokenStreamCache.getTokenStreamInActiveBlock(bl, n, n2, n3);
        if (tokenStream != null) {
            if (bl2) {
                System.err.printf("found for %s %s stream [%d-%d]\n", this.getAbsolutePath(), bl ? "filtered" : "", n, n2);
            }
        } else {
            Object object = this.tokStreamLock;
            synchronized (object) {
                fileTokenStreamCache = this.tsRef.get();
                if (fileTokenStreamCache == null) {
                    fileTokenStreamCache = new FileTokenStreamCache();
                    this.tsRef = new SoftReference<FileTokenStreamCache>(fileTokenStreamCache);
                } else {
                    tokenStream = fileTokenStreamCache.getTokenStreamInActiveBlock(bl, n, n2, n3);
                }
                if (tokenStream == null) {
                    if (bl2) {
                        System.err.printf("creating for %s %s stream [%d-%d]\n", this.getAbsolutePath(), bl ? "filtered" : "", n, n2);
                    }
                    if (this.createAndCacheFullTokenStream(n, n2, fileTokenStreamCache)) {
                        tokenStream = fileTokenStreamCache.getTokenStreamInActiveBlock(bl, n, n2, n3);
                    }
                } else if (bl2) {
                    System.err.printf("found for just cached %s %s stream [%d-%d]\n", this.getAbsolutePath(), bl ? "filtered" : "", n, n2);
                }
            }
        }
        return tokenStream;
    }

    private TokenStream getTokenStreamOfIncludedFile(CsmInclude csmInclude) {
        FileImpl fileImpl = (FileImpl)csmInclude.getIncludeFile();
        if (fileImpl != null && fileImpl.isValid()) {
            PreprocessorStatePair preprocessorStatePair = this.getContextPreprocStatePair(csmInclude.getStartOffset(), csmInclude.getEndOffset());
            if (preprocessorStatePair == null) {
                return fileImpl.getTokenStream(0, Integer.MAX_VALUE, 0, true);
            }
            APTPreprocHandler.State state = preprocessorStatePair.state;
            LinkedList linkedList = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
            linkedList.addLast(new IncludeInfoImpl(csmInclude, fileImpl.getAbsolutePath()));
            ProjectBase projectBase = this.getProjectImpl(true);
            if (projectBase == null) {
                return fileImpl.getTokenStream(0, Integer.MAX_VALUE, 0, true);
            }
            APTPreprocHandler aPTPreprocHandler = projectBase.createEmptyPreprocHandler(this.getAbsolutePath());
            APTPreprocHandler aPTPreprocHandler2 = projectBase.restorePreprocHandlerFromIncludeStack(linkedList, this.getAbsolutePath(), aPTPreprocHandler, state);
            TokenStream tokenStream = fileImpl.createParsingTokenStreamForHandler(aPTPreprocHandler2, true, null, null);
            APTLanguageFilter aPTLanguageFilter = fileImpl.getLanguageFilter(state);
            return aPTLanguageFilter.getFilteredStream(tokenStream);
        }
        return null;
    }

    public void getErrors(ErrorListener errorListener) {
        ArrayList<RecognitionException> arrayList = new ArrayList<RecognitionException>();
        this.getErrors(arrayList);
        for (RecognitionException recognitionException : arrayList) {
            errorListener.error(recognitionException.getMessage(), recognitionException.getLine(), recognitionException.getColumn());
        }
    }

    public final APTFileCacheEntry getAPTCacheEntry(APTPreprocHandler aPTPreprocHandler, Boolean bl) {
        if (!TraceFlags.APT_FILE_CACHE_ENTRY) {
            return null;
        }
        APTFileCacheEntry aPTFileCacheEntry = APTFileCacheManager.getInstance((FileSystem)this.getBuffer().getFileSystem()).getEntry(this.getAbsolutePath(), aPTPreprocHandler, bl);
        assert (bl == null || aPTFileCacheEntry != null);
        return aPTFileCacheEntry;
    }

    public final void setAPTCacheEntry(APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry, boolean bl) {
        if (TraceFlags.APT_FILE_CACHE_ENTRY) {
            FileBuffer fileBuffer = this.getBuffer();
            APTFileCacheManager.getInstance((FileSystem)fileBuffer.getFileSystem()).setAPTCacheEntry(fileBuffer.getAbsolutePath(), aPTPreprocHandler, aPTFileCacheEntry, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyTokenBuffer getErrors(final Collection<RecognitionException> collection) {
        long l;
        block6: {
            ParserBasedTokenBuffer parserBasedTokenBuffer;
            CPPParserEx.ErrorDelegate errorDelegate = new CPPParserEx.ErrorDelegate(){

                @Override
                public void onError(RecognitionException recognitionException) {
                    collection.add(recognitionException);
                }
            };
            if (TraceFlags.TRACE_ERROR_PROVIDER) {
                System.err.printf("\n\n>>> Start parsing (getting errors) %s \n", this.getName());
            }
            l = TraceFlags.TRACE_ERROR_PROVIDER ? System.currentTimeMillis() : 0L;
            int n = 8;
            if (!TraceFlags.TRACE_ERROR_PROVIDER) {
                n |= 4;
            }
            try {
                TokenStream tokenStream = this.getTokenStream(0, Integer.MAX_VALUE, 0, true);
                if (tokenStream == null) break block6;
                CPPParserEx cPPParserEx = CPPParserEx.getInstance(this.fileBuffer.getFileObject().getNameExt(), tokenStream, n);
                cPPParserEx.setErrorDelegate(errorDelegate);
                cPPParserEx.setLazyCompound(false);
                cPPParserEx.translation_unit();
                parserBasedTokenBuffer = new ParserBasedTokenBuffer((Parser)cPPParserEx);
                if (!TraceFlags.TRACE_ERROR_PROVIDER) return parserBasedTokenBuffer;
            }
            catch (Throwable throwable) {
                try {
                    System.err.println(throwable.getClass().getName() + " at parsing file " + this.fileBuffer.getAbsolutePath());
                    if (!TraceFlags.TRACE_ERROR_PROVIDER) return null;
                }
                catch (Throwable throwable2) {
                    if (!TraceFlags.TRACE_ERROR_PROVIDER) throw throwable2;
                    System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
                    throw throwable2;
                }
                System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
                return null;
            }
            System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
            return parserBasedTokenBuffer;
        }
        if (!TraceFlags.TRACE_ERROR_PROVIDER) return null;
        System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - l);
        return null;
    }

    private CsmParserProvider.CsmParserResult doParse(APTPreprocHandler aPTPreprocHandler, APTFile aPTFile) {
        Object object;
        Object object2;
        if (reportErrors && !ParserThreadManager.instance().isParserThread() && !ParserThreadManager.instance().isStandalone()) {
            object2 = "Reparsing should be done only in a special Code Model Thread!!!";
            Diagnostic.trace(object2);
            new Throwable((String)object2).printStackTrace(System.err);
        }
        assert (aPTPreprocHandler != null);
        if (aPTPreprocHandler == null) {
            return null;
        }
        ParseStatistics.getInstance().fileParsed(this, aPTPreprocHandler);
        object2 = null;
        if (aPTFile != null) {
            ProjectBase projectBase;
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: parsing using full APT for " + this.getAbsolutePath());
            }
            if ((projectBase = Utils.getStartProject((APTPreprocHandler.State)(object = aPTPreprocHandler.getState()))) == null) {
                System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)object) + "\n while parsing file " + this.getAbsolutePath() + "\n of project " + this.getProject());
                return null;
            }
            FilePreprocessorConditionState.Builder builder = new FilePreprocessorConditionState.Builder(this.getAbsolutePath());
            APTFileCacheEntry aPTFileCacheEntry = this.getAPTCacheEntry(aPTPreprocHandler, Boolean.FALSE);
            APTParseFileWalker aPTParseFileWalker = new APTParseFileWalker(projectBase, aPTFile, this, aPTPreprocHandler, true, builder, aPTFileCacheEntry);
            aPTParseFileWalker.addMacroAndIncludes(true);
            if (TraceFlags.DEBUG) {
                System.err.println("doParse " + this.getAbsolutePath() + " with " + ParserQueue.tracePreprocState((APTPreprocHandler.State)object));
            }
            TokenStream tokenStream = aPTParseFileWalker.getFilteredTokenStream(this.getLanguageFilter((APTPreprocHandler.State)object));
            long l = emptyAstStatictics ? System.currentTimeMillis() : 0L;
            CsmParserProvider.CsmParser csmParser = CsmParserProvider.createParser(this);
            assert (csmParser != null) : "no parser for " + this;
            csmParser.init(this, tokenStream);
            object2 = csmParser.parse(CsmParserProvider.CsmParser.ConstructionKind.TRANSLATION_UNIT);
            FilePreprocessorConditionState filePreprocessorConditionState = builder.build();
            projectBase.setParsedPCState(this, (APTPreprocHandler.State)object, filePreprocessorConditionState);
            if (emptyAstStatictics) {
                l = System.currentTimeMillis() - l;
                boolean bl = object2.isEmptyAST();
                if (bl) {
                    System.err.println("PARSED FILE " + this.getAbsolutePath() + " HAS EMPTY AST" + ' ' + l + " ms");
                }
            }
            if (TraceFlags.DUMP_AST) {
                object2.dumpAST();
            }
            this.errorCount = object2.getErrorCount();
            if (this.parsingState == ParsingState.MODIFIED_WHILE_BEING_PARSED) {
                object2 = null;
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: not save cache for file modified during parsing" + this.getAbsolutePath());
                }
            }
        }
        this.clearStateCache();
        this.lastParsed = this.fileBuffer.lastModified();
        this.lastMacroUsages = null;
        if (TraceFlags.TRACE_VALIDATION) {
            System.err.printf("PARSED    %s \n\tlastModified=%d\n\t  lastParsed=%d  diff=%d\n", this.getAbsolutePath(), this.fileBuffer.lastModified(), this.lastParsed, this.fileBuffer.lastModified() - this.lastParsed);
        }
        if ((object = hook) != null) {
            object.parsingFinished(this, aPTPreprocHandler);
        }
        return object2;
    }

    public List<CsmReference> getLastMacroUsages() {
        Reference<List<CsmReference>> reference = this.lastMacroUsages;
        return reference != null ? reference.get() : null;
    }

    public void setLastMacroUsages(List<CsmReference> list) {
        this.lastMacroUsages = new SoftReference<List<CsmReference>>(Collections.unmodifiableList(list));
    }

    public long getLastParsedTime() {
        return this.lastParsed;
    }

    public void addInclude(IncludeImpl includeImpl, boolean bl) {
        boolean bl2 = this.getFileIncludes().addInclude(includeImpl, bl);
        if (this.hasBrokenIncludes.compareAndSet(!bl2, bl2) && this.isValid()) {
            RepositoryUtils.put(this);
        }
    }

    public void addInstantiation(CsmInstantiation csmInstantiation) {
        this.getFileInstantiations().addInstantiation(csmInstantiation);
    }

    public String getText(int n, int n2) {
        try {
            return this.fileBuffer.getText(n, n2);
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    public CharSequence getText() {
        try {
            return this.fileBuffer.getText();
        }
        catch (IOException iOException) {
            DiagnosticExceptoins.register(iOException);
            return "";
        }
    }

    public CsmProject getProject() {
        return this._getProject(false);
    }

    public CsmUID<CsmProject> getProjectUID() {
        return this.projectUID;
    }

    public ProjectBase getProjectImpl(boolean bl) {
        return this._getProject(bl);
    }

    public CharSequence getName() {
        return CharSequences.create((CharSequence)this.fileBuffer.getFileObject().getNameExt());
    }

    public Collection<CsmInclude> getIncludes() {
        return this.getFileIncludes().getIncludes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmErrorDirective> getErrors() {
        ArrayList<CsmErrorDirective> arrayList = new ArrayList<CsmErrorDirective>(0);
        try {
            this.errorsLock.readLock().lock();
            arrayList.addAll(this.errors);
        }
        finally {
            this.errorsLock.readLock().unlock();
        }
        return arrayList;
    }

    public Iterator<CsmInclude> getIncludes(CsmSelect.CsmFilter csmFilter) {
        return this.getFileIncludes().getIncludes(csmFilter);
    }

    public Collection<CsmInclude> getBrokenIncludes() {
        return this.getFileIncludes().getBrokenIncludes();
    }

    public boolean hasBrokenIncludes() {
        return this.hasBrokenIncludes.get();
    }

    public boolean hasDeclarations() {
        return this.getFileDeclarations().hasDeclarations();
    }

    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        return this.getFileDeclarations().getDeclarations();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        return this.getFileDeclarations().getDeclarations(csmFilter);
    }

    public int getDeclarationsSize() {
        return this.getFileDeclarations().getDeclarationsSize();
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findDeclarations(CsmDeclaration.Kind[] kindArray, CharSequence charSequence) {
        return this.getFileDeclarations().findDeclarations(kindArray, charSequence);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(int n, int n2) {
        return this.getFileDeclarations().getDeclarations(n, n2);
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(int n) {
        return this.getFileDeclarations().getDeclarations(n);
    }

    public Collection<CsmReference> getReferences() {
        return this.getFileReferences().getReferences();
    }

    public Collection<CsmReference> getReferences(Collection<CsmObject> collection) {
        return this.getFileReferences().getReferences(collection);
    }

    public boolean addReference(CsmReference csmReference, CsmObject csmObject) {
        return this.getFileReferences().addReference(csmReference, csmObject);
    }

    public CsmReference getReference(int n) {
        return this.getFileReferences().getReference(n);
    }

    public void addMacro(CsmMacro csmMacro) {
        this.getFileMacros().addMacro(csmMacro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addError(ErrorDirectiveImpl errorDirectiveImpl) {
        try {
            this.errorsLock.writeLock().lock();
            this.errors.add(errorDirectiveImpl);
        }
        finally {
            this.errorsLock.writeLock().unlock();
        }
    }

    public Collection<CsmMacro> getMacros() {
        return this.getFileMacros().getMacros();
    }

    public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter csmFilter) {
        return this.getFileMacros().getMacros(csmFilter);
    }

    public Collection<CsmUID<CsmMacro>> findMacroUids(CharSequence charSequence) {
        return this.getFileMacros().findMacroUids(charSequence);
    }

    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        return this.getFileDeclarations().findExistingDeclaration(n, n2, charSequence);
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        this.getFileDeclarations().addDeclaration(csmOffsetableDeclaration);
    }

    public Collection<CsmFunction> getStaticFunctionDeclarations() {
        return this.getFileDeclarations().getStaticFunctionDeclarations();
    }

    public Iterator<CsmFunction> getStaticFunctionDeclarations(CsmSelect.CsmFilter csmFilter) {
        return this.getFileDeclarations().getStaticFunctionDeclarations(csmFilter);
    }

    public Collection<CsmVariable> getStaticVariableDeclarations() {
        return this.getFileDeclarations().getStaticVariableDeclarations();
    }

    public Iterator<CsmVariable> getStaticVariableDeclarations(CsmSelect.CsmFilter csmFilter) {
        return this.getFileDeclarations().getStaticVariableDeclarations(csmFilter);
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        this.getFileDeclarations().removeDeclaration(csmOffsetableDeclaration);
    }

    public CharSequence getAbsolutePath() {
        return this.fileBuffer.getAbsolutePath();
    }

    public FileObject getFileObject() {
        return this.fileBuffer.getFileObject();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> arrayList = new ArrayList<CsmScopeElement>();
        arrayList.addAll(this.getStaticVariableDeclarations());
        arrayList.addAll(this.getStaticFunctionDeclarations());
        return arrayList;
    }

    public boolean isValid() {
        ProjectBase projectBase = this._getProject(false);
        return projectBase != null && projectBase.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLwmReady() {
        Object object = this.changeStateLock;
        synchronized (object) {
            this.state = State.PARSED;
            this.postParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final State getState() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public final String getStateFromTest() {
        assert (CndUtils.isUnitTestMode());
        return this.state.toString();
    }

    public final String getParsingStateFromTest() {
        assert (CndUtils.isUnitTestMode());
        return this.parsingState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsingOrParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED || this.parsingState != ParsingState.NOT_BEING_PARSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scheduleParsing(boolean bl) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.isParsed()) {
                String string = bl ? Thread.currentThread().getName() : "";
                try {
                    if (bl) {
                        StringBuilder stringBuilder = new StringBuilder(string);
                        stringBuilder.append(": scheduleParsing ").append(this.getAbsolutePath());
                        stringBuilder.append(" in states ").append((Object)this.state).append(", ").append((Object)this.parsingState);
                        Thread.currentThread().setName(stringBuilder.toString());
                    }
                    if (!this.isParsingOrParsed()) {
                        boolean bl2;
                        if (TRACE_SCHUDULE_PARSING) {
                            System.err.printf("scheduleParsing: enqueue %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                        }
                        if (!(bl2 = ParserQueue.instance().add(this, Collections.singleton(DUMMY_STATE), ParserQueue.Position.HEAD, false, ParserQueue.FileAction.NOTHING))) {
                            return;
                        }
                    }
                    if (!bl) return;
                    if (TRACE_SCHUDULE_PARSING) {
                        System.err.printf("scheduleParsing: waiting for %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                    }
                    this.stateLock.wait();
                    if (!TRACE_SCHUDULE_PARSING) continue;
                    System.err.printf("scheduleParsing: lock notified for %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                }
                finally {
                    if (!bl) continue;
                    Thread.currentThread().setName(string);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFakeRegisration(FunctionImplEx<?> functionImplEx, AST aST) {
        List<CsmUID<FunctionImplEx<?>>> list = this.fakeFunctionRegistrations;
        synchronized (list) {
            CsmUID<FunctionImplEx<?>> csmUID;
            CsmUID<FunctionImplEx<?>> csmUID2 = csmUID = UIDCsmConverter.declarationToUID(functionImplEx);
            this.fakeFunctionRegistrations.add(csmUID2);
            this.getProjectImpl(true).trackFakeFunctionAST(this.getUID(), csmUID2, aST);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onFakeIncludeRegistration(IncludeImpl includeImpl, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        List<FakeIncludePair> list = this.fakeIncludeRegistrations;
        synchronized (list) {
            if (includeImpl != null && csmOffsetableDeclaration != null) {
                CsmUID csmUID = UIDCsmConverter.identifiableToUID(includeImpl);
                CsmUID<CsmOffsetableDeclaration> csmUID2 = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
                if (csmUID != null && csmUID2 != null) {
                    for (FakeIncludePair fakeIncludePair : this.fakeIncludeRegistrations) {
                        if (!fakeIncludePair.includeUid.equals(csmUID)) continue;
                        if (!fakeIncludePair.containerUid.equals(csmUID2)) assert (false) : "trying to replace? " + includeImpl + " for container " + csmOffsetableDeclaration + " was: " + fakeIncludePair;
                        return false;
                    }
                    this.fakeIncludeRegistrations.add(new FakeIncludePair(csmUID, csmUID2));
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFakeRegistrations() {
        List<Object> list = this.fakeFunctionRegistrations;
        synchronized (list) {
            this.getProjectImpl(true).cleanAllFakeFunctionAST(this.getUID());
            this.fakeFunctionRegistrations.clear();
        }
        list = this.fakeIncludeRegistrations;
        synchronized (list) {
            this.fakeIncludeRegistrations.clear();
        }
    }

    private boolean fixFakeRegistrations(boolean bl) {
        boolean bl2 = false;
        bl2 |= this.fixFakeFunctionRegistrations(bl);
        return bl2 |= this.fixFakeIncludeRegistrations(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixFakeFunctionRegistrations(boolean bl) {
        boolean bl2 = false;
        List<CsmUID<FunctionImplEx<?>>> list = this.fakeFunctionRegistrations;
        synchronized (list) {
            if (!this.alreadyInFixFakeRegistrations) {
                this.alreadyInFixFakeRegistrations = true;
                if (this.fakeFunctionRegistrations.isEmpty() || !this.isValid()) {
                    this.alreadyInFixFakeRegistrations = false;
                    return false;
                }
                if (this.fakeFunctionRegistrations.size() > 0) {
                    for (int i = 0; i < this.fakeFunctionRegistrations.size(); ++i) {
                        CsmUID<FunctionImplEx<?>> csmUID = this.fakeFunctionRegistrations.get(i);
                        AST aST = this.getProjectImpl(true).getFakeFunctionAST(this.getUID(), csmUID);
                        CsmDeclaration csmDeclaration = (CsmDeclaration)csmUID.getObject();
                        if (csmDeclaration == null) continue;
                        if (csmDeclaration instanceof FunctionImplEx) {
                            bl2 = true;
                            FileImpl.incParseCount();
                            if (((FunctionImplEx)csmDeclaration).fixFakeRegistration(bl, aST)) {
                                this.getProjectImpl(true).trackFakeFunctionAST(this.getUID(), csmUID, null);
                            }
                            FileImpl.incParseCount();
                            continue;
                        }
                        DiagnosticExceptoins.register(new Exception("Incorrect fake registration class: " + csmDeclaration.getClass() + " for fake UID:" + csmUID));
                    }
                }
                this.alreadyInFixFakeRegistrations = false;
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixFakeIncludeRegistrations(boolean bl) {
        boolean bl2 = false;
        Iterator<FakeIncludePair> iterator = this.fakeIncludeRegistrations.iterator();
        while (iterator.hasNext()) {
            FakeIncludePair fakeIncludePair;
            FakeIncludePair fakeIncludePair2 = fakeIncludePair = iterator.next();
            synchronized (fakeIncludePair2) {
                FileImpl fileImpl;
                CsmOffsetableDeclaration csmOffsetableDeclaration;
                CsmInclude csmInclude;
                if (!fakeIncludePair.isFixed() && (csmInclude = (CsmInclude)UIDCsmConverter.UIDtoIdentifiable(fakeIncludePair.includeUid)) != null && (csmOffsetableDeclaration = (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(fakeIncludePair.containerUid)) != null && csmOffsetableDeclaration.isValid() && (fileImpl = (FileImpl)csmInclude.getIncludeFile()) != null && fileImpl.isValid()) {
                    TokenStream tokenStream = this.getTokenStreamOfIncludedFile(csmInclude);
                    if (tokenStream != null) {
                        Object object;
                        CsmParserProvider.CsmParser csmParser = CsmParserProvider.createParser(fileImpl);
                        assert (csmParser != null) : "no parser for " + this;
                        csmParser.init(this, tokenStream);
                        if (csmOffsetableDeclaration instanceof ClassImpl) {
                            object = (ClassImpl)csmOffsetableDeclaration;
                            CsmParserProvider.CsmParserResult csmParserResult = csmParser.parse(CsmParserProvider.CsmParser.ConstructionKind.CLASS_BODY);
                            CsmDeclaration.Kind kind = ((ClassImpl)object).getKind();
                            CsmVisibility csmVisibility = CsmVisibility.PRIVATE;
                            if (kind == CsmDeclaration.Kind.CLASS) {
                                csmVisibility = CsmVisibility.PRIVATE;
                            } else if (kind == CsmDeclaration.Kind.STRUCT || kind == CsmDeclaration.Kind.UNION) {
                                csmVisibility = CsmVisibility.PUBLIC;
                            }
                            csmParserResult.render(fileImpl, object, csmVisibility, Boolean.FALSE);
                            fakeIncludePair.markFixed();
                            bl2 = true;
                        } else if (csmOffsetableDeclaration instanceof NamespaceDefinitionImpl) {
                            object = csmParser.parse(CsmParserProvider.CsmParser.ConstructionKind.NAMESPACE_DEFINITION_BODY);
                            object.render(fileImpl, (NamespaceDefinitionImpl)csmOffsetableDeclaration);
                            fakeIncludePair.markFixed();
                            bl2 = true;
                        }
                    } else {
                        APTUtils.LOG.log(Level.WARNING, "fixFakeIncludeRegistrations: file {0} has not tokens, probably empty or removed?", new Object[]{this.getBuffer().getUrl()});
                    }
                }
            }
        }
        return bl2;
    }

    public String toString() {
        return "FileImpl @" + this.hashCode() + ":" + super.hashCode() + ' ' + this.getAbsolutePath() + " prj:" + System.identityHashCode(this.projectUID) + this.projectUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmFile> getUID() {
        CsmUID<CsmFile> csmUID = this.uid;
        if (csmUID == null) {
            FileImpl fileImpl = this;
            synchronized (fileImpl) {
                if (this.uid == null) {
                    this.uid = csmUID = UIDUtilities.createFileUID(this);
                }
            }
        }
        return this.uid;
    }

    public void write(DataOutput dataOutput) throws IOException {
        assert (this.projectUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, dataOutput);
        PersistentUtils.writeBuffer(this.fileBuffer, dataOutput);
        PersistentUtils.writeErrorDirectives(this.errors, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.fileDeclarationsKey.write(dataOutput);
        this.fileIncludesKey.write(dataOutput);
        dataOutput.writeBoolean(this.hasBrokenIncludes.get());
        this.fileMacrosKey.write(dataOutput);
        this.fileReferencesKey.write(dataOutput);
        this.fileInstantiationsKey.write(dataOutput);
        uIDObjectFactory.writeUIDCollection(this.fakeFunctionRegistrations, dataOutput, false);
        FakeIncludePair.write(this.fakeIncludeRegistrations, dataOutput);
        dataOutput.writeByte(this.fileType.ordinal());
        dataOutput.writeLong(this.lastParsed);
        dataOutput.writeInt(this.lastParseTime);
        State state = this.state;
        if (state != State.PARSED && state != State.INITIAL) {
            if (TraceFlags.TIMING) {
                System.err.printf("file is written in intermediate state %s, switching to PARSED: %s \n", new Object[]{state, this.getAbsolutePath()});
            }
            state = State.PARSED;
        }
        dataOutput.writeByte(state.ordinal());
    }

    public FileImpl(DataInput dataInput) throws IOException {
        this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        assert (this.projectUID != null);
        this.projectRef = null;
        this.fileBuffer = PersistentUtils.readBuffer(dataInput);
        PersistentUtils.readErrorDirectives(this.errors, dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.fileDeclarationsKey = new FileDeclarationsKey(dataInput);
        assert (this.fileDeclarationsKey != null) : "file declaratios key can not be null";
        this.weakFileDeclarations = new ProjectBase.WeakContainer(this._getProject(false), this.fileDeclarationsKey);
        this.fileIncludesKey = new FileIncludesKey(dataInput);
        assert (this.fileIncludesKey != null) : "file includes key can not be null";
        this.weakFileIncludes = new ProjectBase.WeakContainer(this._getProject(false), this.fileIncludesKey);
        this.hasBrokenIncludes = new AtomicBoolean(dataInput.readBoolean());
        this.fileMacrosKey = new FileMacrosKey(dataInput);
        assert (this.fileMacrosKey != null) : "file macros key can not be null";
        this.weakFileMacros = new ProjectBase.WeakContainer(this._getProject(false), this.fileMacrosKey);
        this.fileReferencesKey = new FileReferencesKey(dataInput);
        assert (this.fileReferencesKey != null) : "file referebces key can not be null";
        this.weakFileReferences = new ProjectBase.WeakContainer(this._getProject(false), this.fileReferencesKey);
        this.fileInstantiationsKey = new FileInstantiationsKey(dataInput);
        assert (this.fileInstantiationsKey != null) : "file instantiation references key can not be null";
        this.weakFileInstantiationReferences = new ProjectBase.WeakContainer(this._getProject(false), this.fileInstantiationsKey);
        uIDObjectFactory.readUIDCollection(this.fakeFunctionRegistrations, dataInput);
        FakeIncludePair.read(this.fakeIncludeRegistrations, dataInput);
        this.fileType = CsmFile.FileType.values()[dataInput.readByte()];
        assert (this.fileBuffer != null);
        this.lastParsed = dataInput.readLong();
        this.lastParseTime = dataInput.readInt();
        this.state = State.values()[dataInput.readByte()];
        this.parsingState = ParsingState.NOT_BEING_PARSED;
    }

    public int hashCode() {
        if (this.hash == 0) {
            String string = this.getProjectImpl(true).getUniqueName() + "*" + this.getAbsolutePath();
            this.hash = string.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileImpl)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        FileImpl fileImpl = (FileImpl)object;
        if (this.getAbsolutePath().equals(fileImpl.getAbsolutePath())) {
            return this.getProjectImpl(true).getUniqueName().equals(fileImpl.getProjectImpl(true).getUniqueName());
        }
        return false;
    }

    public int getOffset(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("line and column are 1-based");
        }
        try {
            return this.fileBuffer.getOffsetByLineColumn(n, n2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return -1;
        }
    }

    public int[] getLineColumn(int n) {
        if (n == Integer.MAX_VALUE) {
            try {
                n = this.fileBuffer.getCharBuffer().length;
            }
            catch (IOException iOException) {
                DiagnosticExceptoins.register(iOException);
                n = 0;
            }
        }
        try {
            return this.fileBuffer.getLineColumnByOffset(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            return new int[]{0, 0};
        }
    }

    void cacheVisitedState(APTPreprocHandler.State state, APTPreprocHandler aPTPreprocHandler, FilePreprocessorConditionState filePreprocessorConditionState) {
        this.stateCache.cacheVisitedState(state, aPTPreprocHandler, filePreprocessorConditionState);
    }

    PreprocessorStatePair getCachedVisitedState(APTPreprocHandler.State state) {
        return this.stateCache.getCachedVisitedState(state);
    }

    void clearStateCache() {
        this.tsRef.clear();
        this.stateCache.clearStateCache();
        FileBuffer fileBuffer = this.getBuffer();
        APTFileCacheManager.getInstance((FileSystem)fileBuffer.getFileSystem()).invalidate(fileBuffer.getAbsolutePath());
    }

    private FileComponentDeclarations getFileDeclarations() {
        FileComponentDeclarations fileComponentDeclarations = this.weakFileDeclarations.getContainer();
        return fileComponentDeclarations != null ? fileComponentDeclarations : FileComponentDeclarations.empty();
    }

    private FileComponentMacros getFileMacros() {
        FileComponentMacros fileComponentMacros = this.weakFileMacros.getContainer();
        return fileComponentMacros != null ? fileComponentMacros : FileComponentMacros.empty();
    }

    private FileComponentIncludes getFileIncludes() {
        FileComponentIncludes fileComponentIncludes = this.weakFileIncludes.getContainer();
        return fileComponentIncludes != null ? fileComponentIncludes : FileComponentIncludes.empty();
    }

    private FileComponentReferences getFileReferences() {
        FileComponentReferences fileComponentReferences = this.weakFileReferences.getContainer();
        return fileComponentReferences != null ? fileComponentReferences : FileComponentReferences.empty();
    }

    private FileComponentInstantiations getFileInstantiations() {
        FileComponentInstantiations fileComponentInstantiations = this.weakFileInstantiationReferences.getContainer();
        return fileComponentInstantiations != null ? fileComponentInstantiations : FileComponentInstantiations.empty();
    }

    public static boolean traceFile(CharSequence charSequence) {
        if (TraceFlags.TRACE_FILE_NAME != null) {
            if (TraceFlags.TRACE_FILE_NAME.length() == 0) {
                return true;
            }
            return ((Object)charSequence).toString().endsWith(TraceFlags.TRACE_FILE_NAME);
        }
        return false;
    }

    public void dumpInfo(PrintWriter printWriter) {
        ProjectBase projectBase = this.getProjectImpl(false);
        printWriter.printf("FI: %s, of %s prj=%s disposing=%s (%d)\n\tprjUID=(%d) %s\n\tfileType=%s, hasSnap=%s hasBroken=%s\n", this.getName(), projectBase.getClass().getSimpleName(), projectBase.getName(), projectBase.isDisposing(), System.identityHashCode(projectBase), System.identityHashCode(this.projectUID), this.projectUID, this.fileType, FileImpl.toYesNo(this.fileSnapshot != null), FileImpl.toYesNo(this.hasBrokenIncludes.get()));
        if (this.hasBrokenIncludes.get()) {
            // empty if block
        }
        printWriter.printf("\tlastParsedTime=%d, lastParsed=%d %s %s\n", new Object[]{this.lastParseTime, this.lastParsed, this.parsingState, this.state});
        FileBuffer fileBuffer = this.getBuffer();
        printWriter.printf("\tfileBuf=%s lastModified=%d\n", FileImpl.toYesNo(fileBuffer.isFileBased()), fileBuffer.lastModified());
    }

    public void dumpPPStates(PrintWriter printWriter) {
        int n = 0;
        Collection<PreprocessorStatePair> collection = this.getPreprocStatePairs();
        printWriter.printf("Has %d ppStatePairs:\n", collection.size());
        for (PreprocessorStatePair object2 : collection) {
            printWriter.printf("----------------Pair[%d]------------------------\n", ++n);
            printWriter.printf("pc=%s\nstate=%s\n", object2.pcState, object2.state);
        }
        Collection<APTPreprocHandler> collection2 = this.getPreprocHandlers();
        printWriter.printf("Converted into %d Handlers:\n", collection2.size());
        n = 0;
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            APTPreprocHandler aPTPreprocHandler = (APTPreprocHandler)iterator.next();
            printWriter.printf("----------------Handler[%d]------------------------\n", ++n);
            printWriter.printf("handler=%s\n", aPTPreprocHandler);
        }
    }

    static String toYesNo(boolean bl) {
        return bl ? "yes" : "no";
    }

    private static class EmptyCollection<T>
    extends AbstractCollection<T> {
        private EmptyCollection() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    private static final class FakeIncludePair {
        private final CsmUID<IncludeImpl> includeUid;
        private final CsmUID<CsmOffsetableDeclaration> containerUid;
        private volatile boolean alreadyFixed;

        public FakeIncludePair(CsmUID<IncludeImpl> csmUID, CsmUID<CsmOffsetableDeclaration> csmUID2) {
            this.includeUid = csmUID;
            this.containerUid = csmUID2;
            this.alreadyFixed = false;
        }

        boolean isFixed() {
            return this.alreadyFixed;
        }

        void markFixed() {
            assert (!this.alreadyFixed);
            this.alreadyFixed = true;
        }

        private void write(DataOutput dataOutput) throws IOException {
            UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
            uIDObjectFactory.writeUID(this.includeUid, dataOutput);
            uIDObjectFactory.writeUID(this.containerUid, dataOutput);
            dataOutput.writeBoolean(this.alreadyFixed);
        }

        private FakeIncludePair(DataInput dataInput) throws IOException {
            UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
            this.includeUid = uIDObjectFactory.readUID(dataInput);
            this.containerUid = uIDObjectFactory.readUID(dataInput);
            this.alreadyFixed = dataInput.readBoolean();
        }

        private static void write(List<FakeIncludePair> list, DataOutput dataOutput) throws IOException {
            assert (dataOutput != null);
            ArrayList<FakeIncludePair> arrayList = new ArrayList<FakeIncludePair>(list);
            int n = arrayList.size();
            dataOutput.writeInt(n);
            for (FakeIncludePair fakeIncludePair : arrayList) {
                assert (fakeIncludePair != null);
                fakeIncludePair.write(dataOutput);
            }
        }

        private static void read(List<FakeIncludePair> list, DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            for (int i = 0; i < n; ++i) {
                FakeIncludePair fakeIncludePair = new FakeIncludePair(dataInput);
                list.add(fakeIncludePair);
            }
        }

        public String toString() {
            return "FakeIncludePair{includeUid=" + this.includeUid + ", containerUid=" + this.containerUid + ", alreadyFixed=" + this.alreadyFixed + '}';
        }
    }

    private static class ParserBasedTokenBuffer
    implements ReadOnlyTokenBuffer {
        private final Parser parser;

        public ParserBasedTokenBuffer(Parser parser) {
            this.parser = parser;
        }

        @Override
        public int LA(int n) {
            return this.parser.LA(n);
        }

        @Override
        public Token LT(int n) {
            return this.parser.LT(n);
        }
    }

    public static interface ErrorListener {
        public void error(String var1, int var2, int var3);
    }

    private static class IncludeInfoImpl
    implements APTIncludeHandler.IncludeInfo {
        private final int line;
        private final CsmInclude include;
        private final CharSequence path;

        IncludeInfoImpl(CsmInclude csmInclude, CharSequence charSequence) {
            this.line = csmInclude.getStartPosition().getLine();
            this.include = csmInclude;
            this.path = charSequence;
        }

        public CharSequence getIncludedPath() {
            return this.path;
        }

        public int getIncludeDirectiveLine() {
            return this.line;
        }

        public int getIncludeDirectiveOffset() {
            return this.include.getStartOffset();
        }

        public int getIncludedDirIndex() {
            return 0;
        }

        public String toString() {
            return "restore " + this.include + " from line " + this.line + " in file " + this.include.getContainingFile();
        }
    }

    private static final class TokenStreamLock {
        private TokenStreamLock() {
        }
    }

    private static final class ChangeStateLock {
        private ChangeStateLock() {
        }
    }

    public static interface Hook {
        public void parsingFinished(CsmFile var1, APTPreprocHandler var2);
    }

    private static final class StateLock {
        private StateLock() {
        }
    }

    private static enum ParsingState {
        NOT_BEING_PARSED,
        MODIFIED_WHILE_BEING_PARSED,
        BEING_PARSED;

    }

    public static enum State {
        INITIAL,
        PARSED,
        PARTIAL,
        MODIFIED;

    }
}

