/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentReferences
extends FileComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE = false;
    private final SortedMap<ReferenceImpl, CsmUID<CsmObject>> references;
    private final ReadWriteLock referencesLock = new ReentrantReadWriteLock();
    private final CsmUID<CsmFile> fileUID;
    private static final FileComponentReferences EMPTY = new FileComponentReferences(){

        @Override
        public void put() {
        }
    };

    public static boolean isKindOf(CsmReference csmReference, Set<CsmReferenceKind> set) {
        return csmReference instanceof ReferenceImpl && set.contains(csmReference.getKind());
    }

    public static FileComponentReferences empty() {
        return EMPTY;
    }

    public FileComponentReferences(FileImpl fileImpl) {
        super(new FileReferencesKey(fileImpl));
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = fileImpl.getUID();
        this.put();
    }

    public FileComponentReferences(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.fileUID = uIDObjectFactory.readUID(dataInput);
        int n = dataInput.readInt();
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        for (int i = 0; i < n; ++i) {
            CsmUID csmUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
            ReferenceImpl referenceImpl = new ReferenceImpl(this.fileUID, csmUID, uIDObjectFactory, dataInput);
            this.references.put(referenceImpl, csmUID);
        }
    }

    private FileComponentReferences() {
        super((Key)null);
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() {
        this.referencesLock.writeLock().lock();
        try {
            this.references.clear();
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmReference> getReferences(Collection<CsmObject> collection) {
        HashSet<CsmUID> hashSet = new HashSet<CsmUID>(collection.size());
        for (CsmObject object : collection) {
            CsmUID csmUID = UIDs.get((Object)object);
            hashSet.add(csmUID);
        }
        ArrayList arrayList = new ArrayList();
        this.referencesLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                if (!hashSet.contains(entry.getValue())) continue;
                arrayList.add(entry.getKey());
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmReference> getReferences() {
        ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
        this.referencesLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                arrayList.add(entry.getKey());
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmReference getReference(int n) {
        this.referencesLock.readLock().lock();
        try {
            Iterator<Map.Entry<ReferenceImpl, CsmUID<CsmObject>>> iterator = this.references.tailMap(new ReferenceImpl(n)).entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry = iterator.next();
                if (entry.getKey().start <= n && n < entry.getKey().end) {
                    CsmReference csmReference = entry.getKey();
                    return csmReference;
                }
                CsmReference csmReference = null;
                return csmReference;
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addReference(CsmReference csmReference, CsmObject csmObject) {
        if (!UIDCsmConverter.isIdentifiable(csmObject)) {
            return false;
        }
        CsmUID csmUID = UIDs.get((Object)csmObject);
        if (!UIDProviderIml.isPersistable(csmUID)) {
            return false;
        }
        CsmObject csmObject2 = csmReference.getOwner();
        CsmUID<CsmObject> csmUID2 = this.getUID(csmObject2, "Ignore local owners ", false);
        CsmObject csmObject3 = csmReference.getClosestTopLevelObject();
        CsmUID<CsmObject> csmUID3 = this.getUID(csmObject3, "Why local top level object? ", true);
        assert (csmUID3 == null || UIDProviderIml.isPersistable(csmUID3)) : "not persistable top level object " + csmObject3;
        ReferenceImpl referenceImpl = new ReferenceImpl(this.fileUID, csmReference, csmUID, csmUID2, csmUID3);
        this.referencesLock.writeLock().lock();
        try {
            this.references.put(referenceImpl, (CsmUID<CsmObject>)csmUID);
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
        return true;
    }

    private CsmUID<CsmObject> getUID(CsmObject csmObject, String string, boolean bl) {
        CsmUID csmUID = null;
        if (csmObject != null) {
            if (UIDCsmConverter.isIdentifiable(csmObject)) {
                CsmUID csmUID2 = UIDs.get((Object)csmObject);
                if (UIDProviderIml.isPersistable(csmUID2)) {
                    csmUID = csmUID2;
                } else if (bl) {
                    Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{string, csmObject, new Exception()});
                }
            } else if (bl) {
                Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{string, csmObject, new Exception()});
            }
        }
        return csmUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUID(this.fileUID, dataOutput);
        this.referencesLock.readLock().lock();
        try {
            dataOutput.writeInt(this.references.size());
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                uIDObjectFactory.writeUID(entry.getValue(), dataOutput);
                entry.getKey().write(uIDObjectFactory, dataOutput);
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    private static final class ReferenceImpl
    implements CsmReference,
    Comparable<ReferenceImpl> {
        private final CsmUID<CsmFile> file;
        private final CsmReferenceKind refKind;
        private final CsmUID<CsmObject> refObj;
        private final int start;
        private final int end;
        private final CharSequence identifier;
        private final CsmUID<CsmObject> ownerUID;
        private final CsmUID<CsmObject> closestTopLevelObjectUID;

        private ReferenceImpl(int n) {
            this.start = n;
            this.end = n;
            this.file = null;
            this.refKind = null;
            this.refObj = null;
            this.identifier = null;
            this.ownerUID = null;
            this.closestTopLevelObjectUID = null;
        }

        private ReferenceImpl(CsmUID<CsmFile> csmUID, CsmReference csmReference, CsmUID<CsmObject> csmUID2, CsmUID<CsmObject> csmUID3, CsmUID<CsmObject> csmUID4) {
            this.file = csmUID;
            this.refKind = csmReference.getKind();
            this.refObj = csmUID2;
            assert (csmUID2 != null);
            this.start = PositionManager.createPositionID(csmUID, csmReference.getStartOffset(), PositionManager.Position.Bias.FOWARD);
            this.end = PositionManager.createPositionID(csmUID, csmReference.getEndOffset(), PositionManager.Position.Bias.BACKWARD);
            this.identifier = NameCache.getManager().getString(csmReference.getText());
            this.ownerUID = csmUID3;
            this.closestTopLevelObjectUID = csmUID4;
        }

        private ReferenceImpl(CsmUID<CsmFile> csmUID, CsmUID<CsmObject> csmUID2, UIDObjectFactory uIDObjectFactory, DataInput dataInput) throws IOException {
            this.file = csmUID;
            this.refObj = csmUID2;
            assert (csmUID2 != null);
            this.start = dataInput.readInt();
            this.end = dataInput.readInt();
            this.identifier = PersistentUtils.readUTF(dataInput, NameCache.getManager());
            this.refKind = CsmReferenceKind.values()[dataInput.readByte()];
            this.ownerUID = uIDObjectFactory.readUID(dataInput);
            this.closestTopLevelObjectUID = uIDObjectFactory.readUID(dataInput);
        }

        private void write(UIDObjectFactory uIDObjectFactory, DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            dataOutput.writeInt(this.end);
            PersistentUtils.writeUTF(this.identifier, dataOutput);
            dataOutput.writeByte(this.refKind.ordinal());
            uIDObjectFactory.writeUID(this.ownerUID, dataOutput);
            uIDObjectFactory.writeUID(this.closestTopLevelObjectUID, dataOutput);
        }

        public CsmReferenceKind getKind() {
            return this.refKind;
        }

        public CsmObject getReferencedObject() {
            CsmObject csmObject = UIDCsmConverter.UIDtoCsmObject(this.refObj);
            if (csmObject == null) {
                Logger.getLogger("xRef").log(Level.INFO, "how can we store nulls? {0}", this.refObj);
            }
            return csmObject;
        }

        public CsmObject getOwner() {
            return UIDCsmConverter.UIDtoCsmObject(this.ownerUID);
        }

        public CsmObject getClosestTopLevelObject() {
            return UIDCsmConverter.UIDtoCsmObject(this.closestTopLevelObjectUID);
        }

        public CsmFile getContainingFile() {
            return (CsmFile)this.file.getObject();
        }

        public int getStartOffset() {
            return PositionManager.getOffset(this.file, this.start);
        }

        public int getEndOffset() {
            return PositionManager.getOffset(this.file, this.end);
        }

        public CsmOffsetable.Position getStartPosition() {
            return PositionManager.getPosition(this.file, this.start);
        }

        public CsmOffsetable.Position getEndPosition() {
            return PositionManager.getPosition(this.file, this.end);
        }

        public CharSequence getText() {
            return this.identifier;
        }

        public int hashCode() {
            int n = 5;
            n = 17 * n + this.start;
            n = 17 * n + this.end;
            n = 17 * n + (this.identifier != null ? this.identifier.hashCode() : 0);
            return n;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ReferenceImpl referenceImpl = (ReferenceImpl)object;
            if (this.start != referenceImpl.start) {
                return false;
            }
            if (this.end != referenceImpl.end) {
                return false;
            }
            return this.identifier == referenceImpl.identifier || this.identifier != null && this.identifier.equals(referenceImpl.identifier);
        }

        @Override
        public int compareTo(ReferenceImpl referenceImpl) {
            int n = this.start - referenceImpl.end;
            if (n > 0) {
                return n;
            }
            n = this.end - referenceImpl.start;
            if (n < 0) {
                return n;
            }
            n = 0;
            if (this.identifier != null && referenceImpl.identifier != null) {
                n = this.identifier.hashCode() - referenceImpl.identifier.hashCode();
            }
            return n;
        }

        public String toString() {
            return "ReferenceImpl{file=" + this.file + ";refKind=" + this.refKind + ";refObj=" + this.refObj + ";start=" + this.start + ";end=" + this.end + ";identifier=" + this.identifier + ";topUID=" + this.closestTopLevelObjectUID + ";ownerUID=" + this.ownerUID + '}';
        }
    }
}

